/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.OrderDocument;

import java.math.BigDecimal;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.tests.OrderDocument.ODS;
import org.modellwerkstatt.objectflow.tests.OrderDocument.ODTF;
import org.modellwerkstatt.objectflow.tests.OrderDocument.OrderDocument;
import org.modellwerkstatt.objectflow.tests.OrderDocument.OrderDocumentPos;
import org.modellwerkstatt.objectflow.tests.OrderDocument.OrderDocument_OrderDocStatus;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderDocTests
extends OFXTestSuit {
    @Autowired
    private ODTF __OrderDocumentODTF;
    @Autowired
    private ODS __OrderDocumentODS;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;
    @Autowired
    private IOFXApplicationFactory appFact;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    @OFXTestMethod(id=0, name="Illustrative case: totalamount is amount of positions", debug=false, enabled=true, runAt="")
    public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("Totalamount test", 5, new BigDecimal("20.0"), __manMapSession);
        od.setRemark("");
        Comparable<OrderDocument_OrderDocStatus> leftSide = od.getStatus();
        Comparable<OrderDocument_OrderDocStatus> rightSide = OrderDocument_OrderDocStatus.DRAFT;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'OrderDocTests.Illustrative case: totalamount is amount of positions':  od .status == \"OrderDocStatus.Draft\"          ==>>" + (OrderDocument_OrderDocStatus)leftSide + " ==" + rightSide + "\n");
        }
        od.calcAggregate();
        leftSide = od.getTotalValue().getAmount();
        rightSide = new BigDecimal("100.0");
        if (((BigDecimal)leftSide).compareTo((BigDecimal)rightSide) != 0) {
            throw new OFXTestSuitException("'OrderDocTests.Illustrative case: totalamount is amount of positions':  od .totalValue.amount == 100.0bd          ==>>" + leftSide + " ==" + (BigDecimal)rightSide + "\n");
        }
    }

    @OFXTestMethod(id=1, name="Generating some Warnings without interrupting control flow.", debug=false, enabled=true, runAt="")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("State change test", 5, new BigDecimal("20.0"), __manMapSession);
        this.__OrderDocumentODS.checkAndSetEdititing(od, __manMapSession);
        this.__OrderDocumentODS.order(od, __manMapSession);
        List listOfProblems = __manMapSession.getAndclearProblemState();
        int leftSide = ListSequence.fromList((List)listOfProblems).count();
        int rightSide = 3;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'OrderDocTests.Generating some Warnings without interrupting control flow.':  listOfProblems .size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        if (!ListSequence.fromList((List)listOfProblems).all(it -> it.isWarningOnly())) {
            throw new OFXTestSuitException("'OrderDocTests.Generating some Warnings without interrupting control flow.':  listOfProblems .all          ==>> FALSE !\n");
        }
    }

    @OFXTestMethod(id=2, name="Illustrative case: Ordering a document changes state", debug=false, enabled=true, runAt="")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("State change test", 5, new BigDecimal("20.0"), __manMapSession);
        this.__testmethod_1(__manMapSession, __testSuitHandler);
        Comparable<BigDecimal> leftSide = od.getTotalValue().getAmount();
        Comparable<BigDecimal> rightSide = new BigDecimal("100.0");
        if (leftSide.compareTo((BigDecimal)rightSide) != 0) {
            throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document changes state':  od .totalValue.amount == 100.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        this.__OrderDocumentODS.order(od, __manMapSession);
        leftSide = od.getStatus();
        rightSide = OrderDocument_OrderDocStatus.ORDERED;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document changes state':  od .status == \"OrderDocStatus.Ordered\"          ==>>" + (OrderDocument_OrderDocStatus)leftSide + " ==" + (OrderDocument_OrderDocStatus)rightSide + "\n");
        }
    }

    @OFXTestMethod(id=3, name="Illustrative case: Ordering a document precondition raises problem", debug=false, enabled=true, runAt="")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        List problems;
        int leftSide;
        block11: {
            OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("State change test", 5, new BigDecimal("20.0"), __manMapSession);
            od.setStatus(OrderDocument_OrderDocStatus.ORDERED);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            OFXAbortedException __FailIn_origThrowable = null;
            String messagesInProblems = "";
            try {
                this.__OrderDocumentODS.order(od, __manMapSession);
            }
            catch (OFXAbortedException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem': Fail In Exception OFXAbortedException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block11;
                throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        if ((leftSide = ListSequence.fromList((List)(problems = __manMapSession.getAndclearProblemState())).count()) != (rightSide = 1)) {
            throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem':  problems .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        if (!ListSequence.fromList((List)problems).all(it -> !it.isWarningOnly())) {
            throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Ordering a document precondition raises problem':  problems .all          ==>> FALSE !\n");
        }
    }

    @OFXTestMethod(id=4, name="Illustrative case: Different currencies trigger guard.", debug=false, enabled=true, runAt="")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int leftSide;
        block13: {
            OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("Trigger guard test", 5, new BigDecimal("20.0"), __manMapSession);
            ((OrderDocumentPos)((Object)ListSequence.fromList(od.getPositions()).first())).setVal(((OrderDocumentPos)((Object)ListSequence.fromList(od.getPositions()).first())).getVal().withCurrency("SFR"));
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            OFXShutDownSessionException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                od.calcAggregate();
            }
            catch (OFXShutDownSessionException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("Different currencies are not suppored yet")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("Different currencies are not suppored yet")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Different currencies trigger guard.': Fail In Exception OFXShutDownSessionException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Different currencies trigger guard.': Fail In Exception OFXShutDownSessionException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block13;
                throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Different currencies trigger guard.': Fail In Exception 'OFXShutDownSessionException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        if ((leftSide = ListSequence.fromList((List)__manMapSession.getAndclearProblemState()).count()) != (rightSide = 0)) {
            throw new OFXTestSuitException("'OrderDocTests.Illustrative case: Different currencies trigger guard.':  session .getAndclearProblemState().size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=5, name="Trigger gard with instance and solution desc", debug=false, enabled=true, runAt="")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("Trigger guard test2", 5, new BigDecimal("20.0"), __manMapSession);
        try {
            od.triggerGuardWithInstanceAndSolution();
            throw new RuntimeException("We should never get here.");
        }
        catch (OFXShutDownSessionException ex) {
            boolean bl = ListSequence.fromList((List)__manMapSession.getAndclearProblemState()).count();
            boolean rightSide = false;
            if (bl != rightSide) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  session .getAndclearProblemState().size == 0          ==>>" + (int)(bl ? 1 : 0) + " ==" + (int)(rightSide ? 1 : 0) + "\n");
            }
            if (!OrderDocTests.isNotEmptyString(ex.getProblem().getProblemDescOrNull())) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  ex .getProblem().getProblemDescOrNull().isNotEmpty          ==>> FALSE !\n");
            }
            if (!OrderDocTests.isNotEmptyString(ex.getProblem().getInstanceDescOrNull())) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  ex .getProblem().getInstanceDescOrNull().isNotEmpty          ==>> FALSE !\n");
            }
            boolean bl2 = ex.getProblem().hasForwardedEx();
            if (bl2 != (rightSide = false)) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  ex .getProblem().hasForwardedEx() == \"false\"          ==>>" + bl2 + " ==" + rightSide + "\n");
            }
            boolean bl3 = ex.getProblem().isFromGuard();
            if (bl3 != (rightSide = true)) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with instance and solution desc':  ex .getProblem().isFromGuard() == \"true\"          ==>>" + bl3 + " ==" + rightSide + "\n");
            }
            return;
        }
    }

    @OFXTestMethod(id=6, name="Trigger gard with forwarded ex", debug=false, enabled=true, runAt="")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);
        try {
            od.triggerGuardWithEX();
            throw new RuntimeException("We should never get here.");
        }
        catch (OFXShutDownSessionException ex) {
            boolean bl = ListSequence.fromList((List)__manMapSession.getAndclearProblemState()).count();
            boolean rightSide = false;
            if (bl != rightSide) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  session .getAndclearProblemState().size == 0          ==>>" + (int)(bl ? 1 : 0) + " ==" + (int)(rightSide ? 1 : 0) + "\n");
            }
            if (!OrderDocTests.isEmptyString(ex.getProblem().getProblemDescOrNull())) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().getProblemDescOrNull().isEmpty          ==>> FALSE !\n");
            }
            if (!OrderDocTests.isEmptyString(ex.getProblem().getInstanceDescOrNull())) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().getInstanceDescOrNull().isEmpty          ==>> FALSE !\n");
            }
            boolean bl2 = ex.getProblem().hasForwardedEx();
            if (bl2 != (rightSide = true)) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().hasForwardedEx() == \"true\"          ==>>" + bl2 + " ==" + rightSide + "\n");
            }
            boolean bl3 = ex.getProblem().isFromGuard();
            if (bl3 != (rightSide = true)) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().isFromGuard() == \"true\"          ==>>" + bl3 + " ==" + rightSide + "\n");
            }
            String string = ex.getProblem().getForwardedEx().getMessage();
            String param0 = "Somne IO Excpetion?";
            StringBuilder textRepresentation = new StringBuilder();
            textRepresentation.append(param0 + ", ");
            textRepresentation.setLength(textRepresentation.length() - 2);
            if (!string.contains(param0)) {
                throw new OFXTestSuitException("'OrderDocTests.Trigger gard with forwarded ex':  ex .getProblem().getForwardedEx().getMessage().contains(\"Somne IO Excpetion?\")          ==>> '" + string + "'.contains(" + textRepresentation + ") \n");
            }
            return;
        }
    }

    @OFXTestMethod(id=7, name="Mulltiple messages due to a validation construct.", debug=false, enabled=true, runAt="")
    public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean rightSide;
        int rightSide2;
        List problems;
        int leftSide;
        block13: {
            OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            OFXAbortedException __FailIn_origThrowable = null;
            String messagesInProblems = "";
            try {
                this.__OrderDocumentODS.approve(od, false, __manMapSession);
            }
            catch (OFXAbortedException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.': Fail In Exception OFXAbortedException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block13;
                throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        if ((leftSide = ListSequence.fromList((List)(problems = __manMapSession.getAndclearProblemState())).count()) != (rightSide2 = 3)) {
            throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.':  problems .size == 3          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        IOFXProblem operand = (IOFXProblem)ListSequence.fromList((List)problems).first();
        StringBuilder textRepresentation = new StringBuilder();
        if (!operand.isWarningOnly()) {
            throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.':  problems .first.isWarningOnly()          ==>> '" + operand + "'.isWarningOnly(" + textRepresentation + ") \n");
        }
        boolean leftSide2 = ((IOFXProblem)ListSequence.fromList((List)problems).first()).isFromGuard();
        if (leftSide2 != (rightSide = false)) {
            throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.':  problems .first.isFromGuard() == \"false\"          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        if (!ListSequence.fromList((List)problems).skip(1).all(it -> !it.isWarningOnly())) {
            throw new OFXTestSuitException("'OrderDocTests.Mulltiple messages due to a validation construct.':  problems .skip.all          ==>> FALSE !\n");
        }
    }

    @OFXTestMethod(id=8, name="Two validation blocks lead to the second one triggering immediatelly.", debug=false, enabled=true, runAt="")
    public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        List problems;
        int leftSide;
        block10: {
            OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            OFXAbortedException __FailIn_origThrowable = null;
            String messagesInProblems = "";
            try {
                this.__OrderDocumentODS.revision(od, "Some Reason here.", __manMapSession);
            }
            catch (OFXAbortedException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'OrderDocTests.Two validation blocks lead to the second one triggering immediatelly.': Fail In Exception OFXAbortedException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'OrderDocTests.Two validation blocks lead to the second one triggering immediatelly.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block10;
                throw new OFXTestSuitException("'OrderDocTests.Two validation blocks lead to the second one triggering immediatelly.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        if ((leftSide = ListSequence.fromList((List)(problems = __manMapSession.getAndclearProblemState())).count()) != (rightSide = 3)) {
            throw new OFXTestSuitException("'OrderDocTests.Two validation blocks lead to the second one triggering immediatelly.':  problems .size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=9, name="Check options of problem statement. ", debug=false, enabled=true, runAt="")
    public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        List problems;
        int leftSide;
        block13: {
            OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            OFXAbortedException __FailIn_origThrowable = null;
            String messagesInProblems = "";
            try {
                this.__OrderDocumentODS.problemsWithOptions(__manMapSession);
            }
            catch (OFXAbortedException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ': Fail In Exception OFXAbortedException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block13;
                throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        if ((leftSide = ListSequence.fromList((List)(problems = __manMapSession.getAndclearProblemState())).count()) != (rightSide = 3)) {
            throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ':  problems .size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        IOFXProblem operand = (IOFXProblem)ListSequence.fromList((List)problems).getElement(0);
        StringBuilder textRepresentation = new StringBuilder();
        if (!operand.isJobIgnore()) {
            throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ':  problems .get.isJobIgnore()          ==>> '" + operand + "'.isJobIgnore(" + textRepresentation + ") \n");
        }
        operand = (IOFXProblem)ListSequence.fromList((List)problems).getElement(1);
        textRepresentation = new StringBuilder();
        if (!operand.isJobItemAlreadDone()) {
            throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ':  problems .get.isJobItemAlreadDone()          ==>> '" + operand + "'.isJobItemAlreadDone(" + textRepresentation + ") \n");
        }
        operand = (IOFXProblem)ListSequence.fromList((List)problems).getElement(2);
        textRepresentation = new StringBuilder();
        if (!operand.isWarningOnly()) {
            throw new OFXTestSuitException("'OrderDocTests.Check options of problem statement. ':  problems .get.isWarningOnly()          ==>> '" + operand + "'.isWarningOnly(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=10, name="Check fail in shortcut for the problems message. ", debug=false, enabled=true, runAt="")
    public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            OrderDocument od = this.__OrderDocumentODTF.createIGLOCase("Trigger guard test3", 5, new BigDecimal("20.0"), __manMapSession);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            OFXAbortedException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                this.__OrderDocumentODS.problemsWithOptions(__manMapSession);
            }
            catch (OFXAbortedException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("Job_Item_Alread_Done option")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("Job_Item_Alread_Done option")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'OrderDocTests.Check fail in shortcut for the problems message. ': Fail In Exception OFXAbortedException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'OrderDocTests.Check fail in shortcut for the problems message. ': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'OrderDocTests.Check fail in shortcut for the problems message. ': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", OrderDocTests.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }

    private static boolean isNotEmptyString(String str) {
        return str != null && str.length() > 0;
    }

    private static boolean isEmptyString(String str) {
        return str == null || str.isEmpty();
    }
}

