/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.ProdConsJob;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.batchjob.IOFXTimerMasterController;
import org.modellwerkstatt.objectflow.batchjob.JobProperties;
import org.modellwerkstatt.objectflow.batchjob.Message;
import org.modellwerkstatt.objectflow.batchjob.OFXPCPairController;
import org.modellwerkstatt.objectflow.batchjob.RunProducerMsg;
import org.modellwerkstatt.objectflow.batchjob.SchedInfo;
import org.modellwerkstatt.objectflow.batchjob.ShutdownWhenInboxEmptyMsg;
import org.modellwerkstatt.objectflow.batchjob.WakeupPairCrtlMsg;

public class ContinousTestDummyTimerCrtl
implements IOFXTimerMasterController {
    public int runCompledtedResched = 0;
    public int notCompletedDueToEX_ProducerResched = 0;
    public int notCompletedDueToEX_ConsumerResched = 0;
    public int notCompletedOutOfCron_ProducerResched = 0;
    public int notCompletedOutOfCron_ConsumerResched = 0;
    public int refillsTotal = 0;
    public boolean outOfCronWindowRetVal = false;
    public boolean shutdownExecuted = false;
    public boolean sendUnexpectedRunProducer = false;
    public JobProperties properties;
    public List<CallReceived> calls = ListSequence.fromList(new ArrayList());
    public OFXPCPairController controllerID1;

    public ContinousTestDummyTimerCrtl(int refs, JobProperties props) {
        this.refillsTotal = refs;
        this.properties = props;
    }

    public JobProperties getJobProperties() {
        return this.properties;
    }

    public String getSchedSetting(OFXPCPairController pair) {
        return "null";
    }

    public void runCompletedResched(OFXPCPairController crtl) {
        ListSequence.fromList(this.calls).addElement((Object)new CallReceived(CallReceived.CT.RUN_DONE, -1, false, true));
        ++this.runCompledtedResched;
        if (this.refillsTotal > 0) {
            --this.refillsTotal;
            crtl.receive((Message)new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
        } else {
            crtl.receive((Message)new ShutdownWhenInboxEmptyMsg());
        }
    }

    public SchedInfo runNotCompletedDueEXResched(OFXPCPairController crtl, int minWaitingTimeInMS, boolean prodRun, boolean inboxEmpty) {
        boolean reRunProducer;
        ListSequence.fromList(this.calls).addElement((Object)new CallReceived(CallReceived.CT.NOT_DUETOEX, minWaitingTimeInMS, prodRun, inboxEmpty));
        boolean bl = reRunProducer = prodRun || inboxEmpty || this.sendUnexpectedRunProducer;
        if (prodRun) {
            ++this.notCompletedDueToEX_ProducerResched;
        } else {
            ++this.notCompletedDueToEX_ConsumerResched;
        }
        if (reRunProducer && this.refillsTotal > 0) {
            --this.refillsTotal;
            crtl.receive((Message)new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
        } else if (!prodRun && !inboxEmpty) {
            crtl.receive((Message)new WakeupPairCrtlMsg(-1));
        } else {
            crtl.receive((Message)new ShutdownWhenInboxEmptyMsg());
        }
        return new SchedInfo("test sched info", new DateTime());
    }

    public SchedInfo runNotCompletedOutOfCronWindowResched(OFXPCPairController crtl, boolean prodRun) {
        ListSequence.fromList(this.calls).addElement((Object)new CallReceived(CallReceived.CT.NOT_OUTOFCRON, -1, prodRun, false));
        if (prodRun) {
            ++this.notCompletedOutOfCron_ProducerResched;
        } else {
            ++this.notCompletedOutOfCron_ConsumerResched;
        }
        if (this.refillsTotal > 0) {
            --this.refillsTotal;
            crtl.receive((Message)new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
        } else {
            crtl.receive((Message)new ShutdownWhenInboxEmptyMsg());
        }
        return new SchedInfo("test sched info", new DateTime());
    }

    public boolean outOfCronWindow(OFXPCPairController crtl) {
        return this.outOfCronWindowRetVal;
    }

    public boolean enableTimer(boolean enabled) {
        return true;
    }

    public void shuttingDown(OFXPCPairController crtl) {
        this.shutdownExecuted = true;
    }

    public String getFullStatusReport(OFXPCPairController crtl) {
        return "";
    }

    public int getCurrentTimerVersion() {
        throw new RuntimeException("This can not happen - not implemented.");
    }

    public int clearJobTimerState() {
        throw new RuntimeException("This can not happen - not implemented.");
    }

    public static class CallReceived {
        public boolean prodRun;
        public int delayTimeinMS;
        public boolean wasInboxEmpty;
        public CT callType;

        public CallReceived(CT ct, int delMs, boolean isFromProd, boolean inboxEmpty) {
            this.callType = ct;
            this.delayTimeinMS = delMs;
            this.prodRun = isFromProd;
            this.wasInboxEmpty = inboxEmpty;
        }

        public boolean wasProdRun() {
            return this.prodRun;
        }

        public boolean wasInboxEmpty() {
            return this.wasInboxEmpty;
        }

        public boolean isRunDone() {
            return this.callType == CT.RUN_DONE;
        }

        public boolean isNotRunDueEX() {
            return this.callType == CT.NOT_DUETOEX;
        }

        public boolean isNotRunDueWin() {
            return this.callType == CT.NOT_OUTOFCRON;
        }

        public static enum CT {
            RUN_DONE,
            NOT_DUETOEX,
            NOT_OUTOFCRON;

        }
    }
}

