/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.ProdConsJob;

import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.batchjob.IOFXTimerMasterController;
import org.modellwerkstatt.objectflow.batchjob.JobProperties;
import org.modellwerkstatt.objectflow.batchjob.Message;
import org.modellwerkstatt.objectflow.batchjob.OFXPCPairController;
import org.modellwerkstatt.objectflow.batchjob.RunProducerMsg;
import org.modellwerkstatt.objectflow.batchjob.SchedInfo;
import org.modellwerkstatt.objectflow.batchjob.ShutdownMsg;
import org.modellwerkstatt.objectflow.batchjob.WakeupPairCrtlMsg;

public class OutOfCronDummyCrtl
implements IOFXTimerMasterController {
    public int callCount = 0;
    public OFXPCPairController controllerID1;
    public Thread controllerID1_Thread;
    public JobProperties properties;

    public OutOfCronDummyCrtl(JobProperties props) {
        this.properties = props;
    }

    public JobProperties getJobProperties() {
        return this.properties;
    }

    public boolean outOfCronWindow(OFXPCPairController crtl) {
        ++this.callCount;
        if (this.callCount % 5 == 0) {
            System.err.println("CRON: Out of cron window reported.");
            return true;
        }
        System.err.println("CRON: NOT out of cron window.");
        return false;
    }

    public void runCompletedResched(OFXPCPairController crtl) {
        this.waitPlease();
        crtl.receive((Message)new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    }

    public SchedInfo runNotCompletedDueEXResched(OFXPCPairController crtl, int minWaitingTimeInMS, boolean prodRun, boolean inboxEmptyNow) {
        if (this.callCount > 20) {
            crtl.receive((Message)new ShutdownMsg());
        }
        if (prodRun) {
            System.err.println("SCHED: This is a producer run, sending runproducer msg.");
            crtl.receive((Message)new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
        } else if (inboxEmptyNow) {
            crtl.receive((Message)new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
            System.err.println("SCHED: inbox was empty, sending runproducer msg.");
        } else {
            System.err.println("SCHED: nor inbox empty, nor producer run, sending WakeupPairCrtlMsg.");
            crtl.receive((Message)new WakeupPairCrtlMsg(-1));
        }
        return new SchedInfo("test sched info", new DateTime());
    }

    public SchedInfo runNotCompletedOutOfCronWindowResched(OFXPCPairController crtl, boolean prodRun) {
        System.err.println("SCHED OUT OF CRON: Run not completed, out of cron producer?" + prodRun);
        this.runNotCompletedDueEXResched(crtl, 0, prodRun, false);
        return new SchedInfo("test sched info", new DateTime());
    }

    public void initialRun() {
        this.controllerID1.receive((Message)new RunProducerMsg(-1, RunProducerMsg.Source.MASTERCRTL));
    }

    public void waitPlease() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getSchedSetting(OFXPCPairController pair) {
        return "OutOfCronDummyCrtl";
    }

    public String getFullStatusReport(OFXPCPairController crtl) {
        return "OutOfCronDummyCrtl";
    }

    public boolean enableTimer(boolean enabled) {
        return true;
    }

    public int getCurrentTimerVersion() {
        return 0;
    }

    public int clearJobTimerState() {
        return 0;
    }

    public void shuttingDown(OFXPCPairController crtl) {
    }
}

