/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.manmap.Domain;

import java.math.BigDecimal;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXSessionOperation;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Account;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey_Active;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity_OnOff;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.ExtendedInvoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice_HeadState;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.MoneyAmount;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.NewInvoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.NewInvoicePos;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Referer;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoAccountAudit;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoAuditEntity;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.SessionLess;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.SubInvoicePosition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory")
public class CreatorsFactory {
    @Autowired
    private IOFXApplicationFactory appFactory;
    @Autowired
    private SessionLess __DomainSessionLess;
    @Autowired
    private RepoInvoice __DomainRepoInvoice;
    @Autowired
    private RepoAuditEntity __DomainRepoAuditEntity;
    @Autowired
    private RepoAccountAudit __DomainRepoAccountAudit;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;
    private CreatorsFactory __DomainCreatorsFactory = this;

    public IOFXSession CREATE_SESSION(IOFXSession __manMapSession) {
        IOFXSession customSession = this.appFactory.createNewSession(__manMapSession.getUserEnvironment(), __manMapSession.getUserServices());
        return customSession;
    }

    private Invoice createInvoicePlain(String name, int posNum, boolean withFirstPosAsMainRef, IOFXSession __manMapSession) {
        Invoice invoice = new Invoice();
        invoice.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
        invoice.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
        invoice.setHeadState(Invoice_HeadState.STAT1);
        invoice.setNameLen(name.length());
        invoice.setMoneyAmount(new MoneyAmount(100, "EUR"));
        invoice.setNameLen2(new BigDecimal(name.length()));
        invoice.setText("Invoice");
        invoice.setName(name);
        for (int i = 0; i < posNum; ++i) {
            InvoicePosition pos = new InvoicePosition();
            pos.setPosText(name + "_" + i);
            pos.setDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
            pos.setPosAvalue(new BigDecimal("10.0").multiply(new BigDecimal(i)));
            pos.setInvoice(invoice);
            ListSequence.fromList(invoice.getPositions()).addElement((Object)pos);
        }
        if (withFirstPosAsMainRef) {
            invoice.setMainPosRef((InvoicePosition)((Object)ListSequence.fromList(invoice.getPositions()).getElement(0)));
        }
        invoice.complete();
        return invoice;
    }

    public Invoice createInvoiceGraphWith4Positions_onDB(String name, IOFXSession __manMapSession) {
        Invoice invoice = this.createInvoicePlain(name, 4, false, __manMapSession);
        this.__DomainSessionLess.checkinInvoiceImmediatelly(invoice, this.CREATE_SESSION(__manMapSession), __manMapSession);
        return invoice;
    }

    public Invoice createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB(String name, IOFXSession __manMapSession) {
        Invoice invoice = this.createInvoicePlain(name, 4, true, __manMapSession);
        this.__DomainSessionLess.checkinInvoiceImmediatelly(invoice, this.CREATE_SESSION(__manMapSession), __manMapSession);
        return invoice;
    }

    public Invoice createInvoiceGraphWith4Positions_NOTonDB(String name, IOFXSession __manMapSession) {
        return this.createInvoiceGraphWithNPositions_NOTonDB(name, 4, __manMapSession);
    }

    public Invoice createInvoiceGraphWithNPositions_NOTonDB(String name, int posNum, IOFXSession __manMapSession) {
        Invoice inv = this.createInvoicePlain(name, posNum, false, __manMapSession);
        return inv;
    }

    public NewInvoicePos createNewInvoicePosition(NewInvoice invoice, String name, IOFXSession __manMapSession) {
        NewInvoicePos pos = new NewInvoicePos();
        pos.setPosText(name);
        pos.setDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
        pos.setPosAvalue(new BigDecimal("10.0"));
        ListSequence.fromList(invoice.getPositions()).addElement((Object)pos);
        invoice.complete();
        return pos;
    }

    public NewInvoice createNewInvoiceGraphWithNPositions_NOTonDB(String name, int posNum, IOFXSession __manMapSession) {
        NewInvoice invoice = new NewInvoice();
        invoice.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
        invoice.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
        invoice.setHeadState(Invoice_HeadState.STAT1);
        invoice.setTotalAmount(new BigDecimal("100.0"));
        invoice.setNameLen2(new BigDecimal(name.length()));
        invoice.setText("Invoice");
        invoice.setName(name);
        for (int i = 0; i < posNum; ++i) {
            NewInvoicePos pos = this.createNewInvoicePosition(invoice, name + "_" + i, __manMapSession);
            pos.setPosAvalue(new BigDecimal("10.0").multiply(new BigDecimal(i)));
        }
        invoice.complete();
        return invoice;
    }

    public Invoice createExtendedInvoiceGraphWith2Positions_onDB(String name, IOFXSession __manMapSession) {
        ExtendedInvoice extendedInvoice = new ExtendedInvoice();
        extendedInvoice.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
        extendedInvoice.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
        extendedInvoice.setHeadState(Invoice_HeadState.STAT1);
        extendedInvoice.setNameLen(name.length());
        extendedInvoice.setMoneyAmount(new MoneyAmount(100, "EUR"));
        extendedInvoice.setNameLen2(new BigDecimal(name.length()));
        extendedInvoice.setText("Extended Invoice");
        extendedInvoice.setName(name);
        extendedInvoice.setExtendedInt(10);
        extendedInvoice.setExtendedString("EXT");
        for (int i = 0; i < 2; ++i) {
            InvoicePosition pos = new InvoicePosition();
            pos.setPosText(name + "_" + i);
            pos.setDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
            pos.setPosAvalue(new BigDecimal("10.0").multiply(new BigDecimal(i)));
            pos.setInvoice(extendedInvoice);
            ListSequence.fromList(extendedInvoice.getPositions()).addElement((Object)pos);
        }
        extendedInvoice.complete();
        this.__DomainSessionLess.checkinExtendedInvoice(extendedInvoice, this.CREATE_SESSION(__manMapSession), __manMapSession);
        return extendedInvoice;
    }

    private void deleteInvoice(Invoice inv, IOFXSession __manMapSession) {
        this.__DomainRepoInvoice.deleteInovice(inv, null);
    }

    public Referer createRefererEntityWithStringKey(String keyString, IOFXSession __manMapSession) {
        Referer ref = new Referer();
        ref.setKey(keyString);
        ref.setName(keyString);
        ref.setTotalValue(new BigDecimal("0.0"));
        ref.setAccount(null);
        ref.setAccountKey(new AccountKey());
        return ref;
    }

    public Account createAccountWithNumAndMandant(int num, String mandant, IOFXSession __manMapSession) {
        AccountKey key = new AccountKey(num, mandant, AccountKey_Active.ON);
        Account account = new Account();
        account.setKey(key);
        account.setTotalValue(new BigDecimal("0.0"));
        account.setRelatedAccountAudit(null);
        return account;
    }

    public AuditEntity createAuditEntity_onDB(String name, IOFXSession __manMapSession) {
        final AuditEntity obj = new AuditEntity();
        obj.setAmount(new MoneyAmount(10, "EUR"));
        obj.setOnOff(AuditEntity_OnOff.ON);
        obj.setText(name);
        obj.setTotalAmount(new BigDecimal("10.0"));
        final IOFXSession session = this.CREATE_SESSION(__manMapSession);
        session.addOperation(new IOFXSessionOperation(){

            public void execute() {
                CreatorsFactory.this.__DomainRepoAuditEntity.checkinAuditEntity(obj, session);
            }

            public String getInformation() {
                return "checkin AuditEntity";
            }
        });
        try {
            session.startTransactionAndFlush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return obj;
    }

    public Account createAccount_onDB(String name, Account ref, IOFXSession __manMapSession) {
        final Account obj = new Account();
        obj.setKey(new AccountKey(10, name, AccountKey_Active.ON));
        obj.setTotalValue(new BigDecimal("10.0"));
        obj.setADateDirtyIrrelevant(null);
        obj.setRelatedAccountAudit(ref);
        final IOFXSession session = this.CREATE_SESSION(__manMapSession);
        session.addOperation(new IOFXSessionOperation(){

            public void execute() {
                CreatorsFactory.this.__DomainRepoAccountAudit.insertAccount(obj, session);
            }

            public String getInformation() {
                return "checkin Account";
            }
        });
        try {
            session.startTransactionAndFlush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return obj;
    }

    public AuditEntity createAuditEntity_NOTonDB(String name, IOFXSession __manMapSession) {
        AuditEntity obj = new AuditEntity();
        obj.setAmount(new MoneyAmount(10, "EUR"));
        obj.setOnOff(AuditEntity_OnOff.ON);
        obj.setText(name);
        obj.setTotalAmount(new BigDecimal("10.0"));
        return obj;
    }

    public Invoice createInvoiceGraphWith2PositionsAnd2SubPos_onDB(String name, IOFXSession __manMapSession) {
        Invoice invoice = new Invoice();
        invoice.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
        invoice.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
        invoice.setHeadState(Invoice_HeadState.STAT1);
        invoice.setNameLen(name.length());
        invoice.setMoneyAmount(new MoneyAmount(100, "EUR"));
        invoice.setNameLen2(new BigDecimal(name.length()));
        invoice.setText("Invoice");
        invoice.setName(name);
        for (int i = 0; i < 2; ++i) {
            InvoicePosition pos = new InvoicePosition();
            pos.setPosText(name + "_" + i);
            pos.setDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
            pos.setPosAvalue(new BigDecimal("10.0").multiply(new BigDecimal(i)));
            pos.setInvoice(invoice);
            ListSequence.fromList(invoice.getPositions()).addElement((Object)pos);
            for (int j = 0; j < 2; ++j) {
                SubInvoicePosition sub = new SubInvoicePosition();
                sub.setText(name + "_sub_" + j);
                sub.setInvpos(pos);
                ListSequence.fromList(pos.getSubposition()).addElement((Object)sub);
            }
        }
        invoice.complete();
        this.__DomainSessionLess.checkinInvoiceWithSub(invoice, this.CREATE_SESSION(__manMapSession), null);
        return invoice;
    }
}

