/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.manmap.Tests;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.objectflow.serdes.CONV;
import org.modellwerkstatt.objectflow.services.MoSimplePrintService;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey_Active;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity_OnOff;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.ComplexValueObject;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoiceStat_TheState;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice_HeadState;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.MoneyAmount;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.SimpleTestObject;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.SimpleTestObject_SimpleStatus;
import org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit;
import org.modellwerkstatt.objectflow.tests.manmap.XNokeys.MmtNkDTO;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class M3_Object_Infrastructure
extends OFXTestSuit {
    @Autowired
    private CreatorsFactory __DomainCreatorsFactory;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;
    @OFXIncludedSuit(name="org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
    private DBinit ___inst_DBinit;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    @OFXTestMethod(id=0, name="Setting defafults should not lead to a Dirty entity.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        obj.setDirty(false);
        obj.setId(0);
        obj.setText("");
        obj.setOnOff(AuditEntity_OnOff.ON);
        obj.setRefToAuditEntity(null);
        obj.setZzCreatedAt(null);
        obj.setZzCreatedAtUid(0);
        obj.setZzModifiedAt(null);
        obj.setZzModifiedAtUid(0);
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = false;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting defafults should not lead to a Dirty entity.':  obj .#Meta.getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=1, name="Setting values and setting them again should not lead to a dirty entity. ", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        DateTime time = DeprecatedServerDateProvider.getSqlServerDateTime();
        obj.setId(1);
        obj.setText("DAN");
        obj.setOnOff(AuditEntity_OnOff.OFF);
        obj.setRefToAuditEntity(obj);
        obj.setZzCreatedAt(time);
        obj.setZzCreatedAtUid(2);
        obj.setZzModifiedAt(time);
        obj.setZzModifiedAtUid(3);
        obj.setDirty(false);
        obj.setId(1);
        obj.setText("DAN");
        obj.setOnOff(AuditEntity_OnOff.OFF);
        obj.setRefToAuditEntity(obj);
        obj.setZzCreatedAt(time);
        obj.setZzCreatedAtUid(2);
        obj.setZzModifiedAt(time);
        obj.setZzModifiedAtUid(3);
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = false;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting values and setting them again should not lead to a dirty entity. ':  obj .#Meta.getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=2, name="Setting ValueObject/Datetime/Bigdecimal and setting again should not mark dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        DateTime time = DeprecatedServerDateProvider.getSqlServerDateTime();
        obj.setZzCreatedAt(time);
        obj.setZzModifiedAt(time);
        obj.setAmount(new MoneyAmount(40, "EUR"));
        obj.setTotalAmount(new BigDecimal("4711."));
        obj.setDirty(false);
        time = DeprecatedServerDateProvider.getSqlServerDateTime();
        obj.setZzCreatedAt(time);
        obj.setZzModifiedAt(time);
        obj.setAmount(new MoneyAmount(40, "EUR"));
        obj.setTotalAmount(new BigDecimal("4711."));
        boolean leftSide = obj.getDirty();
        boolean rightSide = false;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting ValueObject/Datetime/Bigdecimal and setting again should not mark dirty.': ((IM3Entity) obj ).getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=3, name="Setting int - dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        obj.setDirty(false);
        obj.setId(1);
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting int - dirty.':  obj .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=4, name="Setting string - dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        obj.setDirty(false);
        obj.setText("Dan");
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting string - dirty.':  obj .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=5, name="Setting DateTime - dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        DateTime d = new DateTime(8341343L);
        DateTime d2 = new DateTime(8341343L);
        obj.setDirty(false);
        obj.setZzCreatedAt(d);
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting DateTime - dirty.':  obj .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        obj.setDirty(false);
        obj.setZzCreatedAt(d2);
        leftSide = obj._META().getDirty();
        rightSide = false;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting DateTime - dirty.':  obj .#Meta.getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        obj.setZzCreatedAt(new DateTime());
        leftSide = obj._META().getDirty();
        rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting DateTime - dirty.':  obj .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=6, name="Setting status - dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        obj.setDirty(false);
        obj.setOnOff(AuditEntity_OnOff.OFF);
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting status - dirty.':  obj .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=7, name="Setting BigDecimal - dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        obj.setTotalAmount(new BigDecimal("4711."));
        obj.setDirty(false);
        obj.setTotalAmount(new BigDecimal("4712."));
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting BigDecimal - dirty.':  obj .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=8, name="Setting ValueObject - dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = new AuditEntity();
        obj.setAmount(new MoneyAmount(10, "Euro"));
        obj.setDirty(false);
        obj.setAmount(new MoneyAmount(11, "Euro"));
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting ValueObject - dirty.':  obj .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=9, name="Setting LocalDate - dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice obj = new Invoice();
        obj.setDirty(false);
        obj.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting LocalDate - dirty.':  obj .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=10, name="Setting Localdate (dirty irrelevant) - not dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        LocalDate date = new LocalDate(1, 12, 12);
        LocalDate date2 = new LocalDate(1, 12, 8);
        if (date.equals((Object)date2)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting Localdate (dirty irrelevant) - not dirty.': !( date .equals( date2 ))          ==>> FALSE !\n");
        }
        AuditEntity obj = new AuditEntity();
        obj.setDirtyIrrelevant(date);
        obj.setDirty(false);
        obj.setDirtyIrrelevant(date2);
        boolean leftSide = obj._META().getDirty();
        boolean rightSide = false;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting Localdate (dirty irrelevant) - not dirty.':  obj .#Meta.getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=11, name="Setting reference leads to dirty.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity reference = new AuditEntity();
        reference.setId(4711);
        AuditEntity root = new AuditEntity();
        root.setId(4712);
        root.setDirty(false);
        reference.setDirty(false);
        AuditEntity leftSide = root.getRefToAuditEntity();
        Object rightSide = null;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting reference leads to dirty.':  root .refToAuditEntity ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        int leftSide2 = root.getRefToAuditEntityKEY();
        if (leftSide2 != (rightSide2 = 0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting reference leads to dirty.':  root .refToAuditEntity#KEY == 0          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = root.getRefToAuditEntity_META().isInitialized() ? 1 : 0;
        if (leftSide2 != (rightSide2 = 0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting reference leads to dirty.':  root .refToAuditEntity#META.isInitialized() == \"false\"          ==>>" + (leftSide2 != 0) + " ==" + (rightSide2 != 0) + "\n");
        }
        root.setRefToAuditEntity(reference);
        leftSide2 = root._META().getDirty();
        int rightSide2 = 1;
        if (leftSide2 != rightSide2) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting reference leads to dirty.':  root .#Meta.getDirty() == \"true\"          ==>>" + (leftSide2 != 0) + " ==" + (rightSide2 != 0) + "\n");
        }
        leftSide2 = reference._META().getDirty();
        if (leftSide2 != (rightSide2 = 0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting reference leads to dirty.':  reference .#Meta.getDirty() == \"false\"          ==>>" + (leftSide2 != 0) + " ==" + (rightSide2 != 0) + "\n");
        }
        leftSide2 = root.getRefToAuditEntityKEY();
        if (leftSide2 != (rightSide2 = reference.getId())) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting reference leads to dirty.':  root .refToAuditEntity#KEY ==  reference .id          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = root.getRefToAuditEntity_META().isInitialized() ? 1 : 0;
        if (leftSide2 != (rightSide2 = 1)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting reference leads to dirty.':  root .refToAuditEntity#META.isInitialized() == \"true\"          ==>>" + (leftSide2 != 0) + " ==" + (rightSide2 != 0) + "\n");
        }
        root.setRefToAuditEntity(null);
        leftSide2 = root.getRefToAuditEntity_META().isInitialized();
        rightSide2 = 0;
        if (leftSide2 != rightSide2) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Setting reference leads to dirty.':  root .refToAuditEntity#META.isInitialized() == \"false\"          ==>>" + (leftSide2 != 0) + " ==" + (rightSide2 != 0) + "\n");
        }
    }

    @OFXTestMethod(id=12, name="Reverting - Get a copy of an object and check.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity three;
        AuditEntity child = new AuditEntity();
        child.setId(4711);
        child.setText("Child");
        child.setOnOff(AuditEntity_OnOff.OFF);
        child.setZzCreatedAt(new DateTime());
        child.setZzModifiedAt(new DateTime());
        child.setZzCreatedAtUid(1);
        child.setZzModifiedAtUid(1);
        AuditEntity parent = new AuditEntity();
        parent.setId(4712);
        parent.setText("Parent");
        parent.setOnOff(AuditEntity_OnOff.ON);
        parent.setZzCreatedAt(new DateTime());
        parent.setZzModifiedAt(new DateTime());
        parent.setZzCreatedAtUid(2);
        parent.setZzModifiedAtUid(3);
        parent.setRefToAuditEntity(child);
        AuditEntity leftSide = three = (AuditEntity)parent.copy();
        AuditEntity rightSide = parent;
        if (leftSide == rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - Get a copy of an object and check.':  three  !=  parent           ==>>" + leftSide + " !=" + rightSide + "\n");
        }
        leftSide = three.getRefToAuditEntity();
        if (leftSide == (rightSide = child)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - Get a copy of an object and check.':  three .refToAuditEntity !=  child           ==>>" + leftSide + " !=" + rightSide + "\n");
        }
        int leftSide2 = three.getId();
        if (leftSide2 != (rightSide = 4712)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - Get a copy of an object and check.':  three .id == 4712          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        leftSide2 = three.getRefToAuditEntity().getId();
        if (leftSide2 != (rightSide = 4711)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - Get a copy of an object and check.':  three .refToAuditEntity.id == 4711          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=13, name="Reverting - Get a copy of an object, revert and check.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity child = new AuditEntity();
        child.setId(4711);
        child.setText("Child");
        child.setOnOff(AuditEntity_OnOff.OFF);
        child.setZzCreatedAt(new DateTime());
        child.setZzModifiedAt(new DateTime());
        child.setZzCreatedAtUid(1);
        child.setZzModifiedAtUid(1);
        AuditEntity parent = new AuditEntity();
        parent.setId(4712);
        parent.setText("Parent");
        parent.setOnOff(AuditEntity_OnOff.ON);
        parent.setZzCreatedAt(new DateTime());
        parent.setZzModifiedAt(new DateTime());
        parent.setZzCreatedAtUid(2);
        parent.setZzModifiedAtUid(3);
        parent.setRefToAuditEntity(child);
        AuditEntity three = (AuditEntity)parent.copy();
        parent.setText("changed");
        parent.setId(0);
        parent.setZzCreatedAt(null);
        parent.setRefToAuditEntity(null);
        child.setText("changed");
        child.setZzCreatedAt(null);
        child.setId(0);
        parent.load((IOFXRevertableObject)three, true);
        boolean leftSide = parent.getText().equals("Parent");
        boolean bl = parent.getId() == 4712;
        leftSide = child.getText().equals("Child");
        bl = child.getId() == 4711;
        AuditEntity leftSide2 = parent.getRefToAuditEntity();
        AuditEntity rightSide = child;
        if (leftSide2 != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - Get a copy of an object, revert and check.':  parent .refToAuditEntity ==  child           ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        int leftSide3 = parent.getId();
        if (leftSide3 != (rightSide = 4712)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - Get a copy of an object, revert and check.':  parent .id == 4712          ==>>" + leftSide3 + " ==" + rightSide + "\n");
        }
        leftSide3 = parent.getRefToAuditEntity().getId();
        if (leftSide3 != (rightSide = 4711)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - Get a copy of an object, revert and check.':  parent .refToAuditEntity.id == 4711          ==>>" + leftSide3 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=14, name="Reverting - no reference copy on readonly.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity child = new AuditEntity();
        child.setId(4711);
        child.setText("Child");
        child.setOnOff(AuditEntity_OnOff.OFF);
        child.setZzCreatedAt(new DateTime());
        child.setZzModifiedAt(new DateTime());
        child.setZzCreatedAtUid(1);
        child.setZzModifiedAtUid(1);
        AuditEntity parent = new AuditEntity();
        parent.setId(4712);
        parent.setText("Parent");
        parent.setOnOff(AuditEntity_OnOff.ON);
        parent.setZzCreatedAt(new DateTime());
        parent.setZzModifiedAt(new DateTime());
        parent.setZzCreatedAtUid(2);
        parent.setZzModifiedAtUid(3);
        parent.setRefToAuditEntity(child);
        child.setReadOnly(true);
        AuditEntity three = (AuditEntity)parent.copy();
        AuditEntity leftSide = three.getRefToAuditEntity();
        AuditEntity rightSide22 = child;
        if (leftSide != rightSide22) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on readonly.':  three .refToAuditEntity ==  child           ==>>" + leftSide + " ==" + rightSide22 + "\n");
        }
        parent.setText("changed");
        parent.setId(0);
        parent.setZzCreatedAt(null);
        parent.setRefToAuditEntity(null);
        parent.load((IOFXRevertableObject)three, true);
        boolean leftSide2 = parent.getText().equals("Parent");
        boolean rightSide22 = parent.getId() == 4712;
        leftSide2 = child.getText().equals("Child");
        rightSide22 = child.getId() == 4711;
        leftSide = parent.getRefToAuditEntity();
        AuditEntity rightSide = child;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on readonly.':  parent .refToAuditEntity ==  child           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        int leftSide3 = parent.getId();
        if (leftSide3 != (rightSide = 4712)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on readonly.':  parent .id == 4712          ==>>" + leftSide3 + " ==" + rightSide + "Id in parent not correct");
        }
        leftSide3 = parent.getRefToAuditEntity().getId();
        if (leftSide3 != (rightSide = 4711)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on readonly.':  parent .refToAuditEntity.id == 4711          ==>>" + leftSide3 + " ==" + rightSide + "Id in child not correct");
        }
    }

    @OFXTestMethod(id=15, name="Reverting - no reference copy on opposite", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity child = new AuditEntity();
        child.setId(4711);
        child.setText("Child");
        child.setOnOff(AuditEntity_OnOff.OFF);
        child.setZzCreatedAt(new DateTime());
        child.setZzModifiedAt(new DateTime());
        child.setZzCreatedAtUid(1);
        child.setZzModifiedAtUid(1);
        AuditEntity parent = new AuditEntity();
        parent.setId(4712);
        parent.setText("Parent");
        parent.setOnOff(AuditEntity_OnOff.ON);
        parent.setZzCreatedAt(new DateTime());
        parent.setZzModifiedAt(new DateTime());
        parent.setZzCreatedAtUid(2);
        parent.setZzModifiedAtUid(3);
        parent.setRefToAuditEntity(child);
        boolean leftSide = child._META().getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on opposite':  child .#Meta.getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = child.getReadOnly();
        if (leftSide != (rightSide = false)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on opposite': ((IOFXEntity) child ).getReadOnly() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ((OFXKeyReference)parent.getRefToAuditEntity_META()).setOpposite(true);
        AuditEntity three = (AuditEntity)parent.copy();
        AuditEntity leftSide2 = three.getRefToAuditEntity();
        AuditEntity rightSide22 = child;
        if (leftSide2 != rightSide22) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on opposite':  three .refToAuditEntity ==  child           ==>>" + leftSide2 + " ==" + rightSide22 + "\n");
        }
        parent.setText("changed");
        parent.setId(0);
        parent.setZzCreatedAt(null);
        parent.setRefToAuditEntity(null);
        parent.load((IOFXRevertableObject)three, true);
        boolean leftSide22 = parent.getText().equals("Parent");
        boolean rightSide22 = parent.getId() == 4712;
        leftSide22 = child.getText().equals("Child");
        rightSide22 = child.getId() == 4711;
        leftSide = parent.getRefToAuditEntity();
        AuditEntity rightSide3 = child;
        if (leftSide != rightSide3) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on opposite':  parent .refToAuditEntity ==  child           ==>>" + leftSide + " ==" + rightSide3 + "\n");
        }
        int leftSide3 = parent.getId();
        if (leftSide3 != (rightSide = 4712)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on opposite':  parent .id == 4712          ==>>" + leftSide3 + " ==" + rightSide + "Id in parent not correct");
        }
        leftSide3 = parent.getRefToAuditEntity().getId();
        if (leftSide3 != (rightSide = 4711)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - no reference copy on opposite':  parent .refToAuditEntity.id == 4711          ==>>" + leftSide3 + " ==" + rightSide + "Id in child not correct");
        }
    }

    @OFXTestMethod(id=16, name="Reverting - list copy leads to new objects.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        InvoicePosition rightSide;
        int rightSide2;
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("revertlist", __manMapSession);
        Invoice third = (Invoice)inv.copy();
        int leftSide = ListSequence.fromList(third.getPositions()).count();
        if (leftSide != (rightSide2 = 4)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - list copy leads to new objects.':  third .positions.size == 4          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        InvoicePosition leftSide2 = (InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(0));
        if (leftSide2 == (rightSide = (InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(0)))) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - list copy leads to new objects.':  third .positions.get !=  inv .positions.get          ==>>" + leftSide2 + " !=" + rightSide + "\n");
        }
        leftSide2 = (InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(1));
        if (leftSide2 == (rightSide = (InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(1)))) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - list copy leads to new objects.':  third .positions.get !=  inv .positions.get          ==>>" + leftSide2 + " !=" + rightSide + "\n");
        }
        leftSide2 = (InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(2));
        if (leftSide2 == (rightSide = (InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(2)))) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - list copy leads to new objects.':  third .positions.get !=  inv .positions.get          ==>>" + leftSide2 + " !=" + rightSide + "\n");
        }
        leftSide2 = (InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(3));
        if (leftSide2 == (rightSide = (InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(3)))) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - list copy leads to new objects.':  third .positions.get !=  inv .positions.get          ==>>" + leftSide2 + " !=" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=17, name="Reverting - change list and revert.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("revertlist", __manMapSession);
        Invoice third = (Invoice)inv.copy();
        ListSequence.fromList(inv.getPositions()).visitAll(it -> {
            it.setId(0);
            it.setPosAvalue(new BigDecimal("4712."));
        });
        inv.load((IOFXRevertableObject)third, true);
        int leftSide = ((InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(0))).getId();
        int rightSide = ((InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(0))).getId();
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - change list and revert.':  inv .positions.get.id ==  third .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        BigDecimal leftSide2 = ((InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(0))).getPosAvalue();
        if (leftSide2.compareTo(rightSide = ((InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(0))).getPosAvalue()) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - change list and revert.':  inv .positions.get.posAvalue ==  third .positions.get.posAvalue          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        leftSide = ((InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(1))).getId();
        if (leftSide != (rightSide = ((InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(1))).getId())) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - change list and revert.':  inv .positions.get.id ==  third .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        BigDecimal leftSide3 = ((InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(1))).getPosAvalue();
        if (leftSide3.compareTo(rightSide = ((InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(1))).getPosAvalue()) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - change list and revert.':  inv .positions.get.posAvalue ==  third .positions.get.posAvalue          ==>>" + leftSide3 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=18, name="Reverting - do not deepcopy when we are working on readonly entities.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_18(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("revertlist", __manMapSession);
        ListSequence.fromList(inv.getPositions()).visitAll(it -> it.clearDirtySetReadonly(true));
        Invoice third = (Invoice)inv.copy();
        InvoicePosition leftSide = (InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(0));
        InvoicePosition rightSide = (InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(0));
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - do not deepcopy when we are working on readonly entities.':  third .positions.get ==  inv .positions.get          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = (InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(1));
        if (leftSide != (rightSide = (InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(1)))) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - do not deepcopy when we are working on readonly entities.':  third .positions.get ==  inv .positions.get          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = (InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(2));
        if (leftSide != (rightSide = (InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(2)))) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - do not deepcopy when we are working on readonly entities.':  third .positions.get ==  inv .positions.get          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = (InvoicePosition)((Object)ListSequence.fromList(third.getPositions()).getElement(3));
        if (leftSide != (rightSide = (InvoicePosition)((Object)ListSequence.fromList(inv.getPositions()).getElement(3)))) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - do not deepcopy when we are working on readonly entities.':  third .positions.get ==  inv .positions.get          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=19, name="Reverting - restore correctly, even in presence of readonly list.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_19(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("revertlist", __manMapSession);
        ListSequence.fromList(inv.getPositions()).visitAll(it -> it.clearDirtySetReadonly(true));
        Invoice third = (Invoice)inv.copy();
        ListSequence.fromList(inv.getPositions()).removeElementAt(1);
        inv.load((IOFXRevertableObject)third, true);
        int leftSide = ListSequence.fromList(inv.getPositions()).count();
        int rightSide = ListSequence.fromList(third.getPositions()).count();
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Reverting - restore correctly, even in presence of readonly list.':  inv .positions.size ==  third .positions.size          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=20, name="XML conversion - full check.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_20(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("conversion", __manMapSession);
        String xmlText = CONV.fopXmlSer().ser((Object)inv);
        inv.setText(xmlText);
        inv.setName("XML CONVERSION");
    }

    @OFXTestMethod(id=21, name="String conversion of virtual properties and status.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_21(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        SimpleTestObject to = new SimpleTestObject();
        to.setStat(SimpleTestObject_SimpleStatus.B);
        to.setStat(SimpleTestObject_SimpleStatus.C);
        SimpleTestObject_SimpleStatus leftSide = to.getStat();
        SimpleTestObject_SimpleStatus rightSide = SimpleTestObject_SimpleStatus.C;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.String conversion of virtual properties and status.':  to .stat == \"SimpleStatus.C\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = to.getStat2();
        if (leftSide != (rightSide = SimpleTestObject_SimpleStatus.C)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.String conversion of virtual properties and status.':  to .stat2 == \"SimpleStatus.C\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        MoSimplePrintService srv = new MoSimplePrintService();
        String converted = srv.objectGraphToString((Object)to, null);
        String operand = converted.trim();
        String param0 = "stat: C";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.String conversion of virtual properties and status.':  converted .trim().contains(\"stat: C\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        boolean leftSide2 = converted.trim().contains("stat2 (Virt.Prop.)");
        boolean bl = converted.trim().contains("SimpleStatus C");
    }

    @OFXTestMethod(id=22, name="Retrieve Status Meta Information and change it.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_22(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity ae = new AuditEntity();
        ae.setOnOff(AuditEntity_OnOff.ON);
        int leftSide = ((AuditEntity_OnOff[])ae.getOnOff_META().getElements()).length;
        int rightSide = 2;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Status Meta Information and change it.':  ae .onOff#META.getElements().length == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.getOnOff_META().setElements((Object[])new AuditEntity_OnOff[]{AuditEntity_OnOff.OFF});
        leftSide = ((AuditEntity_OnOff[])ae.getOnOff_META().getElements()).length;
        rightSide = 1;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Status Meta Information and change it.':  ae .onOff#META.getElements().length == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.getOnOff_META().enableElementsByDBValue("ON, OFF");
        leftSide = ((AuditEntity_OnOff[])ae.getOnOff_META().getElements()).length;
        rightSide = 2;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Status Meta Information and change it.':  ae .onOff#META.getElements().length == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.getOnOff_META().setElements((Object[])new AuditEntity_OnOff[]{AuditEntity_OnOff.OFF, AuditEntity_OnOff.ON});
        leftSide = ((AuditEntity_OnOff[])ae.getOnOff_META().getElements()).length;
        rightSide = 2;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Status Meta Information and change it.':  ae .onOff#META.getElements().length == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        String operand = ae.getOnOff().getDbValue();
        String param0 = "ON";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Status Meta Information and change it.':  ae .onOff.getDbValue().equals(\"ON\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = ae.getOnOff().getShortDesc();
        param0 = "On_Short";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Status Meta Information and change it.':  ae .onOff.getShortDesc().equals(\"On_Short\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = ae.getOnOff().getLongDesc();
        param0 = "On_Long";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Status Meta Information and change it.':  ae .onOff.getLongDesc().equals(\"On_Long\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=23, name="Retrieve Reference Meta Information and change it.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_23(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        AuditEntity ae = new AuditEntity();
        int leftSide = ListSequence.fromList((List)ae.getRefToAuditEntity_META().getScope()).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Reference Meta Information and change it.':  ae .refToAuditEntity#META.getScope().size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.getRefToAuditEntity_META().setScope((List)ListSequence.fromListAndArray(new ArrayList(), (Object[])new AuditEntity[]{new AuditEntity(), new AuditEntity(), new AuditEntity()}));
        leftSide = ListSequence.fromList((List)ae.getRefToAuditEntity_META().getScope()).count();
        rightSide = 3;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Reference Meta Information and change it.':  ae .refToAuditEntity#META.getScope().size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.getRefToAuditEntity_META().setScope((List)ListSequence.fromList(new ArrayList()));
        leftSide = ListSequence.fromList((List)ae.getRefToAuditEntity_META().getScope()).count();
        rightSide = 0;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve Reference Meta Information and change it.':  ae .refToAuditEntity#META.getScope().size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=24, name="Retrieve String Meta Information and change it.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_24(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity ae = new AuditEntity();
        Integer leftSide = ae.getText_META().getMax();
        int rightSide = 20;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve String Meta Information and change it.':  ae .text#META.getMax() == 20          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.getText_META().setMinMax(Integer.valueOf(1), Integer.valueOf(19));
        leftSide = ae.getText_META().getMin();
        rightSide = 1;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve String Meta Information and change it.':  ae .text#META.getMin() == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ae.getText_META().getMax();
        rightSide = 19;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve String Meta Information and change it.':  ae .text#META.getMax() == 19          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=25, name="Retrieve BigDecimal Meta Information and change it.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_25(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        BigDecimal rightSide;
        AuditEntity ae = new AuditEntity();
        BigDecimal leftSide = ae.getTotalAmount();
        if (leftSide.compareTo(rightSide = new BigDecimal("0.0")) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve BigDecimal Meta Information and change it.':  ae .totalAmount == 0.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.setTotalAmount(new BigDecimal("1.12345"));
        leftSide = ae.getTotalAmount();
        rightSide = new BigDecimal("1.1235");
        if (leftSide.compareTo(rightSide) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve BigDecimal Meta Information and change it.':  ae .totalAmount == 1.1235bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.getTotalAmount_META().setScale(Integer.valueOf(5));
        ae.setTotalAmount(new BigDecimal("1.12345"));
        leftSide = ae.getTotalAmount();
        rightSide = new BigDecimal("1.12345");
        if (leftSide.compareTo(rightSide) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve BigDecimal Meta Information and change it.':  ae .totalAmount == 1.12345bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ae.setTotalAmount(ae.getTotalAmount().multiply(new BigDecimal("0.1")));
        leftSide = ae.getTotalAmount();
        rightSide = new BigDecimal("0.11235");
        if (leftSide.compareTo(rightSide) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve BigDecimal Meta Information and change it.':  ae .totalAmount == 0.11235bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=26, name="Retrieve DateTime Meta Information and change it.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_26(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean rightSide;
        Object rightSide2;
        AuditEntity ae = new AuditEntity();
        DateTime leftSide = ae.getZzCreatedAt();
        if (leftSide != (rightSide2 = null)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve DateTime Meta Information and change it.':  ae .zzCreatedAt ==  null           ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ae.getZzCreatedAt_META();
        if (leftSide == (rightSide2 = null)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve DateTime Meta Information and change it.':  ae .zzCreatedAt#META !=  null           ==>>" + leftSide + " !=" + rightSide2 + "\n");
        }
        leftSide = (DateTime)ae.getZzCreatedAt_META().getMax();
        if (leftSide != (rightSide2 = null)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve DateTime Meta Information and change it.':  ae .zzCreatedAt#META.getMax() ==  null           ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = (DateTime)ae.getZzCreatedAt_META().getMin();
        if (leftSide != (rightSide2 = null)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve DateTime Meta Information and change it.':  ae .zzCreatedAt#META.getMin() ==  null           ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        boolean leftSide2 = ae.getZzCreatedAt_META().getEnabled();
        if (leftSide2 != (rightSide = true)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve DateTime Meta Information and change it.':  ae .zzCreatedAt#META.getEnabled() == \"true\"          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        ae.getZzCreatedAt_META().setEnabled(false);
        leftSide2 = ae.getZzCreatedAt_META().getEnabled();
        rightSide = false;
        if (leftSide2 != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve DateTime Meta Information and change it.':  ae .zzCreatedAt#META.getEnabled() == \"false\"          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=27, name="Retrieve LocalDate Meta Information and change it.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_27(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean rightSide;
        Object rightSide2;
        AuditEntity ae = new AuditEntity();
        LocalDate leftSide = ae.getZzCreatedAtLDate();
        if (leftSide != (rightSide2 = null)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve LocalDate Meta Information and change it.':  ae .zzCreatedAtLDate ==  null           ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ae.getZzCreatedAtLDate_META();
        if (leftSide == (rightSide2 = null)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve LocalDate Meta Information and change it.':  ae .zzCreatedAtLDate#META !=  null           ==>>" + leftSide + " !=" + rightSide2 + "\n");
        }
        leftSide = (LocalDate)ae.getZzCreatedAtLDate_META().getMax();
        if (leftSide != (rightSide2 = null)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve LocalDate Meta Information and change it.':  ae .zzCreatedAtLDate#META.getMax() ==  null           ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = (LocalDate)ae.getZzCreatedAtLDate_META().getMin();
        if (leftSide != (rightSide2 = null)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve LocalDate Meta Information and change it.':  ae .zzCreatedAtLDate#META.getMin() ==  null           ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        boolean leftSide2 = ae.getZzCreatedAtLDate_META().getEnabled();
        if (leftSide2 != (rightSide = true)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve LocalDate Meta Information and change it.':  ae .zzCreatedAtLDate#META.getEnabled() == \"true\"          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        ae.getZzCreatedAtLDate_META().setEnabled(false);
        leftSide2 = ae.getZzCreatedAtLDate_META().getEnabled();
        rightSide = false;
        if (leftSide2 != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Retrieve LocalDate Meta Information and change it.':  ae .zzCreatedAtLDate#META.getEnabled() == \"false\"          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=28, name="Default Value of Status.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_28(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity_OnOff rightSide;
        AuditEntity ae = new AuditEntity();
        AuditEntity_OnOff leftSide = ae.getOnOff();
        if (leftSide != (rightSide = AuditEntity_OnOff.ON)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Default Value of Status.':  ae .onOff == \"OnOff.on\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=29, name="Check request Focus on Integer.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_29(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean rightSide;
        AuditEntity a = new AuditEntity();
        boolean leftSide = a.getId_META().getFocusAndClearIt();
        if (leftSide != (rightSide = false)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Check request Focus on Integer.':  a .id#META.getFocusAndClearIt() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        a.getId_META().requestFocus();
        leftSide = a.getId_META().getFocusAndClearIt();
        rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Check request Focus on Integer.':  a .id#META.getFocusAndClearIt() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = a.getId_META().getFocusAndClearIt();
        if (leftSide != (rightSide = false)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Check request Focus on Integer.':  a .id#META.getFocusAndClearIt() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=30, name="Static Status interface for DBText.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_30(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity a = new AuditEntity();
        a.setOnOff(AuditEntity_OnOff.ON);
        String operand = a.getOnOff().getDbValue();
        String param0 = "ON";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Static Status interface for DBText.':  a .onOff.getDbValue().equals(\"ON\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = AuditEntity_OnOff.OFF.getDbValue();
        param0 = "OFF";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Static Status interface for DBText.': \"OnOff.off\".getDbValue().equals(\"OFF\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=31, name="Static Status interface for shortText.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_31(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity a = new AuditEntity();
        a.setOnOff(AuditEntity_OnOff.ON);
        String operand = a.getOnOff().getShortDesc();
        String param0 = "On_Short";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Static Status interface for shortText.':  a .onOff.getShortDesc().equals(\"On_Short\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = AuditEntity_OnOff.OFF.getShortDesc();
        param0 = "Off_Short";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Static Status interface for shortText.': \"OnOff.off\".getShortDesc().equals(\"Off_Short\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=32, name="Static Status interface for longText.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_32(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity a = new AuditEntity();
        a.setOnOff(AuditEntity_OnOff.ON);
        String operand = a.getOnOff().getLongDesc();
        String param0 = "On_Long";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Static Status interface for longText.':  a .onOff.getLongDesc().equals(\"On_Long\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = AuditEntity_OnOff.OFF.getLongDesc();
        param0 = "Off_Long";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Static Status interface for longText.': \"OnOff.off\".getLongDesc().equals(\"Off_Long\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=33, name="Static Status rainy day - null status call.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_33(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity a = new AuditEntity();
        a.setOnOff(null);
        AuditEntity_OnOff leftSide = a.getOnOff();
        Object rightSide = null;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Static Status rainy day - null status call.':  a .onOff ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=34, name="Status read and convert fromString() correctly. ", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_34(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AccountKey_Active activeOff;
        AccountKey_Active activeOn;
        AccountKey_Active operand = activeOn = AccountKey_Active.fromString("1");
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.ON})) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status read and convert fromString() correctly. ':  activeOn  of on           ==>>" + operand + "\n");
        }
        AccountKey_Active operand2 = activeOff = AccountKey_Active.fromString("0");
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand2, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.OFF})) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status read and convert fromString() correctly. ':  activeOff  of off           ==>>" + operand2 + "\n");
        }
        if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)activeOff, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.ON})) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status read and convert fromString() correctly. ': !( activeOff  of on )          ==>> FALSE !\n");
        }
    }

    @OFXTestMethod(id=35, name="Status of operator with single and multiple stati", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_35(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean rightSide;
        AccountKey_Active activeOff = AccountKey_Active.OFF;
        AccountKey_Active operand = activeOff;
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.OFF})) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati':  activeOff  of off           ==>>" + operand + "\n");
        }
        operand = activeOff;
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.ON, AccountKey_Active.OFF})) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati':  activeOff  of on off           ==>>" + operand + "\n");
        }
        boolean result = SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)activeOff, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.OFF});
        boolean leftSide = result;
        if (leftSide != (rightSide = true)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati':  result  == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        result = SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)activeOff, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.ON, AccountKey_Active.OFF});
        leftSide = result;
        if (leftSide != (rightSide = true)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati':  result  == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        result = SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)activeOff, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.ON});
        leftSide = result;
        if (leftSide != (rightSide = false)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati':  result  == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        activeOff = AccountKey_Active.ON;
        if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)activeOff, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.OFF})) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati': !( activeOff  of off )          ==>> FALSE !\n");
        }
        AccountKey_Active operand2 = activeOff;
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand2, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.ON, AccountKey_Active.OFF})) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati':  activeOff  of on off           ==>>" + operand2 + "\n");
        }
        result = !SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)activeOff, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.OFF});
        leftSide = result;
        if (leftSide != (rightSide = true)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati':  result  == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        result = SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)activeOff, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{AccountKey_Active.ON, AccountKey_Active.OFF});
        leftSide = result;
        if (leftSide != (rightSide = true)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Status of operator with single and multiple stati':  result  == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=36, name="OnStatement switch with checks - compound on first", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_36(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        InvoiceStat_TheState state = InvoiceStat_TheState.S2;
        Object check = "";
        if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S1, InvoiceStat_TheState.S2})) {
            check = (String)check + "S1S2";
        } else if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S3})) {
            check = (String)check + "S3";
        } else if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S4})) {
            check = (String)check + "S4";
        } else if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S5})) {
            check = (String)check + "S5";
        } else {
            throw new IllegalStateException("This cannot happen. org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoiceStat_TheState is '" + state + "' which is not handled by this switch statement.");
        }
        Object operand = check;
        String param0 = "S1S2";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.OnStatement switch with checks - compound on first':  check .equals(\"S1S2\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=37, name="OnStatement switch with checks - compound on second", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_37(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        InvoiceStat_TheState state = InvoiceStat_TheState.S2;
        Object check = "";
        if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S1})) {
            check = (String)check + "S1";
        } else if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S2, InvoiceStat_TheState.S3})) {
            check = (String)check + "S2S3";
        } else if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S4})) {
            check = (String)check + "S4";
        } else if (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S5})) {
            check = (String)check + "S5";
        } else {
            throw new IllegalStateException("This cannot happen. org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoiceStat_TheState is '" + state + "' which is not handled by this switch statement.");
        }
        Object operand = check;
        String param0 = "S2S3";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.OnStatement switch with checks - compound on second':  check .equals(\"S2S3\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=38, name="OnStatement switch with checks - with null", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_38(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block17: {
            InvoiceStat_TheState state = null;
            Object check = "";
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            IllegalStateException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                if (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S1})) {
                    check = (String)check + "S1S2";
                    break block17;
                }
                if (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S2})) {
                    check = (String)check + "S2";
                    break block17;
                }
                if (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S3})) {
                    check = (String)check + "S3";
                    break block17;
                }
                if (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S4})) {
                    check = (String)check + "S4";
                    break block17;
                }
                if (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S5})) {
                    check = (String)check + "S5";
                    break block17;
                }
                throw new IllegalStateException("This cannot happen. org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoiceStat_TheState is '" + state + "' which is not handled by this switch statement.");
            }
            catch (IllegalStateException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("cannot happen")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("cannot happen")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("null: Fail In Exception IllegalStateException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("null: Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block17;
                throw new OFXTestSuitException("null: Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=39, name="OnStatement switch with default - null", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_39(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXMetaStatus.IOFXStatusElement state = null;
        Object check = "";
        check = state == null ? (String)check + "null" : (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S1}) ? (String)check + "S1" : (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S2, InvoiceStat_TheState.S3}) ? (String)check + "S2S3" : (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S4}) ? (String)check + "S4" : (SaveObjectComperator.equalsStatus(state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S5}) ? (String)check + "S5" : (String)check + "null"))));
        Object operand = check;
        String param0 = "null";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.OnStatement switch with default - null':  check .equals(\"null\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=40, name="OnStatement switch with default - compound on first", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_40(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        InvoiceStat_TheState state = InvoiceStat_TheState.S2;
        Object check = "";
        check = state == null ? (String)check + "null" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S1, InvoiceStat_TheState.S2}) ? (String)check + "S1S2" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S3}) ? (String)check + "S3" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S4}) ? (String)check + "S4" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S5}) ? (String)check + "S5" : (String)check + "null"))));
        Object operand = check;
        String param0 = "S1S2";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.OnStatement switch with default - compound on first':  check .equals(\"S1S2\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=41, name="OnStatement switch with default - compound on second", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_41(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        InvoiceStat_TheState state = InvoiceStat_TheState.S2;
        Object check = "";
        check = state == null ? (String)check + "null" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S1}) ? (String)check + "S1" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S2, InvoiceStat_TheState.S3}) ? (String)check + "S2S3" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S4}) ? (String)check + "S4" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S5}) ? (String)check + "S5" : (String)check + "null"))));
        Object operand = check;
        String param0 = "S2S3";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.OnStatement switch with default - compound on second':  check .equals(\"S2S3\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=42, name="OnStatement switch with default - using default.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_42(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        InvoiceStat_TheState state = InvoiceStat_TheState.S2;
        Object check = "";
        check = state == null ? (String)check + "S2" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S1}) ? (String)check + "S1" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S3}) ? (String)check + "S2S3" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S4}) ? (String)check + "S4" : (SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)state, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{InvoiceStat_TheState.S5}) ? (String)check + "S5" : (String)check + "S2"))));
        Object operand = check;
        String param0 = "S2";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.OnStatement switch with default - using default.':  check .equals(\"S2\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=43, name="0 bigdecimal literal is same as BigDezimal.ZERO", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_43(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        BigDecimal leftSide = new BigDecimal("0.0");
        BigDecimal rightSide = BigDecimal.ZERO;
        if (leftSide.compareTo(rightSide) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.0 bigdecimal literal is same as BigDezimal.ZERO': 0.0bd ==  .<static field>           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = new BigDecimal("0.00001");
        rightSide = BigDecimal.ZERO;
        if (leftSide.compareTo(rightSide) == 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.0 bigdecimal literal is same as BigDezimal.ZERO': 0.00001bd !=  .<static field>           ==>>" + leftSide + " !=" + rightSide + "\n");
        }
        leftSide = new BigDecimal("1.0");
        rightSide = BigDecimal.ONE;
        if (leftSide.compareTo(rightSide) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.0 bigdecimal literal is same as BigDezimal.ZERO': 1.0bd ==  .<static field>           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=44, name="string / bigdecimal and some simple tests on various binary expressions...", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_44(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object leftSide = "dan";
        Object rightSide = "man";
        if (SaveObjectComperator.equals((Object)leftSide, (Object)rightSide)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': \"dan\" != \"man\"          ==>>" + (String)leftSide + " !=" + (String)rightSide + "\n");
        }
        leftSide = "dan";
        rightSide = "dan";
        if (!SaveObjectComperator.equals((Object)leftSide, (Object)rightSide)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': \"dan\" == (\"d\" + \"an\")          ==>>" + (String)leftSide + " ==" + (String)rightSide + "\n");
        }
        leftSide = new BigDecimal("0.0");
        rightSide = new BigDecimal("0.01");
        if (((BigDecimal)leftSide).compareTo((BigDecimal)rightSide) >= 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': 0.0bd < 0.01bd          ==>>" + (BigDecimal)leftSide + " <" + (BigDecimal)rightSide + "\n");
        }
        leftSide = new BigDecimal("0.0");
        rightSide = new BigDecimal("0.00");
        if (((BigDecimal)leftSide).compareTo((BigDecimal)rightSide) > 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': 0.0bd <= 0.00bd          ==>>" + (BigDecimal)leftSide + " <=" + (BigDecimal)rightSide + "\n");
        }
        leftSide = new BigDecimal("0.001");
        rightSide = new BigDecimal("0.00");
        if (((BigDecimal)leftSide).compareTo((BigDecimal)rightSide) <= 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': 0.001bd > 0.00bd          ==>>" + (BigDecimal)leftSide + " >" + (BigDecimal)rightSide + "\n");
        }
        leftSide = new BigDecimal("0.000");
        rightSide = new BigDecimal("0.00");
        if (((BigDecimal)leftSide).compareTo((BigDecimal)rightSide) < 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': 0.000bd >= 0.00bd          ==>>" + (BigDecimal)leftSide + " >=" + (BigDecimal)rightSide + "\n");
        }
        leftSide = new BigDecimal("0.02").add(new BigDecimal("0.02"));
        if (((BigDecimal)leftSide).compareTo((BigDecimal)(rightSide = new BigDecimal("0.04"))) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': 0.02bd + 0.02bd == 0.04bd          ==>>" + (BigDecimal)leftSide + " ==" + (BigDecimal)rightSide + "\n");
        }
        leftSide = new BigDecimal("0.02").subtract(new BigDecimal("0.02"));
        if (((BigDecimal)leftSide).compareTo((BigDecimal)(rightSide = new BigDecimal("0.00"))) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': 0.02bd - 0.02bd == 0.00bd          ==>>" + (BigDecimal)leftSide + " ==" + (BigDecimal)rightSide + "\n");
        }
        leftSide = new BigDecimal("0.02").multiply(new BigDecimal(2));
        if (((BigDecimal)leftSide).compareTo((BigDecimal)(rightSide = new BigDecimal("0.04"))) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': 0.02bd * 2 == 0.04bd          ==>>" + (BigDecimal)leftSide + " ==" + (BigDecimal)rightSide + "\n");
        }
        leftSide = new BigDecimal("0.04").divide(new BigDecimal(2), RoundingMode.HALF_UP);
        if (((BigDecimal)leftSide).compareTo((BigDecimal)(rightSide = new BigDecimal("0.02"))) != 0) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.string / bigdecimal and some simple tests on various binary expressions...': 0.04bd / 2 == 0.02bd          ==>>" + (BigDecimal)leftSide + " ==" + (BigDecimal)rightSide + "\n");
        }
    }

    @OFXTestMethod(id=45, name="Changing DTOs should not result in dirty set.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_45(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean rightSide;
        MmtNkDTO dto = new MmtNkDTO();
        boolean leftSide = dto.getDirty();
        if (leftSide != (rightSide = false)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Changing DTOs should not result in dirty set.': ((IOFXEntity) dto ).getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        dto.setMyCount(4711);
        dto.setMyName("View Object Changed Test");
        leftSide = dto.getDirty();
        rightSide = false;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.Changing DTOs should not result in dirty set.': ((IOFXEntity) dto ).getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=46, name="DTOs are capable of handling DTO Reference scopes.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_46(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        MmtNkDTO dto = new MmtNkDTO();
        dto.getDtoRef_META().setScope((List)ListSequence.fromListAndArray(new ArrayList(), (Object[])new MmtNkDTO[]{dto}));
        int leftSide = ListSequence.fromList((List)dto.getDtoRef_META().getScope()).count();
        int rightSide = 1;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.DTOs are capable of handling DTO Reference scopes.':  dto .dtoRef#META.getScope().size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        MmtNkDTO operand = (MmtNkDTO)((Object)ListSequence.fromList((List)dto.getDtoRef_META().getScope()).getElement(0));
        MmtNkDTO param0 = dto;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((Object)((Object)operand)).equals((Object)param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.DTOs are capable of handling DTO Reference scopes.':  dto .dtoRef#META.getScope().get.equals( dto )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=47, name="ValueObject equals implemented correctly (espacially BigDeci)", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_47(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        ComplexValueObject c1 = new ComplexValueObject(1, "string", new BigDecimal("12."), Invoice_HeadState.STAT1);
        ComplexValueObject c2 = new ComplexValueObject(1, "string", new BigDecimal("12.000"), Invoice_HeadState.STAT1);
        int leftSide = c1.hashCode();
        if (leftSide != (rightSide = c2.hashCode())) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject equals implemented correctly (espacially BigDeci)':  c1 .hashCode() ==  c2 .hashCode()          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ComplexValueObject operand = c1;
        ComplexValueObject param0 = c2;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject equals implemented correctly (espacially BigDeci)':  c1 .equals( c2 )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=48, name="ValueObject hashcode() implemented correctly (espacially BigDeci)", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_48(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        ComplexValueObject c1 = new ComplexValueObject(1, "string", new BigDecimal("12."), Invoice_HeadState.STAT1);
        ComplexValueObject c2 = new ComplexValueObject(1, "string", new BigDecimal("12."), Invoice_HeadState.STAT1);
        int leftSide = c1.hashCode();
        if (leftSide != (rightSide = c2.hashCode())) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject hashcode() implemented correctly (espacially BigDeci)':  c1 .hashCode() ==  c2 .hashCode()          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ComplexValueObject operand = c1;
        ComplexValueObject param0 = c2;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject hashcode() implemented correctly (espacially BigDeci)':  c1 .equals( c2 )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=49, name="ValueObject hashcode() implemented correctly (espacially null on strings)", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_49(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        ComplexValueObject c1 = new ComplexValueObject(1, null, new BigDecimal("12."), Invoice_HeadState.STAT1);
        ComplexValueObject c2 = new ComplexValueObject(1, null, new BigDecimal("12."), Invoice_HeadState.STAT1);
        int leftSide = c1.hashCode();
        if (leftSide != (rightSide = c2.hashCode())) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject hashcode() implemented correctly (espacially null on strings)':  c1 .hashCode() ==  c2 .hashCode()          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ComplexValueObject operand = c1;
        ComplexValueObject param0 = c2;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject hashcode() implemented correctly (espacially null on strings)':  c1 .equals( c2 )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=50, name="ValueObject hashcode() implemented correctly (espacially null on bigdecis)", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_50(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        ComplexValueObject c1 = new ComplexValueObject(1, "st1", null, Invoice_HeadState.STAT1);
        ComplexValueObject c2 = new ComplexValueObject(1, "st1", null, Invoice_HeadState.STAT1);
        int leftSide = c1.hashCode();
        if (leftSide != (rightSide = c2.hashCode())) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject hashcode() implemented correctly (espacially null on bigdecis)':  c1 .hashCode() ==  c2 .hashCode()          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ComplexValueObject operand = c1;
        ComplexValueObject param0 = c2;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject hashcode() implemented correctly (espacially null on bigdecis)':  c1 .equals( c2 )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=51, name="ValueObject hashcode() implemented correctly (espacially null on status", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_51(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        ComplexValueObject c1 = new ComplexValueObject(1, "st1", new BigDecimal("12.00"), null);
        ComplexValueObject c2 = new ComplexValueObject(1, "st1", new BigDecimal("12.00"), null);
        int leftSide = c1.hashCode();
        if (leftSide != (rightSide = c2.hashCode())) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject hashcode() implemented correctly (espacially null on status':  c1 .hashCode() ==  c2 .hashCode()          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ComplexValueObject operand = c1;
        ComplexValueObject param0 = c2;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'M3 Object Infrastructure.ValueObject hashcode() implemented correctly (espacially null on status':  c1 .equals( c2 )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", M3_Object_Infrastructure.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }
}

