/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.manmap.Tests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Account;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice_HeadState;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Referer;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoAccountAudit;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoReferer;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.SessionLess;
import org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class Query_and_Operators__no_session_
extends OFXTestSuit {
    @Autowired
    private CreatorsFactory __DomainCreatorsFactory;
    @Autowired
    private RepoInvoice __DomainRepoInvoice;
    @Autowired
    private RepoReferer __DomainRepoReferer;
    @Autowired
    private SessionLess __DomainSessionLess;
    @Autowired
    private RepoAccountAudit __DomainRepoAccountAudit;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;
    @OFXIncludedSuit(name="org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
    private DBinit ___inst_DBinit;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    @OFXTestMethod(id=0, name="Datetime to Date conversion in db query.", debug=false, enabled=true, runAt="")
    public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int rightSide2;
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
        Invoice inv2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("second", __manMapSession);
        Invoice inv3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("third", __manMapSession);
        List<Invoice> invoices = this.__DomainRepoInvoice.findInvoiceByDate(DeprecatedServerDateProvider.getSqlServerLocalDate(), null);
        int leftSide = ListSequence.fromList(invoices).count();
        if (leftSide <= (rightSide2 = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Datetime to Date conversion in db query.':  invoices .size > 0          ==>>" + leftSide + " >" + rightSide2 + "\n");
        }
        List<Invoice> invoicesWithConversion = this.__DomainRepoInvoice.findInvoiceByDateCompareDateTime(DeprecatedServerDateProvider.getSqlServerLocalDate(), null);
        int leftSide2 = ListSequence.fromList(invoices).count();
        if (leftSide2 != (rightSide = ListSequence.fromList(invoicesWithConversion).count())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Datetime to Date conversion in db query.':  invoices .size ==  invoicesWithConversion .size          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=1, name="Use <in> operator in query.", debug=false, enabled=true, runAt="")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
        Invoice inv2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("second", __manMapSession);
        Invoice inv3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("third", __manMapSession);
        IListSequence ids = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)ids).addElement((Object)inv1.getId());
        ListSequence.fromList((List)ids).addElement((Object)inv2.getId());
        ListSequence.fromList((List)ids).addElement((Object)inv3.getId());
        int leftSide = ListSequence.fromList((List)ids).count();
        int rightSide2 = 3;
        if (leftSide != rightSide2) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use <in> operator in query.':  ids .size == 3          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        List<Invoice> invoices = this.__DomainRepoInvoice.findInvoiceByIds((List<Integer>)ids, null);
        int leftSide2 = ListSequence.fromList(invoices).count();
        if (leftSide2 != (rightSide = ListSequence.fromList((List)ids).count())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use <in> operator in query.':  invoices .size ==  ids .size          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=2, name="Use the optional operator in query (on integer).", debug=false, enabled=true, runAt="")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("opt1", __manMapSession);
        Invoice inv2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("opt1", __manMapSession);
        Invoice inv3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("opt1", __manMapSession);
        List<Invoice> inv = this.__DomainRepoInvoice.findInvoiceByIdOrByName(inv1.getId(), null, null);
        int leftSide = ListSequence.fromList(inv).count();
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use the optional operator in query (on integer).':  inv .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        inv = this.__DomainRepoInvoice.findInvoiceByIdOrByName(0, "opt1", null);
        leftSide = ListSequence.fromList(inv).count();
        if (leftSide != (rightSide = 3)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use the optional operator in query (on integer).':  inv .size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=3, name="Use the optional operator in query (on list of integer).", debug=false, enabled=true, runAt="")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int rightSide2;
        int rightSide3;
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("opt1_list", __manMapSession);
        Invoice inv2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("opt2_list", __manMapSession);
        List<Invoice> inv = this.__DomainRepoInvoice.findInvoiceByIdOptoinalList(null, null);
        int leftSide = ListSequence.fromList(inv).count();
        if (leftSide <= (rightSide3 = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use the optional operator in query (on list of integer).':  inv .size > 0          ==>>" + leftSide + " >" + rightSide3 + "\n");
        }
        List<Invoice> list2 = this.__DomainRepoInvoice.findInvoiceByIdOptoinalList((List<Integer>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new Integer[]{inv1.getId()}), null);
        int leftSide2 = ListSequence.fromList(list2).count();
        if (leftSide2 != (rightSide2 = 1)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use the optional operator in query (on list of integer).':  list2 .size == 1          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        List<Invoice> list3 = this.__DomainRepoInvoice.findInvoiceByIdOptoinalList((List<Integer>)ListSequence.fromList(new ArrayList()), null);
        int leftSide3 = ListSequence.fromList(list3).count();
        if (leftSide3 != (rightSide = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use the optional operator in query (on list of integer).':  list3 .size == 0          ==>>" + leftSide3 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=4, name="Load with sortBy in query (sortby id reverse)", debug=false, enabled=true, runAt="")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
        Invoice inv2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("second", __manMapSession);
        Invoice inv3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("third", __manMapSession);
        List<Invoice> invoices = this.__DomainRepoInvoice.findInvoicesByIdSortReversId((List<Integer>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new Integer[]{inv1.getId(), inv2.getId(), inv3.getId()}), null);
        int leftSide = ((Invoice)((Object)ListSequence.fromList(invoices).getElement(0))).getId();
        if (leftSide <= (rightSide = ((Invoice)((Object)ListSequence.fromList(invoices).getElement(1))).getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Load with sortBy in query (sortby id reverse)':  invoices .get.id >  invoices .get.id          ==>>" + leftSide + " >" + rightSide + "\n");
        }
        leftSide = ((Invoice)((Object)ListSequence.fromList(invoices).getElement(1))).getId();
        if (leftSide <= (rightSide = ((Invoice)((Object)ListSequence.fromList(invoices).getElement(2))).getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Load with sortBy in query (sortby id reverse)':  invoices .get.id >  invoices .get.id          ==>>" + leftSide + " >" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=5, name="Query on simple string key.", debug=false, enabled=true, runAt="")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Referer ref1 = this.__DomainCreatorsFactory.createRefererEntityWithStringKey("simplestringkeyquery0", __manMapSession);
        this.__DomainRepoReferer.insertReferer(ref1, null);
        List<Referer> reload = this.__DomainRepoReferer.findRefererbyKey(ref1.getKey(), null);
        boolean leftSide = ListSequence.fromList(reload).count() == 1;
        boolean bl = ((Referer)((Object)ListSequence.fromList(reload).first())).getKey().equals(ref1.getKey());
    }

    @OFXTestMethod(id=6, name="Query on simple string name to upercase.", debug=false, enabled=true, runAt="")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Referer ref1 = this.__DomainCreatorsFactory.createRefererEntityWithStringKey("simplestringkeyquery1", __manMapSession);
        this.__DomainRepoReferer.insertReferer(ref1, null);
        List<Referer> reload = this.__DomainRepoReferer.findRefererbyUpperName(ref1.getName().toLowerCase(), null);
        boolean leftSide = ListSequence.fromList(reload).count() == 1;
        boolean bl = ((Referer)((Object)ListSequence.fromList(reload).first())).getName().equals(ref1.getName());
    }

    @OFXTestMethod(id=7, name="Query on simple string name to lowercase.", debug=false, enabled=true, runAt="")
    public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Referer ref1 = this.__DomainCreatorsFactory.createRefererEntityWithStringKey("simplestringkeyquery2", __manMapSession);
        this.__DomainRepoReferer.insertReferer(ref1, null);
        List<Referer> reload = this.__DomainRepoReferer.findRefererbyLowerName(ref1.getName().toUpperCase(), null);
        boolean leftSide = ListSequence.fromList(reload).count() == 1;
        boolean bl = ((Referer)((Object)ListSequence.fromList(reload).first())).getName().equals(ref1.getName());
    }

    @OFXTestMethod(id=8, name="Use Parenthesis and not operation.", debug=false, enabled=true, runAt="")
    public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
        List<Invoice> reloaded = this.__DomainRepoInvoice.findInvoiceByIdNotNotParenthesis(inv1.getId(), null);
        int leftSide = ListSequence.fromList(reloaded).count();
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use Parenthesis and not operation.':  reloaded .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ((Invoice)((Object)ListSequence.fromList(reloaded).first())).getId();
        if (leftSide != (rightSide = inv1.getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use Parenthesis and not operation.':  reloaded .first.id ==  inv1 .id          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=9, name="Query invoices by status.", debug=false, enabled=true, runAt="")
    public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
        Invoice inv2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("second", __manMapSession);
        Invoice inv3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("third", __manMapSession);
        inv1.setHeadState(Invoice_HeadState.STAT2);
        inv2.setHeadState(Invoice_HeadState.STAT2);
        inv3.setHeadState(Invoice_HeadState.STAT2);
        this.__DomainRepoInvoice.checkinInvoice(inv1, null);
        this.__DomainRepoInvoice.checkinInvoice(inv2, null);
        this.__DomainRepoInvoice.checkinInvoice(inv3, null);
        List<Invoice> state2Invoices = this.__DomainRepoInvoice.findAllInvoicesByHeadState(Invoice_HeadState.STAT2, null);
        int leftSide = ListSequence.fromList(state2Invoices).count();
        int rightSide = 3;
        if (leftSide < rightSide) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by status.':  state2Invoices .size >= 3          ==>>" + leftSide + " >=" + rightSide + "\n");
        }
        if (!ListSequence.fromList(state2Invoices).any(it -> it.getId() == inv1.getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by status.':  state2Invoices .any          ==>> FALSE !\n");
        }
        if (!ListSequence.fromList(state2Invoices).any(it -> it.getId() == inv2.getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by status.':  state2Invoices .any          ==>> FALSE !\n");
        }
        if (!ListSequence.fromList(state2Invoices).any(it -> it.getId() == inv3.getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by status.':  state2Invoices .any          ==>> FALSE !\n");
        }
    }

    @OFXTestMethod(id=10, name="Query invoices by status with <in> operator.", debug=false, enabled=true, runAt="")
    public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("invoice1", __manMapSession);
        Invoice invoice2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("invoice2", __manMapSession);
        Invoice invoice3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("invoice3", __manMapSession);
        invoice1.setHeadState(Invoice_HeadState.STAT2);
        invoice2.setHeadState(Invoice_HeadState.DEFAULT);
        invoice3.setHeadState(Invoice_HeadState.STAT2);
        this.__DomainRepoInvoice.checkinInvoice(invoice1, null);
        this.__DomainRepoInvoice.checkinInvoice(invoice2, null);
        this.__DomainRepoInvoice.checkinInvoice(invoice3, null);
        IListSequence headStates = ListSequence.fromListAndArray(new ArrayList(), (Object[])new Invoice_HeadState[]{Invoice_HeadState.STAT2, Invoice_HeadState.DEFAULT});
        List<Invoice> reloadedInvoices = this.__DomainRepoInvoice.findAllInvoicesByHeadStateWithInOp((List<Invoice_HeadState>)headStates, null);
        int leftSide = ListSequence.fromList(reloadedInvoices).count();
        int rightSide = 3;
        if (leftSide < rightSide) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by status with <in> operator.':  reloadedInvoices .size >= 3          ==>>" + leftSide + " >=" + rightSide + "\n");
        }
        if (!ListSequence.fromList(reloadedInvoices).any(it -> it.getId() == invoice1.getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by status with <in> operator.':  reloadedInvoices .any          ==>> FALSE !\n");
        }
        if (!ListSequence.fromList(reloadedInvoices).any(it -> it.getId() == invoice2.getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by status with <in> operator.':  reloadedInvoices .any          ==>> FALSE !\n");
        }
        if (!ListSequence.fromList(reloadedInvoices).any(it -> it.getId() == invoice3.getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by status with <in> operator.':  reloadedInvoices .any          ==>> FALSE !\n");
        }
    }

    @OFXTestMethod(id=11, name="Query invoices by string with <in> operator.", debug=false, enabled=true, runAt="")
    public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
        Invoice inv2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("second", __manMapSession);
        Invoice inv3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("third", __manMapSession);
        IListSequence names = ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{inv1.getName(), inv2.getName(), inv3.getName()});
        List<Invoice> state2Invoices = this.__DomainRepoInvoice.findAllInvoicesByNameWithInOp((List<String>)names, null);
        int leftSide = ListSequence.fromList(state2Invoices).count();
        if (leftSide < (rightSide = 3)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by string with <in> operator.':  state2Invoices .size >= 3          ==>>" + leftSide + " >=" + rightSide + "\n");
        }
        leftSide = ListSequence.fromList(state2Invoices).any(it -> !it.getName().equals(inv1.getName()) && !it.getName().equals(inv2.getName()) && !it.getName().equals(inv3.getName())) ? 1 : 0;
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by string with <in> operator.':  state2Invoices .any == \"false\"          ==>>" + (leftSide != 0) + " ==" + (rightSide != 0) + "\n");
        }
    }

    @OFXTestMethod(id=12, name="Query invoices by string with like operator.", debug=false, enabled=true, runAt="")
    public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("xxlikeopxx", __manMapSession);
        Invoice inv2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("yyylikeopyy", __manMapSession);
        Invoice inv3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("zzlikeopzz", __manMapSession);
        List<Invoice> invoices = this.__DomainRepoInvoice.findInvoiceByIdOrByName(0, "likeop", null);
        int leftSide = ListSequence.fromList(invoices).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by string with like operator.':  invoices .size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        invoices = this.__DomainRepoInvoice.findInvoiceByByNameeWithLikeOP("%likeop%", null);
        leftSide = ListSequence.fromList(invoices).count();
        if (leftSide < (rightSide = 3)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by string with like operator.':  invoices .size >= 3          ==>>" + leftSide + " >=" + rightSide + "\n");
        }
        leftSide = ListSequence.fromList(invoices).any(it -> !it.getName().equals(inv1.getName()) && !it.getName().equals(inv2.getName()) && !it.getName().equals(inv3.getName())) ? 1 : 0;
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query invoices by string with like operator.':  invoices .any == \"false\"          ==>>" + (leftSide != 0) + " ==" + (rightSide != 0) + "\n");
        }
    }

    @OFXTestMethod(id=13, name="Query and use sortBy() without any restriction.", debug=false, enabled=true, runAt="")
    public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("sortby1", __manMapSession);
        Invoice invoice2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("sortby2", __manMapSession);
        Invoice invoice3 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("sortby3", __manMapSession);
        List<InvoicePosition> positions = this.__DomainRepoInvoice.findAllInvoicesPositionsSortByIdReverse(null);
        int leftSide = ListSequence.fromList(positions).count();
        if (leftSide < (rightSide = 12)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Query and use sortBy() without any restriction.':  positions .size >= 12          ==>>" + leftSide + " >=" + rightSide + "\n");
        }
        int maxid = ((InvoicePosition)((Object)ListSequence.fromList(positions).first())).getId() + 1;
        for (InvoicePosition pos : positions) {
            int rightSide2;
            int leftSide2 = pos.getId();
            if (leftSide2 < (rightSide2 = maxid)) continue;
            throw new OFXTestSuitException("'Query and Operators (no session).Query and use sortBy() without any restriction.':  pos .id <  maxid           ==>>" + leftSide2 + " <" + rightSide2 + "\n");
        }
    }

    @OFXTestMethod(id=14, name="Check loding with get(0) does not lead to exception but returns null", debug=false, enabled=true, runAt="")
    public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object rightSide;
        Invoice leftSide = this.__DomainRepoInvoice.getInvoiceByIdRO(0, null);
        if (leftSide != (rightSide = null)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Check loding with get(0) does not lead to exception but returns null': #RepoInvoice.getInvoiceByIdRO(0) ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=15, name="Use BigDecimal constant in query.", debug=false, enabled=true, runAt="")
    public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("bigdeci0", __manMapSession);
        inv.setTotalAmount(new BigDecimal("100.0"));
        this.__DomainRepoInvoice.checkinInvoice(inv, null);
        List<Invoice> invoiceList = this.__DomainRepoInvoice.findInvoiceByIdAndTotalAmountConstant100(inv.getId(), null);
        int leftSide = ListSequence.fromList(invoiceList).count();
        int rightSide = 1;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use BigDecimal constant in query.':  invoiceList .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        BigDecimal leftSide2 = ((Invoice)((Object)ListSequence.fromList(invoiceList).first())).getTotalAmount();
        if (leftSide2.compareTo(rightSide = new BigDecimal("100.0")) != 0) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use BigDecimal constant in query.':  invoiceList .first.totalAmount == 100.0bd          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=16, name="Use debug in insert should not lead to problems.", debug=false, enabled=true, runAt="")
    public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("dbgtext", __manMapSession);
        this.__DomainSessionLess.checkinInvoiceDEBUG(inv, this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices), null);
    }

    @OFXTestMethod(id=17, name="Use debug in update should not lead to problems.", debug=false, enabled=true, runAt="")
    public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("dbgtest", __manMapSession);
        inv.setText("*.* update *.*");
        this.__DomainRepoInvoice.checkinInvoiceDEBUG(inv, null);
    }

    @OFXTestMethod(id=18, name="Use debug in get should not lead to any problems.", debug=false, enabled=true, runAt="")
    public void __testmethod_18(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("dbgtedt", __manMapSession);
        Invoice reloaded = this.__DomainRepoInvoice.getInvoiceDebug(inv.getId(), null);
        int leftSide = reloaded.getId();
        if (leftSide != (rightSide = inv.getId())) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use debug in get should not lead to any problems.':  reloaded .id ==  inv .id          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=19, name="Use debug in delete should not lead to any problems.", debug=false, enabled=true, runAt="")
    public void __testmethod_19(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("dbgtest", __manMapSession);
        this.__DomainRepoInvoice.deleteInoviceDEBUG(inv, null);
    }

    @OFXTestMethod(id=20, name="Use the == null to transform query to IS NULL (string)", debug=false, enabled=true, runAt="")
    public void __testmethod_20(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int count = ListSequence.fromList(this.__DomainRepoInvoice.findAllInvoicesTestIsNULLQueryString(null)).count();
        int leftSide = count;
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use the == null to transform query to IS NULL (string)':  count  == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=21, name="Use the == null to transform query to IS NULL (datetime)", debug=false, enabled=true, runAt="")
    public void __testmethod_21(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int count = ListSequence.fromList(this.__DomainRepoInvoice.findAllInvoicesTestIsNULLQueryDt(null)).count();
        int leftSide = count;
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use the == null to transform query to IS NULL (datetime)':  count  == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=22, name="Use the != null to transform query to IS NULL (int)", debug=false, enabled=true, runAt="")
    public void __testmethod_22(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int count;
        int rightSide;
        int countWithNULLinQuery = ListSequence.fromList(this.__DomainRepoInvoice.findAllInvoicesTestIsNotNULLQueryForInt(null)).count();
        int leftSide = countWithNULLinQuery;
        if (leftSide != (rightSide = (count = ListSequence.fromList(this.__DomainRepoInvoice.findAllInvoices(null)).count()))) {
            throw new OFXTestSuitException("'Query and Operators (no session).Use the != null to transform query to IS NULL (int)':  countWithNULLinQuery  ==  count           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=23, name="Load sub list of list with join, no dirty set", debug=false, enabled=true, runAt="")
    public void __testmethod_23(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int leftSide;
        int rightSide2;
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith2PositionsAnd2SubPos_onDB("sub", __manMapSession);
        Invoice invReloaded = this.__DomainRepoInvoice.checkoutInvoiceWithSub(inv.getId(), null);
        int leftSide2 = ListSequence.fromList(invReloaded.getPositions()).count();
        if (leftSide2 != (rightSide2 = 2)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Load sub list of list with join, no dirty set':  invReloaded .positions.size == 2          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        for (InvoicePosition pos : invReloaded.getPositions()) {
            leftSide = ListSequence.fromList(pos.getSubposition()).count();
            if (leftSide == (rightSide = 2)) continue;
            throw new OFXTestSuitException("'Query and Operators (no session).Load sub list of list with join, no dirty set':  pos .subposition.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = invReloaded.getDirty();
        if (leftSide != (rightSide2 = 0)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Load sub list of list with join, no dirty set': ((IOFXEntity) invReloaded ).getDirty() == \"false\"          ==>>" + (leftSide != 0) + " ==" + (rightSide2 != 0) + "\n");
        }
        for (InvoicePosition pos : invReloaded.getPositions()) {
            leftSide = pos.getDirty() ? 1 : 0;
            if (leftSide == (rightSide = 0)) continue;
            throw new OFXTestSuitException("'Query and Operators (no session).Load sub list of list with join, no dirty set': ((IOFXEntity) pos ).getDirty() == \"false\"          ==>>" + (leftSide != 0) + " ==" + (rightSide != 0) + "\n");
        }
    }

    @OFXTestMethod(id=24, name="Using a Integer-Key which is null on a query map GET return null.", debug=false, enabled=true, runAt="")
    public void __testmethod_24(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object rightSide;
        Invoice invoice = this.__DomainRepoInvoice.checkoutInvoiceHeadGet(0, null);
        Invoice leftSide = invoice;
        if (leftSide != (rightSide = null)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using a Integer-Key which is null on a query map GET return null.':  invoice  ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=25, name="Using a String-Key which is null on a query map GET return null.", debug=false, enabled=true, runAt="")
    public void __testmethod_25(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object rightSide;
        Referer referer = this.__DomainRepoReferer.checkoutReferer("", null);
        Referer leftSide = referer;
        if (leftSide != (rightSide = null)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using a String-Key which is null on a query map GET return null.':  referer  ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=26, name="Using a CompoundKey which is null on a query map GET return null.", debug=false, enabled=true, runAt="")
    public void __testmethod_26(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object rightSide;
        Object rightSide2;
        Account someAccount = this.__DomainCreatorsFactory.createAccount_onDB("get_1", null, __manMapSession);
        Account acc = new Account();
        AccountKey nullKey = acc.getRelatedAccountAuditKEY();
        AccountKey leftSide = nullKey;
        if (leftSide == (rightSide2 = null)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using a CompoundKey which is null on a query map GET return null.':  nullKey  !=  null           ==>>" + leftSide + " !=" + rightSide2 + "\n");
        }
        Account relatedAccount = this.__DomainRepoAccountAudit.checkoutAccountAudit(nullKey, null);
        Account leftSide2 = relatedAccount;
        if (leftSide2 != (rightSide = null)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using a CompoundKey which is null on a query map GET return null.':  relatedAccount  ==  null           ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=27, name="Using objectzflow status of operation in manmap.", debug=false, enabled=true, runAt="")
    public void __testmethod_27(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Invoice inv = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("statusof1", __manMapSession);
        List<Invoice> invoices = this.__DomainRepoInvoice.findInvoiceByStatus("statusof", null);
        int leftSide = ListSequence.fromList(invoices).count();
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using objectzflow status of operation in manmap.':  invoices .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=28, name="Using the limit in a query.", debug=false, enabled=true, runAt="")
    public void __testmethod_28(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int rightSide2;
        List<InvoicePosition> positions = this.__DomainRepoInvoice.findAllInvoicePositions(__manMapSession);
        int leftSide = ListSequence.fromList(positions).count();
        if (leftSide < (rightSide2 = 10)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using the limit in a query.':  positions .size >= 10          ==>>" + leftSide + " >=" + rightSide2 + "\n");
        }
        List<InvoicePosition> positionsLimited = this.__DomainRepoInvoice.findAllInvoicePositionsLimit(5, __manMapSession);
        int leftSide2 = ListSequence.fromList(positionsLimited).count();
        if (leftSide2 != (rightSide = 5)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using the limit in a query.':  positionsLimited .size == 5          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=29, name="Using the count in a query.", debug=false, enabled=true, runAt="")
    public void __testmethod_29(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        long rightSide;
        int rightSide2;
        List<InvoicePosition> positions = this.__DomainRepoInvoice.findAllInvoicePositions(__manMapSession);
        int leftSide = ListSequence.fromList(positions).count();
        if (leftSide < (rightSide2 = 10)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using the count in a query.':  positions .size >= 10          ==>>" + leftSide + " >=" + rightSide2 + "\n");
        }
        long count = this.__DomainRepoInvoice.countAllInvoicePositions(__manMapSession);
        int leftSide2 = ListSequence.fromList(positions).count();
        if ((long)leftSide2 != (rightSide = count)) {
            throw new OFXTestSuitException("'Query and Operators (no session).Using the count in a query.':  positions .size ==  count           ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Query_and_Operators__no_session_.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }
}

