/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

import org.modellwerkstatt.objectflow.batchjob.Message;
import org.modellwerkstatt.objectflow.batchjob.OFXConsumerRunnable;

public class ConsumerThread<EntityOrKey>
extends Thread {
    private Status status;
    private EntityOrKey processingKey;
    private OFXConsumerRunnable consRunable;
    private int id;

    public ConsumerThread(String jobShortName, String pcPairName, OFXConsumerRunnable r, int theId) {
        super((Runnable)r, jobShortName + pcPairName + " Consumer " + theId);
        this.consRunable = r;
        this.id = theId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status stat) {
        this.status = stat;
    }

    public EntityOrKey getProcessingKey() {
        return this.processingKey;
    }

    public void setProcessingKey(EntityOrKey key) {
        this.processingKey = key;
    }

    public void receive(Message msg) {
        this.consRunable.receive(msg);
    }

    public OFXConsumerRunnable getConsumerRunnable() {
        return this.consRunable;
    }

    public int getConsumerId() {
        return this.id;
    }

    public void gcClean() {
        this.consRunable.gcClean();
        this.consRunable = null;
        this.processingKey = null;
    }

    @Override
    public String toString() {
        return this.getName() + " [" + this.status + " / '" + this.processingKey + "']";
    }

    public static enum Status {
        WAITING,
        WORKING,
        SHUTDOWN;

    }
}

