/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

import java.io.File;
import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.objectflow.batchjob.JobProperties;
import org.modellwerkstatt.objectflow.batchjob.RollatingLogger;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;

public class JobReporter
extends NotificationBroadcasterSupport
implements IOFXUserServices {
    public static final int PRODUCER_ID = -1;
    private static final int NUM_ROLLATING_MSG = 40;
    public static DateTimeFormatter EXACT_TIME_ONLY_FORMATTER = DateTimeFormat.forPattern((String)"dd.MMM HH:mm:ss.SSS");
    protected JobProperties props;
    protected int id;
    protected String pcPairName;
    protected String pcPairSource;
    protected IOFXCoreReporter coreReporter;
    protected IPrintingServiceImpl userPrintService;
    private boolean consoleMode = true;
    private boolean traceEnabled;
    private long sequence = 0L;
    private RollatingLogger rollatingLogger;
    private RollatingLogger traceRollatingLogger;
    private int protocollledExceptionCount = 0;
    private int unProtocollledExceptionCount = 0;
    protected String userNameAndId;

    public JobReporter(String aPcPairName, int idOrProducer, JobProperties aProps) {
        this.id = idOrProducer;
        this.pcPairName = aPcPairName;
        this.props = aProps;
        this.userNameAndId = this.props.userName + "_" + this.props.userId;
        this.pcPairSource = this.id == -1 ? "PRODUCER" : "CONSUMER " + this.id;
        this.pcPairSource = this.pcPairSource + " " + this.pcPairName;
        this.rollatingLogger = new RollatingLogger(40);
        this.traceRollatingLogger = new RollatingLogger(80);
        this.traceEnabled = false;
    }

    public void initUserServices(IPrintingServiceImpl printServiceImp, IOFXCoreReporter reporter) {
        this.userPrintService = printServiceImp;
        this.coreReporter = reporter;
    }

    public void consoleModeOff() {
        this.consoleMode = false;
    }

    public boolean isConsoleMode() {
        return this.consoleMode;
    }

    protected CoreReporterInfo createInfoObject(IOFXCoreReporter.Type typ, IOFXCoreReporter.LogPriority prio, String desc) {
        CoreReporterInfo info = new CoreReporterInfo(typ, this.props.swJobFqName, this.props.swJobVersion, "org.modellwerkstatt.Event", "", "", prio, this.props.userId, this.props.userName, this.pcPairSource, "" + this.id, this.props.systemName, "moware11 2025.24 (dck)", IOFXCoreReporter.MoWarePlatform.MOWARE_JOB, this.props.systemName, desc);
        return info;
    }

    public void jmxLog(boolean trace, String prio, String msg, Throwable t) {
        Object exInfo = "";
        if (t != null) {
            exInfo = " [" + t.getClass().getSimpleName() + " " + t.getMessage() + "]";
        }
        long currentMillis = System.currentTimeMillis();
        String rollLoggerTxtMsg = String.format("%25s %s%s", EXACT_TIME_ONLY_FORMATTER.print((ReadableInstant)new DateTime(currentMillis)), msg, exInfo);
        if (this.traceEnabled && trace) {
            this.traceRollatingLogger.add(rollLoggerTxtMsg);
            if (!this.consoleMode) {
                Notification n = new Notification(prio, this, this.sequence++, currentMillis, msg + (String)exInfo);
                n.setUserData(this.userNameAndId);
                this.sendNotification(n);
            }
        } else if (trace) {
            this.traceRollatingLogger.add(rollLoggerTxtMsg);
        } else if (!trace) {
            this.rollatingLogger.add(rollLoggerTxtMsg);
            if (!this.consoleMode) {
                Notification n = new Notification(prio, this, this.sequence++, currentMillis, msg + (String)exInfo);
                n.setUserData(this.userNameAndId);
                this.sendNotification(n);
            }
        }
    }

    @Override
    public void logOnCoreReporter(String cmdFqName, String sessId, String source, IOFXCoreReporter.LogPriority prio, String desc, HashMap<String, Object> paramMap) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, prio, desc);
        info.setCmdFqName(cmdFqName);
        info.setSource(source);
        if (paramMap != null) {
            for (String key : paramMap.keySet()) {
                info.addParameter(key, paramMap.get(key));
            }
        }
        this.coreReporter.report(info);
        this.jmxLog(false, "" + prio, desc, null);
    }

    public void logFrmwrkTrace(String msg) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE, IOFXCoreReporter.LogPriority.TRACE, msg);
        info.setSource("org.modellwerkstatt.Event");
        this.coreReporter.report(info);
        this.jmxLog(true, "MOWARE TRACE", msg, null);
    }

    public void logFrmwrkError(String msg, Throwable t) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_PROBLEM, IOFXCoreReporter.LogPriority.ERROR, msg);
        info.setSource("org.modellwerkstatt.RT");
        info.setException(t);
        this.coreReporter.report(info);
        this.jmxLog(false, "ERROR", msg, t);
    }

    public void logJobProblem(boolean alreadyLogged, String desc, Throwable t, String param) {
        ++this.protocollledExceptionCount;
        if (!alreadyLogged) {
            CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_PROBLEM, IOFXCoreReporter.LogPriority.ERROR, desc);
            info.setException(t);
            if (param != null) {
                info.addParameter("param", param);
            }
            this.coreReporter.report(info);
        }
        this.jmxLog(false, "ERROR", desc, t);
    }

    public void skipReportingEx() {
        ++this.unProtocollledExceptionCount;
    }

    public int getxExceptions_protocolled() {
        return this.protocollledExceptionCount;
    }

    public int getxExceptions_unprotocolled() {
        return this.unProtocollledExceptionCount;
    }

    public String fullStatusReport() {
        return this.rollatingLogger.toString();
    }

    public String fullStatusReportTraceLevel() {
        return this.traceRollatingLogger.toString();
    }

    public String enableTracing(boolean enabled) {
        this.traceEnabled = enabled;
        return "Tracing in now " + this.traceEnabled;
    }

    @Override
    public File renderPrint(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        return this.userPrintService.renderPrint(documentFilename, xsltTemplateName, xmlGraphData, barcode);
    }

    @Override
    public File renderView(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        return this.userPrintService.renderView(documentFilename, xsltTemplateName, xmlGraphData, barcode);
    }

    @Override
    public File render(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        return this.userPrintService.render(documentFilename, xsltTemplateName, xmlGraphData, barcode);
    }

    @Override
    public void view(File pdfFile) {
        this.userPrintService.view(pdfFile);
    }

    @Override
    public void print(File pdfFile) {
        this.userPrintService.print(pdfFile);
    }

    @Override
    public void openUrl(String url) {
        this.userPrintService.openUrl(url);
    }

    public String assembleJMXPrefix(String pairId, boolean producer, int id) {
        String jobName = this.props.swJobFqName + "_" + this.props.swJobVersion.replace(" ", "_").replace(".", "_");
        String[] splittedFqNAme = jobName.split("\\.");
        Object assebledJMXNamePrefix = "";
        if (splittedFqNAme.length > 2) {
            splittedFqNAme[0] = splittedFqNAme[0] + "." + splittedFqNAme[1];
            splittedFqNAme[1] = null;
        }
        for (int i = 0; i < splittedFqNAme.length; ++i) {
            if (i == 0) {
                assebledJMXNamePrefix = (String)assebledJMXNamePrefix + splittedFqNAme[i] + ":";
                continue;
            }
            if (splittedFqNAme[i] == null) continue;
            assebledJMXNamePrefix = (String)assebledJMXNamePrefix + String.format("%02d=%s,", i - 1, splittedFqNAme[i]);
        }
        assebledJMXNamePrefix = (String)assebledJMXNamePrefix + "name=";
        assebledJMXNamePrefix = producer ? (String)assebledJMXNamePrefix + pairId + "_Producer" : (String)assebledJMXNamePrefix + pairId + "_Consumer" + id;
        return assebledJMXNamePrefix;
    }

    public String convertGuardMsg(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof OFXShutDownSessionException) {
            IOFXProblem prblm = ((OFXShutDownSessionException)t).getProblem();
            return prblm.getSimpleUserText();
        }
        return t.getMessage();
    }
}

