/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

import java.util.TimerTask;
import org.modellwerkstatt.objectflow.batchjob.IOFXTimerMasterController;
import org.modellwerkstatt.objectflow.batchjob.Message;
import org.modellwerkstatt.objectflow.batchjob.OFXPCPairController;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;

public class MsgFromTimer
extends TimerTask {
    private OFXPCPairController controller;
    private IOFXTimerMasterController timerController;
    private Message message;
    private int issuedVersion;

    public MsgFromTimer(IOFXTimerMasterController timerCrtl, OFXPCPairController crtl, Message msg, int version) {
        this.timerController = timerCrtl;
        this.controller = crtl;
        this.message = msg;
        this.issuedVersion = version;
    }

    @Override
    public void run() {
        int currentVersion = this.timerController.getCurrentTimerVersion();
        if (currentVersion != this.issuedVersion) {
            OFXLogger.log(MsgFromTimer.class, IOFXCoreReporter.LogPriority.ERROR, "Fallback: TimerMsg " + this.message + " for " + this.controller.getPCPairName() + "/" + this.controller.getPCPairID() + " ignored since versions do not match: issued " + this.issuedVersion + " to current " + currentVersion, null);
        } else {
            this.controller.receive(this.message);
        }
        this.timerController = null;
        this.controller = null;
        this.message = null;
    }

    public OFXPCPairController getCrtl() {
        return this.controller;
    }

    public Message getMessage() {
        return this.message;
    }
}

