/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class MultiCronJobDesc {
    public static final int MIN_MILL_DELAY = 1000;
    private List<CronSequenceGenerator> cronSequenceGenerators = new ArrayList<CronSequenceGenerator>();
    private List<String> cronExpressions = new ArrayList<String>();
    private int delayInMs = -1;
    private int pairId;
    private String pairName;

    public MultiCronJobDesc(int pairCrltId, String pairCrtlName) {
        this.pairId = pairCrltId;
        this.pairName = pairCrtlName;
    }

    public void addCron(String cronExp) {
        CronSequenceGenerator seq = new CronSequenceGenerator(cronExp, TimeZone.getDefault());
        this.cronSequenceGenerators.add(seq);
        this.cronExpressions.add(cronExp);
        if (this.isCronWindowMode()) {
            throw new RuntimeException("Set cron expressions first, ");
        }
    }

    public void setDelayInMS(int millis) {
        this.delayInMs = millis;
    }

    public boolean isCronWindowMode() {
        return this.delayInMs > 0;
    }

    public void checkModeOK() {
        block5: {
            if (!this.isCronWindowMode() && this.cronExpressions.size() == 0) break block5;
            if (this.isCronWindowMode()) {
                for (int i = 0; i < this.cronExpressions.size(); ++i) {
                    if (this.cronExpressions.get(i).startsWith("* ")) continue;
                    throw new RuntimeException("When specifying cron expressions in delay/continous mode, specify a cron window in form of '* * 3-23 * * *' and not '" + this.cronExpressions.get(i) + "'");
                }
            } else {
                if (this.cronExpressions.size() <= 0) {
                    throw new RuntimeException("A cron expression is necessary, when running in time-specific mode. There are none given currently.");
                }
                for (int i = 0; i < this.cronExpressions.size(); ++i) {
                    if (!this.cronExpressions.get(i).startsWith("*")) continue;
                    throw new RuntimeException("When specifying cron expressions in time-specific mode, specify a specific time (starting at a specific sec) in form of '0 0 23 * * *' and not '" + this.cronExpressions.get(i) + "'");
                }
            }
        }
    }

    public DateTime nextEarlyiestRunMS(int waitingTimeInMs) {
        this.checkModeOK();
        DateTime dNowPlusWaiting = new DateTime();
        if (this.isCronWindowMode()) {
            if (waitingTimeInMs <= 0) {
                waitingTimeInMs = this.delayInMs;
            }
            dNowPlusWaiting = dNowPlusWaiting.plusMillis(waitingTimeInMs);
            if (this.cronSequenceGenerators.size() <= 0) {
                return dNowPlusWaiting;
            }
            DateTime nextEarliestRun = new DateTime((Object)this.cronSequenceGenerators.get(0).next(dNowPlusWaiting.toDate()));
            for (int i = 1; i < this.cronSequenceGenerators.size(); ++i) {
                DateTime newDate = new DateTime((Object)this.cronSequenceGenerators.get(i).next(dNowPlusWaiting.toDate()));
                if (!newDate.isBefore((ReadableInstant)nextEarliestRun)) continue;
                nextEarliestRun = newDate;
            }
            return nextEarliestRun;
        }
        if (waitingTimeInMs > 0) {
            dNowPlusWaiting = dNowPlusWaiting.plusMillis(waitingTimeInMs);
            return dNowPlusWaiting;
        }
        DateTime nextEarliestRun = new DateTime((Object)this.cronSequenceGenerators.get(0).next(dNowPlusWaiting.toDate()));
        for (int i = 1; i < this.cronSequenceGenerators.size(); ++i) {
            DateTime newDate = new DateTime((Object)this.cronSequenceGenerators.get(i).next(dNowPlusWaiting.toDate()));
            if (!newDate.isBefore((ReadableInstant)nextEarliestRun)) continue;
            nextEarliestRun = newDate;
        }
        return nextEarliestRun;
    }

    public boolean canRunAccoordingToCronWindowInDelayMode(DateTime when) {
        if (!this.isCronWindowMode()) {
            return true;
        }
        if (this.cronSequenceGenerators.size() <= 0) {
            return true;
        }
        boolean canRun = false;
        for (int i = 0; i < this.cronSequenceGenerators.size(); ++i) {
            DateTime newDate = new DateTime((Object)this.cronSequenceGenerators.get(i).next(when.toDate()));
            long diff = newDate.getMillis() - when.getMillis();
            if (diff >= 2000L) continue;
            return true;
        }
        return canRun;
    }

    public String toString() {
        Object s = "";
        if (this.isCronWindowMode()) {
            s = (String)s + "delayMode " + this.delayInMs + " millis";
        }
        for (int i = 0; i < this.cronSequenceGenerators.size(); ++i) {
            s = (String)s + this.cronSequenceGenerators.get(i).toString().replace("CronSequenceGenerator:", "") + ", ";
        }
        return s;
    }

    public int getPairID() {
        return this.pairId;
    }

    public void checkForCronInDependentMode(boolean first) {
        if (first) {
            if (this.cronExpressions.size() <= 0 && !this.isCronWindowMode()) {
                throw new RuntimeException("First cronDescriptions needs to be in delay mode or has a cron in dependent mode. cron: " + this.cronExpressions.size() + " delayMode: " + this.isCronWindowMode());
            }
        } else if (this.cronExpressions.size() != 0 || this.isCronWindowMode()) {
            throw new RuntimeException("CronDesc for pair in dependent mode should not has any configuration!  cron: " + this.cronExpressions.size() + " delayMode: " + this.isCronWindowMode());
        }
    }

    public String getPairName() {
        return this.pairName;
    }

    public static void main(String[] args) {
        CronSequenceGenerator cst = new CronSequenceGenerator("* * 10-21 * * *");
        System.err.println("> " + cst.next(new Date()));
    }
}

