/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.modellwerkstatt.objectflow.batchjob.IOFXTimerMasterController;
import org.modellwerkstatt.objectflow.batchjob.JobProperties;
import org.modellwerkstatt.objectflow.batchjob.JobReporter;
import org.modellwerkstatt.objectflow.batchjob.Message;
import org.modellwerkstatt.objectflow.batchjob.MsgFromTimer;
import org.modellwerkstatt.objectflow.batchjob.MultiCronJobDesc;
import org.modellwerkstatt.objectflow.batchjob.OFXBatchJobHtmlDashboard;
import org.modellwerkstatt.objectflow.batchjob.OFXPCPairController;
import org.modellwerkstatt.objectflow.batchjob.RollatingLogger;
import org.modellwerkstatt.objectflow.batchjob.RunProducerMsg;
import org.modellwerkstatt.objectflow.batchjob.SchedInfo;
import org.modellwerkstatt.objectflow.batchjob.ShutdownMsg;
import org.modellwerkstatt.objectflow.batchjob.WakeupPairCrtlMsg;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;

public class OFXCronMasterController
implements IOFXTimerMasterController {
    private static final boolean LOG_DBG_LEVEL = true;
    private List<MultiCronJobDesc> multiCronJobDescriptions;
    private List<OFXPCPairController> pcPairController;
    private boolean dependentMode = false;
    private boolean singleRunMode = false;
    private volatile int timerVersion = 0;
    private Timer timer;
    private RollatingLogger rolLog = new RollatingLogger(50);
    private JobProperties properties;

    public OFXCronMasterController() {
        this.multiCronJobDescriptions = new ArrayList<MultiCronJobDesc>();
        this.pcPairController = new ArrayList<OFXPCPairController>();
    }

    @Override
    public JobProperties getJobProperties() {
        return this.properties;
    }

    public void switchToNextCrtl(OFXPCPairController crtl, int minWaitingTimeMs) {
        this.ll(crtl, "switchToNextCrtl() was crtlId: " + crtl.getPCPairID() + " (wait min " + minWaitingTimeMs + " ms.)");
        int finishedId = crtl.getPCPairID();
        if (finishedId >= this.pcPairController.size() - 1) {
            if (this.singleRunMode) {
                this.info("Last pair executed " + crtl.getPCPairName() + " / " + crtl.getPCPairID() + ". Single run of job completed.", true);
                OFXPCPairController firstCrlt = this.pcPairController.get(0);
                firstCrlt.receive(new ShutdownMsg());
            } else {
                DateTime nextRun = this.multiCronJobDescriptions.get(0).nextEarlyiestRunMS(minWaitingTimeMs);
                OFXPCPairController firstCrlt = this.pcPairController.get(0);
                this.SCHED_OR_NOW(firstCrlt, new RunProducerMsg(firstCrlt.getPCPairID(), RunProducerMsg.Source.MASTERCRTL), nextRun);
            }
        } else {
            this.info("Processed " + crtl.getPCPairName() + " / " + crtl.getPCPairID() + " switching to next producer/consumer pair.", true);
            OFXPCPairController nextCrtl = this.pcPairController.get(finishedId + 1);
            RunProducerMsg m = new RunProducerMsg(nextCrtl.getPCPairID(), RunProducerMsg.Source.MASTERCRTL);
            if (minWaitingTimeMs > 0) {
                DateTime nextRun = this.multiCronJobDescriptions.get(0).nextEarlyiestRunMS(minWaitingTimeMs);
                this.SCHED_OR_NOW(nextCrtl, m, nextRun);
            } else {
                nextCrtl.receive(m);
            }
        }
    }

    @Override
    public void runCompletedResched(OFXPCPairController crtl) {
        this.ll(crtl, "runCompletedResched() for crtlId: " + crtl.getPCPairID());
        int finishedId = crtl.getPCPairID();
        if (this.dependentMode) {
            this.switchToNextCrtl(crtl, 0);
        } else {
            DateTime nextRun = this.multiCronJobDescriptions.get(finishedId).nextEarlyiestRunMS(0);
            this.SCHED_OR_NOW(crtl, new RunProducerMsg(finishedId, RunProducerMsg.Source.MASTERCRTL), nextRun);
        }
    }

    @Override
    public SchedInfo runNotCompletedDueEXResched(OFXPCPairController crtl, int minWaitingTimeInMS, boolean prodRun, boolean inboxEmpty) {
        boolean emptyInboxAndNextCronDraw;
        this.ll(crtl, "runNotCompletedDueEXResched() in crtlId: " + crtl.getPCPairID() + " (min wait  " + minWaitingTimeInMS + "ms, prodRun? " + prodRun + ", inboxEmpty? " + inboxEmpty + ")");
        this.info("runNotCompletedDueEXResched() for " + crtl.getPCPairName() + " / " + crtl.getPCPairID() + " in " + minWaitingTimeInMS + "ms.", false);
        if (this.dependentMode) {
            DateTime nextRun = this.multiCronJobDescriptions.get(0).nextEarlyiestRunMS(minWaitingTimeInMS);
            OFXPCPairController firstCrtl = this.pcPairController.get(0);
            return this.SCHED_OR_NOW(firstCrtl, new RunProducerMsg(firstCrtl.getPCPairID(), RunProducerMsg.Source.MASTERCRTL), nextRun);
        }
        int exPairCrtl = crtl.getPCPairID();
        boolean cronWindowMode = this.multiCronJobDescriptions.get(exPairCrtl).isCronWindowMode();
        DateTime nextRun = this.multiCronJobDescriptions.get(exPairCrtl).nextEarlyiestRunMS(minWaitingTimeInMS);
        Message msgToSend = new WakeupPairCrtlMsg(exPairCrtl);
        boolean bl = emptyInboxAndNextCronDraw = !cronWindowMode && inboxEmpty && minWaitingTimeInMS <= 0;
        if (prodRun || emptyInboxAndNextCronDraw) {
            msgToSend = new RunProducerMsg(exPairCrtl, RunProducerMsg.Source.MASTERCRTL);
        }
        return this.SCHED_OR_NOW(crtl, msgToSend, nextRun);
    }

    @Override
    public SchedInfo runNotCompletedOutOfCronWindowResched(OFXPCPairController crtl, boolean prodRun) {
        this.ll(crtl, "runNotCompletedOutOfCronWindowResched() from crtlId: " + crtl.getPCPairID() + " prodRun? " + prodRun);
        if (this.dependentMode) {
            DateTime nextRun = this.multiCronJobDescriptions.get(0).nextEarlyiestRunMS(0);
            OFXPCPairController firstCrtl = this.pcPairController.get(0);
            return this.SCHED_OR_NOW(firstCrtl, new RunProducerMsg(firstCrtl.getPCPairID(), RunProducerMsg.Source.MASTERCRTL), nextRun);
        }
        int toRunCrtl = crtl.getPCPairID();
        DateTime nextRun = this.multiCronJobDescriptions.get(toRunCrtl).nextEarlyiestRunMS(0);
        Message msgToSend = new WakeupPairCrtlMsg(toRunCrtl);
        if (prodRun) {
            msgToSend = new RunProducerMsg(toRunCrtl, RunProducerMsg.Source.MASTERCRTL);
        }
        return this.SCHED_OR_NOW(crtl, msgToSend, nextRun);
    }

    @Override
    public boolean outOfCronWindow(OFXPCPairController crtl) {
        int qId = crtl.getPCPairID();
        if (this.dependentMode) {
            qId = 0;
        }
        return !this.multiCronJobDescriptions.get(qId).canRunAccoordingToCronWindowInDelayMode(new DateTime());
    }

    @Override
    public boolean enableTimer(boolean enabled) {
        if (this.timer == null) {
            System.err.println("gcClean() on OFXCronMasterController already called. ");
            return false;
        }
        this.ll(null, "enableTimer( " + enabled + " ) called.");
        if (!enabled) {
            this.timer.cancel();
            return enabled;
        }
        this.timer = new Timer(MoVersion.getShortNameFromFQ(this.properties.swJobFqName) + "_Tmr");
        this.initialProducerRuns();
        return enabled;
    }

    @Override
    public void shuttingDown(OFXPCPairController crtl) {
        try {
            this.ll(crtl, "shuttingDown( " + crtl + ")");
            this.enableTimer(false);
            for (OFXPCPairController aCrtl : this.pcPairController) {
                if (aCrtl == crtl || !aCrtl.needsShutdownMsg()) continue;
                aCrtl.receive(new ShutdownMsg());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public int getCurrentTimerVersion() {
        return this.timerVersion;
    }

    @Override
    public int clearJobTimerState() {
        ++this.timerVersion;
        this.ll(null, "clear job timer state, version increased to " + this.timerVersion + ". exec initialProducerRuns().");
        this.initialProducerRuns();
        return this.timerVersion;
    }

    public void initialProducerRuns() {
        int cronJobsDescriptionsToHandle = this.pcPairController.size();
        if (this.dependentMode) {
            cronJobsDescriptionsToHandle = 1;
        }
        for (int i = 0; i < cronJobsDescriptionsToHandle; ++i) {
            OFXPCPairController crtl = this.pcPairController.get(i);
            RunProducerMsg msg = new RunProducerMsg(crtl.getPCPairID(), RunProducerMsg.Source.MASTERCRTL);
            if (this.multiCronJobDescriptions.get(i).isCronWindowMode() && this.multiCronJobDescriptions.get(i).canRunAccoordingToCronWindowInDelayMode(new DateTime())) {
                this.SCHED_OR_NOW(crtl, msg, new DateTime());
                continue;
            }
            DateTime nextRun = this.multiCronJobDescriptions.get(i).nextEarlyiestRunMS(0);
            this.SCHED_OR_NOW(crtl, msg, nextRun);
        }
    }

    public void init(JobProperties props) {
        this.properties = props;
        this.timer = new Timer(MoVersion.getShortNameFromFQ(props.swJobFqName) + "_Tmr");
    }

    public void setDependentMode() {
        for (int i = 0; i < this.multiCronJobDescriptions.size(); ++i) {
            this.multiCronJobDescriptions.get(i).checkForCronInDependentMode(i == 0);
        }
        this.dependentMode = true;
    }

    public void add(OFXPCPairController pcrtl) {
        int nextIndex = this.multiCronJobDescriptions.size();
        if (nextIndex != this.pcPairController.size()) {
            throw new IllegalStateException("Internal Error, descriptions and controller instances out of sync. desc: " + this.multiCronJobDescriptions.size() + " pcPairCrtl: " + this.pcPairController.size());
        }
        if (nextIndex != pcrtl.getPCPairID()) {
            throw new IllegalArgumentException("You can not add Crtl with ID " + pcrtl.getPCPairID() + " as nextIndex " + nextIndex);
        }
        this.multiCronJobDescriptions.add(new MultiCronJobDesc(pcrtl.getPCPairID(), pcrtl.getPCPairName()));
        this.pcPairController.add(pcrtl);
    }

    public void addCron(int id, String cr) {
        if (this.dependentMode) {
            throw new IllegalStateException("After setting dependent mode, no cron expressions can be added");
        }
        if (id >= this.multiCronJobDescriptions.size()) {
            throw new IllegalArgumentException("Id is larger than curren registered pairControllers");
        }
        this.multiCronJobDescriptions.get(id).addCron(cr);
    }

    public void setDelayInMS(int id, int delayInMs) {
        if (this.dependentMode) {
            throw new IllegalStateException("After setting dependent mode, no delays can be set");
        }
        if (id >= this.multiCronJobDescriptions.size()) {
            throw new IllegalArgumentException("Id is larger than curren registered pairControllers");
        }
        this.multiCronJobDescriptions.get(id).setDelayInMS(delayInMs);
    }

    public OFXPCPairController getPair(int id) {
        return this.pcPairController.get(id);
    }

    public SchedInfo SCHED_OR_NOW(OFXPCPairController crtl, Message msgToCrtl, DateTime dt) {
        SchedInfo info;
        MsgFromTimer msg = new MsgFromTimer(this, crtl, msgToCrtl, this.timerVersion);
        msg.getCrtl().addSchedEntry(dt);
        String target = msg.getCrtl().getPCPairID() + "_" + msg.getCrtl().getPCPairName();
        String msgDesc = msg.getMessage().getClass().getSimpleName();
        String logEntry = "sched entry for " + target + " => " + msg.getMessage() + "      @ " + OFXPCPairController.DATENTIME_FORMAT_EXACT.print((ReadableInstant)dt) + "  -  ";
        if (dt.isBefore((ReadableInstant)new DateTime().plusMillis(900))) {
            this.ll(crtl, logEntry + " running immediatelly.");
            msg.run();
            info = new SchedInfo(msgDesc + " for " + target + " (done imdtly)", new DateTime());
        } else {
            this.ll(crtl, logEntry + " added to timer.");
            try {
                this.timer.schedule((TimerTask)msg, dt.toDate());
                info = new SchedInfo(msgDesc + " for " + target, dt);
            }
            catch (IllegalStateException ise) {
                crtl.logJobProblem(false, "Job timer ex, but job not crashed. Check next timer for next run!", ise, ise.getMessage());
                info = new SchedInfo("Timer " + ise.getClass().getSimpleName() + " @ " + new DateTime() + " while sched for " + dt, dt);
            }
        }
        return info;
    }

    public void buildHtmlDashboardInfo(OFXBatchJobHtmlDashboard dashinfo) {
        dashinfo.addSection(this.properties.swJobFqName);
        dashinfo.addMonitoringInfo("information generated at ", "" + new DateTime());
        dashinfo.addMonitoringInfo("job fq name", this.properties.swJobFqName);
        dashinfo.addMonitoringInfo("job version", this.properties.swJobVersion);
        dashinfo.addMonitoringInfo("moware plugin version", this.properties.mowareVersion);
        dashinfo.addMonitoringInfo("username and id", this.properties.userName + "_" + this.properties.userId);
        dashinfo.addMonitoringInfo("datasource connection url ", this.properties.connectionInfo);
        dashinfo.addMonitoringInfo("&nbsp;", "&nbsp;");
        for (int i = 0; i < this.pcPairController.size(); ++i) {
            OFXPCPairController crtl = this.pcPairController.get(i);
            dashinfo.addSection("Consumer/Producer Pair " + crtl.getPCPairID() + ": " + crtl.getPCPairName());
            dashinfo.addMonitoringInfo("Number of Consumers", "" + crtl.getNumberOfConsumers());
            dashinfo.addMonitoringInfo("Startuptime", crtl.getbatchjob_StartupTime());
            dashinfo.addMonitoringInfo("Cron sched settings", crtl.getbatchjob_PairSchedExpressions());
            dashinfo.addMonitoringInfo("Consumer processings ok", "" + crtl.getoverall1_ConsumerItemsOk());
            dashinfo.addMonitoringInfo("Consumer processings canceled", "" + crtl.getoverall2_ConsumerItemsCanceled());
            dashinfo.addMonitoringInfo("Consumer processings ex", "" + crtl.getoverall3_ConsumerItemsEx());
            dashinfo.addMonitoringInfo("Protocolled EX", "" + crtl.getxExceptions_protocolled());
            dashinfo.addMonitoringInfo("Unprotocolled EX", "" + crtl.getxExceptions_unprotocolled());
            dashinfo.addMonitoringInfo("Producer enabled", "" + crtl.getproducer6_ProducerEnabled());
            dashinfo.addMonitoringInfo("Next Sched", crtl.getproducer7_NextScheduledRuns());
            dashinfo.addMonitoringInfo("Internal State", crtl.getproducer1_InternalState());
            dashinfo.addMonitoringInfo("Last Fillup", crtl.getinbox_LastFillup());
            dashinfo.addMonitoringInfo("Log", "<code>" + crtl.fullStatusReport().replace("\n", "<br/>") + " </code>");
        }
        dashinfo.addMonitoringInfo("&nbsp;", "&nbsp;");
        dashinfo.addSection(this.properties.swJobFqName);
        dashinfo.addMonitoringInfo("Timer Log (Tracing)", "<code> " + this.getFullStatusReport(null).replace("\n", "<br/>") + " </code>");
    }

    public void ensureJMXUnregistered() {
        for (int i = 0; i < this.pcPairController.size(); ++i) {
            this.pcPairController.get(i).jmxUnregister();
        }
    }

    @Override
    public String getSchedSetting(OFXPCPairController pair) {
        if (this.dependentMode && pair.getPCPairID() != 0) {
            return "(dependent)";
        }
        return this.multiCronJobDescriptions.get(pair.getPCPairID()).toString();
    }

    @Override
    public String getFullStatusReport(OFXPCPairController crtl) {
        return this.rolLog.toString();
    }

    public void setSingleRunMode() {
        this.singleRunMode = true;
    }

    private void ll(OFXPCPairController crtl, String msg) {
        String logEntry = JobReporter.EXACT_TIME_ONLY_FORMATTER.print((ReadableInstant)new DateTime()) + ": " + msg;
        if (crtl != null) {
            crtl.logFrmwrkTrace("OFXCronMasterContoller() " + msg);
        }
        this.rolLog.add(logEntry);
    }

    private void info(String msg, boolean newSection) {
        String logEntry = JobReporter.EXACT_TIME_ONLY_FORMATTER.print((ReadableInstant)new DateTime()) + ": " + msg;
        if (newSection) {
            logEntry = "\n\n - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n" + logEntry;
        }
        if (this.singleRunMode) {
            OFXLogger.logConsole(logEntry);
        }
    }

    public void gcClean() {
        this.timer.cancel();
        this.timer = null;
        this.pcPairController.clear();
        this.pcPairController = null;
        this.multiCronJobDescriptions.clear();
        this.multiCronJobDescriptions = null;
    }
}

