/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.objectflow.batchjob.JobProperties;
import org.modellwerkstatt.objectflow.batchjob.JobReporter;
import org.modellwerkstatt.objectflow.batchjob.PCPairReporterMBean;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.TelemetricsLongAbsoluter;

public abstract class PCPairReporter
extends JobReporter
implements PCPairReporterMBean {
    public static final int SCHEDINFO_QUEUE_SIZE = 5;
    public static DateTimeFormatter DATENTIME_FORMAT_EXACT = DateTimeFormat.forPattern((String)"EEE dd.MM.yyyy HH:mm:ss.SSS");
    private DateTime startup = new DateTime();
    private DateTime inboxLastLoad;
    private TelemetricsLongAbsoluter processingInboxtime = new TelemetricsLongAbsoluter();
    private TelemetricsLongAbsoluter idleTime = new TelemetricsLongAbsoluter();
    private int inboxSizeBeforeFillup = 0;
    private String lastAction;
    private String internalStatus;
    private String keySentToConsumer = "";
    private String lastInboxFillup = "";
    private long inboxloadStartTime = 0L;
    private long faults = 0L;
    private long consumerOverAllCancels = 0L;
    private long consumerThisRunCancels = 0L;
    private long consumerOverallSuccessful = 0L;
    private long consumerThisRunSuccessful = 0L;
    private long consumerOverallFaults = 0L;
    private long consumerThisRunFaults = 0L;
    private long consumerProcessingStartMillis = 0L;
    private String[] lastScheds = new String[5];
    private int nextSchedEntry = 0;

    public PCPairReporter(String pcPairName, JobProperties props) {
        super(pcPairName, -1, props);
    }

    @Override
    public long getoverall3_ConsumerItemsEx() {
        return this.consumerOverallFaults;
    }

    @Override
    public long getoverall2_ConsumerItemsCanceled() {
        return this.consumerOverAllCancels;
    }

    @Override
    public long getoverall1_ConsumerItemsOk() {
        return this.consumerOverallSuccessful;
    }

    @Override
    public String getbatchjob_ConnectionUrl() {
        return this.props.connectionInfo;
    }

    @Override
    public String getbatchjob_StartupTime() {
        return this.asExactDateTimeFormatOrEmpty(this.startup);
    }

    @Override
    public String getbatchjob_Version() {
        return this.props.swJobVersion;
    }

    @Override
    public String getbatchjob_Name() {
        return this.props.swJobFqName;
    }

    @Override
    public String getbatchjob_FrameworkVersion() {
        return this.props.mowareVersion;
    }

    @Override
    public String getinbox_LastLoad() {
        return this.asExactDateTimeFormatOrEmpty(this.inboxLastLoad);
    }

    @Override
    public long getinbox_AvgLoadDuration() {
        return this.processingInboxtime.getAverage();
    }

    @Override
    public long getinbox_MaxLoadDuration() {
        return this.processingInboxtime.getMax();
    }

    @Override
    public long getinbox_Fillups() {
        return this.processingInboxtime.getCount();
    }

    @Override
    public int getinbox_SizeBeforeFillup() {
        return this.inboxSizeBeforeFillup;
    }

    @Override
    public String getproducer1_InternalState() {
        return this.internalStatus;
    }

    @Override
    public long getproducer2_AvgIdleTime() {
        return this.idleTime.getAverage();
    }

    @Override
    public long getproducer3_MaxIdleTime() {
        return this.idleTime.getMax();
    }

    @Override
    public String getproducer4_LastAction() {
        return this.lastAction;
    }

    @Override
    public String getproducer5_LastKeySentToConsumer() {
        return this.keySentToConsumer;
    }

    @Override
    public String getproducer7_NextScheduledRuns() {
        Object st = "";
        int start = this.nextSchedEntry - 1;
        for (int i = 0; i < 5; ++i) {
            if (start < 0) {
                start = 4;
            }
            st = "".equals(st) ? (String)st + this.lastScheds[start] + " . . . . . . . . " : (String)st + this.lastScheds[start] + ", ";
            --start;
        }
        return st;
    }

    @Override
    public long getproducer8_AbortedInboxLoads() {
        return this.faults;
    }

    public void inboxLoadStart(int startInboxSize) {
        this.lastAction = "";
        if (this.consumerProcessingStartMillis != 0L) {
            this.reportConsumerWorkTotal();
        }
        this.consumerThisRunSuccessful = 0L;
        this.consumerThisRunCancels = 0L;
        this.consumerThisRunFaults = 0L;
        this.consumerProcessingStartMillis = System.currentTimeMillis();
        if (this.inboxloadStartTime != 0L) {
            ++this.faults;
        }
        this.inboxSizeBeforeFillup = startInboxSize;
        this.inboxloadStartTime = System.currentTimeMillis();
        this.logFrmwrkTrace("Inbox with " + startInboxSize + " items cleared, producer run started.");
    }

    @Override
    public String getinbox_LastFillup() {
        return this.lastInboxFillup;
    }

    public void inboxLoadStop(int curInboxSize, String action, boolean onlyProducerMode) {
        this.inboxLastLoad = new DateTime();
        long diff = System.currentTimeMillis() - this.inboxloadStartTime;
        this.processingInboxtime.addSample(diff);
        this.lastAction = action;
        this.inboxloadStartTime = 0L;
        if (curInboxSize > 0) {
            this.lastInboxFillup = "Producer run ended @ " + this.asExactDateTimeFormatOrEmpty(new DateTime()) + " with " + curInboxSize + " items.";
        }
        Object msg = "";
        if (action != null) {
            msg = (String)msg + action + " - ";
        }
        msg = (String)msg + "loaded " + curInboxSize + " items to inboxes in " + diff + "ms";
        if (onlyProducerMode) {
            msg = action + " - inbox " + curInboxSize + ", producer run " + diff + "ms (only producer present).";
        }
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, IOFXCoreReporter.LogPriority.INFO, (String)msg);
        info.addParameter("diff", diff);
        info.addParameter("count", curInboxSize);
        this.coreReporter.report(info);
        this.jmxLog(false, "INFO", (String)msg, null);
    }

    public void inboxLoadProblem(String msg) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, IOFXCoreReporter.LogPriority.ERROR, msg);
        this.coreReporter.report(info);
        this.jmxLog(false, "ERROR", msg, null);
    }

    public void reportConsumerWorkTotal() {
        long diffTime = System.currentTimeMillis() - this.consumerProcessingStartMillis;
        String msg = String.format("Loaded & Processed %d items ok, %d canceled and %d with ex in %dms", this.consumerThisRunSuccessful, this.consumerThisRunCancels, this.consumerThisRunFaults, diffTime);
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, IOFXCoreReporter.LogPriority.INFO, msg);
        info.addParameter("diff", diffTime);
        info.addParameter("count ok", this.consumerThisRunSuccessful);
        info.addParameter("count canceled", this.consumerThisRunCancels);
        info.addParameter("count ex", this.consumerThisRunFaults);
        this.coreReporter.report(info);
        this.jmxLog(false, "INFO", msg, null);
        this.consumerThisRunSuccessful = 0L;
        this.consumerThisRunCancels = 0L;
        this.consumerThisRunFaults = 0L;
        this.consumerProcessingStartMillis = 0L;
    }

    public void addIdleSample(long diff) {
        this.idleTime.addSample(diff);
    }

    public void sentKeyToConsumer(Object o) {
        this.keySentToConsumer = "" + o;
    }

    public void setInternalState(String state) {
        this.internalStatus = state;
    }

    public void addSchedEntry(DateTime entry) {
        this.lastScheds[this.nextSchedEntry] = DATENTIME_FORMAT_EXACT.print((ReadableInstant)entry);
        ++this.nextSchedEntry;
        if (this.nextSchedEntry >= 5) {
            this.nextSchedEntry = 0;
        }
    }

    public String asExactDateTimeFormatOrEmpty(DateTime dt) {
        if (dt == null) {
            return "";
        }
        return DATENTIME_FORMAT_EXACT.print((ReadableInstant)dt);
    }

    public void incConsumerCanceledProcessing() {
        ++this.consumerOverAllCancels;
        ++this.consumerThisRunCancels;
    }

    public void incConsumerOkProcessings() {
        ++this.consumerOverallSuccessful;
        ++this.consumerThisRunSuccessful;
    }

    public void incConsumerEx() {
        ++this.consumerOverallFaults;
        ++this.consumerThisRunFaults;
    }
}

