/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.ResultSetHelper;
import org.modellwerkstatt.objectflow.runtime.ResultSetHelperService;

public class CSVWriter
implements Closeable {
    public static final int INITIAL_STRING_SIZE = 128;
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    private ResultSetHelper resultService = new ResultSetHelperService();

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(List<String[]> allLines) {
        for (String[] line : allLines) {
            this.writeNext(line);
        }
    }

    protected void writeColumnNames(ResultSet rs) throws SQLException {
        this.writeNext(this.resultService.getColumnNames(rs));
    }

    public void writeAll(ResultSet rs, boolean includeColumnNames) throws SQLException, IOException {
        if (includeColumnNames) {
            this.writeColumnNames(rs);
        }
        while (rs.next()) {
            this.writeNext(this.resultService.getColumnValues(rs));
        }
    }

    public void writeNext(String[] nextLine) {
        if (nextLine == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i]) == null) continue;
            if (this.quotechar != '\u0000') {
                sb.append(this.quotechar);
            }
            sb.append(this.stringContainsSpecialCharacters(nextElement) ? this.processLine(nextElement) : nextElement);
            if (this.quotechar == '\u0000') continue;
            sb.append(this.quotechar);
        }
        sb.append(this.lineEnd);
        this.pw.write(sb.toString());
    }

    private boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1;
    }

    protected StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(128);
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            if (this.escapechar != '\u0000' && nextChar == this.quotechar) {
                sb.append(this.escapechar).append(nextChar);
                continue;
            }
            if (this.escapechar != '\u0000' && nextChar == this.escapechar) {
                sb.append(this.escapechar).append(nextChar);
                continue;
            }
            sb.append(nextChar);
        }
        return sb;
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.pw.close();
        this.rawWriter.close();
    }

    public boolean checkError() {
        return this.pw.checkError();
    }

    public void setResultService(ResultSetHelper resultService) {
        this.resultService = resultService;
    }

    public void newLine() {
        this.line("");
    }

    public void line(String s) {
        String[] myLine = new String[]{s};
        this.writeNext(myLine);
    }

    public void line(String s1, String s2) {
        String[] myLine = new String[]{s1, s2};
        this.writeNext(myLine);
    }

    public void line(String s1, String s2, String s3) {
        String[] myLine = new String[]{s1, s2, s3};
        this.writeNext(myLine);
    }

    public void line(String s1, String s2, String s3, String s4) {
        String[] myLine = new String[]{s1, s2, s3, s4};
        this.writeNext(myLine);
    }

    public void line(String s1, String s2, String s3, String s4, String s5) {
        String[] myLine = new String[]{s1, s2, s3, s4, s5};
        this.writeNext(myLine);
    }

    public void line(String s1, String s2, String s3, String s4, String s5, String s6) {
        String[] myLine = new String[]{s1, s2, s3, s4, s5, s6};
        this.writeNext(myLine);
    }

    public void line(int col, String s2) {
        String[] myLine = new String[col];
        for (int i = 0; i < col; ++i) {
            myLine[i] = "";
        }
        myLine[col - 1] = s2;
        this.writeNext(myLine);
    }
}

