/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.modellwerkstatt.manmap.runtime.MMJodaDateTimeTypeHandler;
import org.modellwerkstatt.manmap.runtime.MMShutdownRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class DeprecatedServerDateProvider {
    private static MMJodaDateTimeTypeHandler jodaDateTimeTypeHandler;
    private static IM3DatabaseDescription databaseDescription;
    private static JdbcTemplate template;
    public static DateTime fixedDateTime;
    private static long lastTimeMillisFromDB;
    private static long lastTimeMillisFromLocal;
    public static long REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL;

    @Autowired
    public DeprecatedServerDateProvider(JdbcTemplate tplt, MMJodaDateTimeTypeHandler time, IM3DatabaseDescription desc) {
        jodaDateTimeTypeHandler = time;
        databaseDescription = desc;
        template = tplt;
    }

    public static LocalDate getSqlServerLocalDate() {
        if (Thread.interrupted()) {
            throw new MMShutdownRequestException("getSqlServerLocalDate() - Thread.interrupted()=true, raising ShutDownRequest Exception.");
        }
        if (fixedDateTime != null) {
            return fixedDateTime.toLocalDate();
        }
        return new LocalDate(DeprecatedServerDateProvider.internalOrganizeMillis());
    }

    public static DateTime getSqlServerDateTime() {
        if (Thread.interrupted()) {
            throw new MMShutdownRequestException("getSqlServerDateTime() - Thread.interrupted()=true, raising ShutDownRequest Exception.");
        }
        if (fixedDateTime != null) {
            return fixedDateTime;
        }
        return new DateTime(DeprecatedServerDateProvider.internalOrganizeMillis());
    }

    public long getCurrentMillis() {
        return DeprecatedServerDateProvider.internalOrganizeMillis();
    }

    private static long internalOrganizeMillis() {
        long currentMillisLocal = System.currentTimeMillis();
        if (currentMillisLocal - lastTimeMillisFromLocal > REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL) {
            DateTime dtFromDb = (DateTime)template.query(databaseDescription.getTimeStampQuery(), new ResultSetExtractor(){

                public Object extractData(ResultSet p0) throws SQLException, DataAccessException {
                    p0.next();
                    return jodaDateTimeTypeHandler.getResult(p0, 1);
                }
            });
            lastTimeMillisFromDB = dtFromDb.getMillis();
            lastTimeMillisFromLocal = System.currentTimeMillis();
            return lastTimeMillisFromDB;
        }
        return lastTimeMillisFromDB + currentMillisLocal - lastTimeMillisFromLocal;
    }

    public static void fixServerDatetimeToConstant(DateTime dt) {
        fixedDateTime = dt;
    }

    public static void shutdownAndGcClean() {
        jodaDateTimeTypeHandler = null;
        databaseDescription = null;
        template = null;
    }

    static {
        template = null;
        fixedDateTime = null;
        lastTimeMillisFromDB = 0L;
        lastTimeMillisFromLocal = 0L;
        REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL = 10000L;
    }
}

