/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.math.BigDecimal;
import java.util.HashMap;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class MU {
    private static BigDecimal standardEps = new BigDecimal("0.5");
    public static final int INT_MAXVALUE = 999999999;

    public static void s(HashMap<String, String> map, String key, String value) {
        map.put(key, value);
    }

    public static BigDecimal sum(Iterable<BigDecimal> bigSeq) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal elem : Sequence.fromIterable(bigSeq)) {
            result = result.add(elem);
        }
        return result;
    }

    public static boolean testEqual(BigDecimal v1, BigDecimal v2, BigDecimal absEps, BigDecimal relEps) {
        if (v1.compareTo(v2) == 0) {
            return true;
        }
        BigDecimal r = v1.subtract(v2).abs();
        BigDecimal eps2 = v1.multiply(relEps).abs();
        return r.compareTo(absEps) < 0 || r.compareTo(eps2) < 0;
    }

    public static boolean testEqual(BigDecimal v1, BigDecimal v2, BigDecimal eps) {
        if (v1.compareTo(v2) == 0) {
            return true;
        }
        BigDecimal r = v1.subtract(v2).abs();
        return r.compareTo(eps) <= 0;
    }

    public static boolean testEqual(BigDecimal v1, BigDecimal v2) {
        return MU.testEqual(v1, v2, standardEps);
    }

    public static boolean testZero(BigDecimal v1, BigDecimal eps) {
        return MU.testEqual(v1, BigDecimal.ZERO, eps.abs());
    }

    public static boolean testZero(BigDecimal v1) {
        return MU.testEqual(v1, BigDecimal.ZERO, standardEps);
    }

    public static DateTime minDateTime(Iterable<DateTime> dateTimes) {
        if (dateTimes == null || Sequence.fromIterable(dateTimes).count() == 0) {
            return null;
        }
        DateTime minimum = (DateTime)Sequence.fromIterable(dateTimes).first();
        for (DateTime dateTime : Sequence.fromIterable(dateTimes)) {
            if (!dateTime.isBefore((ReadableInstant)minimum)) continue;
            minimum = dateTime;
        }
        return minimum;
    }

    public static DateTime maxDateTime(Iterable<DateTime> dateTimes) {
        if (dateTimes == null || Sequence.fromIterable(dateTimes).count() == 0) {
            return null;
        }
        DateTime maximum = (DateTime)Sequence.fromIterable(dateTimes).first();
        for (DateTime dateTime : Sequence.fromIterable(dateTimes)) {
            if (!dateTime.isAfter((ReadableInstant)maximum)) continue;
            maximum = dateTime;
        }
        return maximum;
    }
}

