/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.manmap.runtime.MMObjectKeyStore;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;

public class MoRevertibleMerger {
    public static <Key, Entity extends IOFXEntity<Key>> Entity mergeEntityIntoEntity(Class<Entity> classOfT, Entity source, Entity destination, IOFXSession __manMapSession, boolean readOnly) {
        if (source == null) {
            throw new IllegalStateException("Requested a merge with source entity of merge is null! A source entity has to be present.");
        }
        Object keyOfSource = source.getIM3Key();
        if (__manMapSession != null && MMStaticAccessHelper.isNullKeyStaticHelper((Object)keyOfSource)) {
            throw new IllegalStateException("The key of the source entity " + source + " is a null key, which can not be merged into a session");
        }
        IOFXEntity existingInSession = null;
        if (__manMapSession != null) {
            MMObjectKeyStore keyStore = __manMapSession.getOrCreateKeyStore(classOfT.hashCode());
            existingInSession = (IOFXEntity)keyStore.get(keyOfSource);
        }
        if (existingInSession != null && destination != null && existingInSession != destination) {
            throw new IllegalStateException("The destination entity to merge into '" + destination + "' is not the one in the session with key '" + keyOfSource + "' and can therefore not be merged. [legacy mode enbld?]");
        }
        if (destination != null && !MMStaticAccessHelper.isNullKeyStaticHelper((Object)destination.getIM3Key()) && !keyOfSource.equals(destination.getIM3Key())) {
            throw new IllegalStateException("The source entity with key '" + keyOfSource + "' can not be merged into given destination entity with key '" + destination.getIM3Key() + "'.");
        }
        if (destination == null) {
            destination = existingInSession;
        }
        if (destination == null) {
            try {
                destination = (IOFXEntity)classOfT.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            destination.setReadOnly(readOnly);
        }
        if (__manMapSession != null) {
            if (destination.getReadOnly() && !readOnly) {
                throw new IllegalStateException("Destination entity is readonly, but a checkout integration into session is requested.");
            }
            if (!destination.getReadOnly() && readOnly) {
                throw new IllegalStateException("Destination entity is checkedout, but a readonly integration into session is requested.");
            }
        }
        destination.load(source, false);
        if (__manMapSession != null) {
            __manMapSession.ensureInSession(destination);
        }
        return destination;
    }

    public static <Key, Entity extends IOFXEntity<Key>> Entity mergeEntityIntoList(Class<Entity> classOfT, Entity source, List<Entity> destList, IOFXSession __manMapSession, boolean readOnly) {
        IOFXEntity toReturn = null;
        Object keyOfSource = source.getIM3Key();
        if (__manMapSession != null && MMStaticAccessHelper.isNullKeyStaticHelper((Object)keyOfSource)) {
            throw new IllegalStateException("The key of the source entity " + source + " is a null key, which can not be merged into a session");
        }
        for (int i = 0; i < destList.size(); ++i) {
            IOFXEntity dest = (IOFXEntity)destList.get(i);
            if (!keyOfSource.equals(dest.getIM3Key())) continue;
            toReturn = MoRevertibleMerger.mergeEntityIntoEntity(classOfT, source, dest, __manMapSession, readOnly);
            break;
        }
        if (toReturn == null) {
            try {
                toReturn = (IOFXEntity)classOfT.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            toReturn.setReadOnly(readOnly);
            toReturn.load(source, false);
            if (__manMapSession != null) {
                __manMapSession.ensureInSession(toReturn);
            }
            destList.add(toReturn);
        }
        return (Entity)toReturn;
    }

    public static <Key, Entity extends IOFXEntity<Key>> List<Entity> mergeListIntoList(Class<Entity> classOfT, List<Entity> source, List<Entity> destList, IOFXSession __manMapSession, boolean readOnly) {
        IListSequence toReturn = ListSequence.fromList(new ArrayList());
        for (IOFXEntity objToMerge : source) {
            ListSequence.fromList((List)toReturn).addElement((Object)MoRevertibleMerger.mergeEntityIntoList(classOfT, objToMerge, destList, __manMapSession, readOnly));
        }
        return toReturn;
    }

    public static <Key, Entity extends IOFXEntity<Key>> Entity mergeRefOnRef(Class<Entity> classOfT, Entity sourceRef, IOFXSession __manMapSession, boolean readOnly, RefChange change, IOFXEntity destEntity) {
        if (sourceRef == null) {
            change.doChange(destEntity, null);
            return null;
        }
        Entity newRef = MoRevertibleMerger.mergeEntityIntoEntity(classOfT, sourceRef, null, __manMapSession, readOnly);
        change.doChange(destEntity, newRef);
        return newRef;
    }

    public static interface RefChange<E, R> {
        public void doChange(E var1, R var2);
    }
}

