/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXSelcrtlBasics;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXCommand;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class OFXCmdModule
implements IOFXCmdModule {
    @Autowired
    protected IOFXApplicationFactory appFactory;
    protected IOFXCmdModule.CmdDefaults[] defaults;
    protected IOFXCmdModule.CmdUrlDefaults[] urlDefaults;

    @Override
    public IOFXCmdModule.CmdUrlDefaults[] getCmdUrlDefaults() {
        return this.urlDefaults;
    }

    @Override
    public Object[] getCommandDefaultParams(String commandFqName, IOFXSelcrtlBasics crtl, Object singleSelToReplaceWhenMulti) {
        for (IOFXCmdModule.CmdDefaults def : this.defaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            return def.params.calc(crtl, singleSelToReplaceWhenMulti);
        }
        throw new RuntimeException("This can not happen. Command " + commandFqName + " is not known.");
    }

    @Override
    public Object[] getCommandUrlDefaultParams(String commandFqName, OFXUrlParams params) {
        for (IOFXCmdModule.CmdUrlDefaults def : this.urlDefaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            return def.params.calc(params);
        }
        throw new RuntimeException("This can not happen. Command " + commandFqName + " is not known.");
    }

    @Override
    public boolean supportUrlDefaultParams(String commandFqName) {
        for (IOFXCmdModule.CmdUrlDefaults def : this.urlDefaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCommandType(String commandFqName, IOFXCommand.OFXCmdTyp ... commandType) {
        IOFXCommand.OFXCmdTyp commandFQNameType = null;
        for (IOFXCmdModule.CmdDefaults cmdDefaults : this.defaults) {
            if (!cmdDefaults.cmdFqName.equals(commandFqName)) continue;
            commandFQNameType = cmdDefaults.type;
            break;
        }
        if (commandFQNameType == null) {
            throw new RuntimeException("This can not happen. Type of command " + commandFqName + " is not known / command not known?");
        }
        for (IOFXCommand.OFXCmdTyp oFXCmdTyp : commandType) {
            if (!oFXCmdTyp.equals((Object)commandFQNameType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCommandToolTip(String commandFqName) {
        for (IOFXCmdModule.CmdDefaults def : this.defaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            return def.tooltip;
        }
        throw new RuntimeException("This can not happen. Command " + commandFqName + " is not known.");
    }

    @Override
    public String getCommandDefaultColor(String commandFqName) {
        for (IOFXCmdModule.CmdDefaults def : this.defaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            return def.color;
        }
        throw new RuntimeException("This can not happen. Command " + commandFqName + " is not known.");
    }

    @Override
    public String getCommandDefaultLabel(String commandFqName) {
        for (IOFXCmdModule.CmdDefaults def : this.defaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            return def.label;
        }
        throw new RuntimeException("This can not happen. Command " + commandFqName + " is not known.");
    }

    @Override
    public String getCommandDefaultIcon(String commandFqName) {
        for (IOFXCmdModule.CmdDefaults def : this.defaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            return def.icon;
        }
        throw new RuntimeException("This can not happen. Command " + commandFqName + " is not known.");
    }

    @Override
    public String getCommandDefaultHotkey(String commandFqName) {
        for (IOFXCmdModule.CmdDefaults def : this.defaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            return def.hotkey;
        }
        throw new RuntimeException("This can not happen. Command " + commandFqName + " is not known.");
    }

    @Override
    public IOFXCommand startCommand(IOFXCmdModule.CmdExecStrategy stragey, String commandFqName, Object[] args, IOFXSession parentSession, IOFXUserEnvironment userEnvironment, IOFXUserServices usrService) {
        IOFXCmdModule.CommandPermission permission;
        IOFXCmdModule.CmdDefaults cmdDefaults = null;
        for (IOFXCmdModule.CmdDefaults def : this.defaults) {
            if (!def.cmdFqName.equals(commandFqName)) continue;
            cmdDefaults = def;
            break;
        }
        if (cmdDefaults == null) {
            throw new RuntimeException("This can not happen. Type of command " + commandFqName + " is not known / command not known?");
        }
        boolean isSessionOwner = OFXCommand.isSessionOwner(cmdDefaults.type);
        IOFXCommand cmd = null;
        IOFXSession session = parentSession;
        if (isSessionOwner) {
            if (stragey == IOFXCmdModule.CmdExecStrategy.INNER_NO_NEW_SESSION) {
                if (session == null) {
                    throw new RuntimeException("No session provided for " + commandFqName + ". Maybe cmd type GRPAH_OWNER / EDIT / SEARCH not correct.");
                }
                session.setSharedSession();
                session.setSessionOwnerFqName(session.getCurrentCmdName() + ":" + MoVersion.getCapitalizedShortNameFromFQ(commandFqName));
            } else {
                session = this.appFactory.createNewSession(userEnvironment, usrService);
                session.setSessionOwnerFqName(commandFqName);
                if (session.getUserEnvironment() == null) {
                    throw new RuntimeException("Session without UserEnvironment can not be run.");
                }
            }
        }
        if ((permission = this.getCommandPermission(stragey, commandFqName, args, session)) == IOFXCmdModule.CommandPermission.DISABLED) {
            throw new RuntimeException("Command " + commandFqName + " can not be started. Enabled condition of command not fulfilled.");
        }
        if (isSessionOwner && permission == IOFXCmdModule.CommandPermission.ENABLED_RO) {
            session.setReadOnly();
        }
        cmd = this.appFactory.createNewCommand(cmdDefaults.theClass);
        if (!isSessionOwner) {
            if (session != null) {
                session.setGraphEditFqName(commandFqName);
            } else {
                throw new RuntimeException("Command " + commandFqName + " ist not a session owner, but parent session is null! (GE used?)");
            }
        }
        cmd.setCommandParams(session, args);
        return cmd;
    }
}

