/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.ArrayList;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXPage;
import org.modellwerkstatt.objectflow.runtime.IOFXSelProvider;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXChangePageException;
import org.modellwerkstatt.objectflow.runtime.OFXCommandDoneException;
import org.modellwerkstatt.objectflow.runtime.OFXCommandPageConclusion;
import org.modellwerkstatt.objectflow.runtime.OFXJobWorkCanceledException;

public abstract class OFXCommandPage<Bound>
implements IOFXPage<Bound> {
    protected String pageName;
    protected IOFXSelProvider<Bound> __selectionProvider;
    protected IOFXPage.IOFXPageConclusion[] conclusions;
    protected int conclusionsAdded = 0;

    public OFXCommandPage(String name, int size) {
        this.pageName = name;
        this.conclusions = new IOFXPage.IOFXPageConclusion[size];
    }

    public void conclusion(OFXCommandPageConclusion conc) {
        this.conclusions[this.conclusionsAdded] = conc;
        ++this.conclusionsAdded;
    }

    public abstract void initGenPageConclusion();

    public abstract Object pageLoadFunction() throws Exception;

    @Override
    public List<Bound> initPage(IOFXSelProvider<Bound> selRecorder) throws Exception {
        this.__selectionProvider = selRecorder;
        Object listOrObject = this.pageLoadFunction();
        if (listOrObject == null) {
            throw new RuntimeException("This can not happen. Pageload of " + this.pageName + " return null.");
        }
        if (listOrObject instanceof List) {
            return (List)listOrObject;
        }
        ArrayList<Object> createdList = new ArrayList<Object>(1);
        createdList.add(listOrObject);
        return createdList;
    }

    @Override
    public void execPageConclusion(IOFXPage.IOFXPageConclusion conclusion) throws OFXChangePageException, OFXJobWorkCanceledException, OFXCommandDoneException, OFXAbortedException, Exception {
        IOFXPage.IOFXPageConclusion concToExec = null;
        for (IOFXPage.IOFXPageConclusion candidate : this.conclusions) {
            if (candidate != conclusion) continue;
            concToExec = candidate;
            break;
        }
        if (concToExec == null) {
            throw new IllegalStateException(conclusion + " is not a conclusion of this page " + this.pageName);
        }
        conclusion.execute();
    }

    @Override
    public IOFXPage.IOFXPageConclusion[] getPageConclusions(IOFXSelProvider<Bound> finalView) {
        this.__selectionProvider = finalView;
        return this.conclusions;
    }

    @Override
    public void cmdTerminated(boolean wasChild, boolean inFinalOk, IOFXSelProvider<Bound> __selectionProvider) {
    }

    @Override
    public void cmdTerminatedWithPushed(boolean wasChild, boolean inFinalOk, Object pushed, IOFXSelProvider<Bound> __selectionProvider) {
    }

    public String dynamicPageTitle() {
        return "";
    }

    @Override
    public String calcDynamicPageTitleAndScopes() {
        this.calcScopes();
        return this.dynamicPageTitle();
    }

    @Override
    public String getPageName() {
        return this.pageName;
    }

    public String toString() {
        return super.toString();
    }
}

