/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.manmap.runtime.IM3UserEnvironment;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.FoBc4jBarCode;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;

public class OFXFatClientFopUserPrintService
implements IPrintingServiceImpl {
    public static final DateTimeFormatter dateTimeFormatter = MoWareFormattersFactory.forDateTimePattern("dd.MM.yyyy hh:mm:ss", "de");
    protected static TransformerFactory transFactory;
    protected static FopFactory fopFactory;
    protected boolean useMoFopland;
    protected boolean useTmpDir;
    protected Class<?> classloaderForXslt;
    protected String fallBackFsDirForXslt;
    protected String outputFileDir;
    protected IOFXUserEnvironment userEnvironment;
    private boolean autodetectFonts;

    public OFXFatClientFopUserPrintService(IOFXUserEnvironment userEnv, String classLoadForXslTemplates, String fallBackFsDirForXsltTemplate, String outputPath, boolean useFopland, boolean useTmpDirectory, boolean autodetect) {
        this.userEnvironment = userEnv;
        this.fallBackFsDirForXslt = fallBackFsDirForXsltTemplate;
        this.useMoFopland = useFopland;
        this.useTmpDir = useTmpDirectory;
        this.outputFileDir = outputPath;
        this.autodetectFonts = autodetect;
        try {
            this.classloaderForXslt = Class.forName(classLoadForXslTemplates);
        }
        catch (ClassNotFoundException e) {
            classLoadForXslTemplates = null;
        }
    }

    @Override
    public void gcClean() {
        this.classloaderForXslt = null;
        this.userEnvironment = null;
    }

    public void selfconfigureFopFactory(String fontPath) {
        try {
            StringBuilder configString = new StringBuilder();
            configString.append("<fop version=\"2.1\">");
            configString.append("<strict-configuration>true</strict-configuration>");
            configString.append("<strict-validation>true</strict-validation>");
            configString.append("<renderers>");
            configString.append("<renderer mime=\"application/pdf\">");
            configString.append("<fonts>");
            configString.append("<directory>" + fontPath + "</directory>");
            if (this.autodetectFonts) {
                configString.append("<auto-detect/>");
            }
            configString.append("<substitutions>");
            configString.append("<substitution>");
            configString.append("<from font-family=\"Arial\" />");
            configString.append("<to font-family=\"Helvetica\"/>");
            configString.append("<from font-family=\"Consolas\" />");
            configString.append("<to font-family=\"Courier\"/>");
            configString.append("</substitution>");
            configString.append("</substitutions>");
            configString.append("</fonts>");
            configString.append("</renderer>");
            configString.append("</renderers>");
            configString.append("</fop>");
            if (fopFactory == null) {
                DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
                DefaultConfiguration cfg = cfgBuilder.build((InputStream)new ByteArrayInputStream(configString.toString().getBytes()));
                FopFactoryBuilder factoryBuilder = new FopFactoryBuilder(new File(".").toURI()).setConfiguration((Configuration)cfg);
                fopFactory = factoryBuilder.build();
            }
            if (transFactory == null) {
                transFactory = TransformerFactory.newInstance();
            }
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException("Exception while initializing printing utility: ", ex);
        }
    }

    private static String adjustXmlData(String origXml, IM3UserEnvironment environment) {
        Object heading = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<OBJECT>";
        String timestring = dateTimeFormatter.print((ReadableInstant)DeprecatedServerDateProvider.getSqlServerDateTime());
        String userString = environment.getUserName();
        heading = (String)heading + "<__TIMESTAMP>" + timestring + "</__TIMESTAMP>";
        heading = (String)heading + "<__USER>" + userString + "</__USER>";
        return (String)heading + origXml + "</OBJECT>";
    }

    public String adjustXsltForFopland(BufferedReader reader) throws IOException {
        String line;
        StringBuilder content = new StringBuilder();
        boolean firstLine = true;
        while ((line = reader.readLine()) != null) {
            if (firstLine) {
                if (!line.contains("<?xml")) {
                    content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                firstLine = false;
            }
            content.append(line);
        }
        reader.close();
        String xsltData = content.toString();
        xsltData = xsltData.replaceAll("&amp;#xA0;", "&#xA0;");
        return xsltData;
    }

    private String getBarcode4JPath(String xslt) {
        int lenBid;
        int startIndex = xslt.indexOf("BARCODE4J");
        if (xslt.charAt(startIndex + (lenBid = "BARCODE4J".length())) != '(') {
            throw new RuntimeException("OFXFopUserPrintService barcode 4j substitution: When using BARCODE4J and no java Barcode-Class ist specified, use BARCODE4J(<<path>>) in template. ( missing");
        }
        int stop = xslt.indexOf(")", startIndex + lenBid + 1);
        if (stop < 0) {
            throw new RuntimeException("OFXFopUserPrintService barcode 4j substitution: When using BARCODE4J and no java Barcode-Class ist specified, use BARCODE4J(<<path>>) in template. ) missing");
        }
        return xslt.substring(startIndex + lenBid + 1, stop);
    }

    public String adjustXsltForDesigner(BufferedReader reader, FoBc4jBarCode barcode) throws IOException {
        String line;
        StringBuilder content = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            line = line.replace("display-align=\"middle\"", "display-align=\"center\"");
            line = line.replace("is-html=\"true\"", "");
            content.append(line);
        }
        reader.close();
        String xsltData = content.toString();
        if (barcode != null) {
            xsltData = xsltData.replace("BARCODE4J", barcode.toString());
        } else if (xsltData.contains("BARCODE4J")) {
            String path = this.getBarcode4JPath(xsltData);
            barcode = new FoBc4jBarCode(path);
            xsltData = xsltData.replace("BARCODE4J(" + path + ")", barcode.toString());
        }
        return xsltData;
    }

    public File renderFop(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode, boolean tempDir) {
        try {
            InputStream xsltSream;
            xmlGraphData = OFXFatClientFopUserPrintService.adjustXmlData(xmlGraphData, this.userEnvironment);
            BufferedReader reader = null;
            if (this.classloaderForXslt != null && (xsltSream = this.classloaderForXslt.getResourceAsStream(xsltTemplateName)) != null) {
                reader = new BufferedReader(new InputStreamReader(xsltSream, "UTF-8"));
            }
            if (reader == null) {
                reader = new BufferedReader(new FileReader(new File(this.fallBackFsDirForXslt + "/" + xsltTemplateName)));
            }
            String xsltData = this.useMoFopland ? this.adjustXsltForFopland(reader) : this.adjustXsltForDesigner(reader, (FoBc4jBarCode)barcode);
            String[] fileNameWithEnding = documentFilename.split("\\.");
            if (fileNameWithEnding.length != 2) {
                throw new RuntimeException("Provide a <filname>.<ending> when rendering (<filename>.pdf ?). You provided '" + documentFilename + "'");
            }
            File resultingFile = tempDir ? File.createTempFile(fileNameWithEnding[0], "." + fileNameWithEnding[1]) : new File(this.outputFileDir + "/" + documentFilename);
            FileOutputStream pdfOutputStream = new FileOutputStream(resultingFile);
            StreamSource xsltStreamSource = new StreamSource(new StringReader(xsltData));
            Fop fop = fopFactory.newFop("application/pdf", (OutputStream)pdfOutputStream);
            Transformer transformer = transFactory.newTransformer(xsltStreamSource);
            StreamSource xmlGraphDataStreamSource = new StreamSource(new StringReader(xmlGraphData));
            SAXResult result = new SAXResult(fop.getDefaultHandler());
            transformer.transform(xmlGraphDataStreamSource, result);
            ((OutputStream)pdfOutputStream).close();
            transformer = null;
            fop = null;
            return resultingFile;
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (FOPException fop) {
            throw new RuntimeException(fop);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public File render(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        File resultingFile = this.renderFop(documentFilename, xsltTemplateName, xmlGraphData, barcode, this.useTmpDir);
        return resultingFile;
    }

    @Override
    public File renderPrint(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        File resultingFile = this.renderFop(documentFilename, xsltTemplateName, xmlGraphData, barcode, this.useTmpDir);
        this.print(resultingFile);
        return resultingFile;
    }

    @Override
    public File renderView(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        File resultingFile = this.renderFop(documentFilename, xsltTemplateName, xmlGraphData, barcode, this.useTmpDir);
        this.view(resultingFile);
        return resultingFile;
    }

    @Override
    public void view(File pdfFile) {
        try {
            Desktop.getDesktop().browse(pdfFile.toURI());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void print(File pdfFile) {
        try {
            Desktop.getDesktop().print(pdfFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void openUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String dpocumentFilename = "doc.pdf";
        String[] fileNameWithEnding = dpocumentFilename.split("\\.");
        if (fileNameWithEnding.length != 2) {
            throw new RuntimeException("Provide a <filname>.<ending> when rendering (<filename>.pdf ?). You provided '" + dpocumentFilename + "'");
        }
        System.err.println("'" + fileNameWithEnding[0] + "." + fileNameWithEnding[1] + "'");
    }
}

