/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import org.modellwerkstatt.objectflow.runtime.IOFXPrintFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.objectflow.runtime.OFXFatClientFopUserPrintService;

public class OFXFatClientPrintFactory
implements IOFXPrintFactory {
    private static final String WINDOWS_FONT_PATH = "C:/windows/fonts";
    protected IPrintingServiceImpl printService;
    protected String templateClassLoaderFqName;
    protected String fallBackFileSystemTemplateLoadingPath;
    protected String printerOutputPath;
    protected boolean useTmpOutputDir;
    protected boolean useFoplandModfier;
    protected String fontPath;
    protected boolean autodetectFont;

    public OFXFatClientPrintFactory(String templateClassLoaderFqName, String fallBackFileSystemTemplateLoadingPath, String printerOutputPath, boolean useFoplandModifier) {
        this.templateClassLoaderFqName = templateClassLoaderFqName.trim();
        this.fallBackFileSystemTemplateLoadingPath = fallBackFileSystemTemplateLoadingPath.trim();
        this.printerOutputPath = printerOutputPath.trim();
        this.useFoplandModfier = useFoplandModifier;
        this.fontPath = WINDOWS_FONT_PATH;
        this.autodetectFont = true;
        this.useTmpOutputDir = false;
        if ("".equals(this.printerOutputPath)) {
            this.useTmpOutputDir = true;
        }
    }

    public OFXFatClientPrintFactory(String templateClassLoaderFqName, String fallBackFileSystemTemplateLoadingPath, String printerOutputPath, boolean useFoplandModifier, String fontPath) {
        this(templateClassLoaderFqName, fallBackFileSystemTemplateLoadingPath, printerOutputPath, useFoplandModifier);
        this.fontPath = fontPath.trim();
        if ("0".equals(this.fontPath) || "1".equals(this.fontPath) || "".equals(this.fontPath)) {
            this.fontPath = WINDOWS_FONT_PATH;
        }
    }

    public OFXFatClientPrintFactory(String templateClassLoaderFqName, String fallBackFileSystemTemplateLoadingPath, String printerOutputPath, boolean useFoplandModifier, String fontPath, boolean autodetect) {
        this(templateClassLoaderFqName, fallBackFileSystemTemplateLoadingPath, printerOutputPath, useFoplandModifier, fontPath);
        this.autodetectFont = autodetect;
    }

    public void createInitialService(IOFXUserEnvironment ev) {
        this.printService = new OFXFatClientFopUserPrintService(ev, this.templateClassLoaderFqName, this.fallBackFileSystemTemplateLoadingPath, this.printerOutputPath, this.useFoplandModfier, this.useTmpOutputDir, this.autodetectFont);
        ((OFXFatClientFopUserPrintService)this.printService).selfconfigureFopFactory(this.fontPath);
    }

    @Override
    public IPrintingServiceImpl createConfiguredUserPrintService(Object tecHandle, IOFXUserEnvironment dummy) {
        if (this.printService == null) {
            this.createInitialService(dummy);
        }
        return this.printService;
    }

    @Override
    public void gcClean() {
        this.printService.gcClean();
        this.printService = null;
    }
}

