/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaBasis;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableAttribute;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;

public class OFXList<T extends IOFXRevertableObject>
implements IOFXMetaBasis,
IOFXRevertableAttribute<OFXList<T>> {
    private boolean enabled = true;
    private boolean optional = false;
    private String label;
    private int hashAfterSet = 0;
    private List<T> currentList = new ArrayList<T>();
    private List<T> originalReferences = null;
    private Boolean requestFocus;
    private String validationErrorText;

    protected boolean needCopy() {
        if (this.currentList != null && this.currentList.size() >= 1 && this.currentList.get(0) instanceof IOFXEntity) {
            for (int i = 0; i < this.currentList.size(); ++i) {
                if (((IOFXEntity)this.currentList.get(i)).getReadOnly()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enbl) {
        this.enabled = enbl;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setOptional(boolean opt) {
        this.optional = opt;
    }

    @Override
    public boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setLabel(String lbl) {
        this.label = lbl;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean setValue(List<T> val) {
        if (val != null && ListSequence.fromList(val).count() > 0 && this.hashAfterSet == 0) {
            this.hashAfterSet = this.currentList != null && this.currentList.size() > 0 && this.hashOfList(this.currentList) != this.hashOfList(val) ? -1 : this.hashOfList(val);
        }
        this.currentList = val;
        return false;
    }

    public List<T> getValue() {
        return this.currentList;
    }

    public int hashOfList(List<T> list) {
        int newHash = 0;
        if (list != null) {
            for (IOFXRevertableObject elm : list) {
                newHash += elm.hashCode();
            }
        }
        return newHash;
    }

    public boolean wasListChanged() {
        boolean same = this.hashAfterSet == this.hashOfList(this.currentList);
        return !same;
    }

    public void setHashForDirtyChecking() {
        this.hashAfterSet = this.hashOfList(this.currentList);
    }

    @Override
    public OFXList copy() {
        OFXList<T> newOfxList = new OFXList<T>();
        newOfxList.enabled = this.enabled;
        newOfxList.optional = this.optional;
        newOfxList.label = this.label;
        newOfxList.hashAfterSet = this.hashAfterSet;
        if (this.needCopy()) {
            newOfxList.currentList = new ArrayList<T>();
            for (int i = 0; i < this.currentList.size(); ++i) {
                newOfxList.currentList.add(((IOFXRevertableObject)this.currentList.get(i)).copy());
            }
            newOfxList.originalReferences = new ArrayList<T>();
            newOfxList.originalReferences.addAll(this.currentList);
        } else if (this.currentList == null) {
            newOfxList.currentList = null;
        } else {
            newOfxList.currentList = new ArrayList<T>();
            newOfxList.currentList.addAll(this.currentList);
        }
        return newOfxList;
    }

    @Override
    public void load(OFXList<T> cp, boolean fullRevertNotMerge) {
        if (fullRevertNotMerge) {
            this.enabled = cp.enabled;
            this.optional = cp.optional;
            this.label = cp.label;
            this.hashAfterSet = cp.hashAfterSet;
            if (cp.currentList == null) {
                this.currentList = null;
            } else if (cp.originalReferences == null) {
                this.currentList.clear();
                this.currentList.addAll(cp.currentList);
            } else {
                this.currentList.clear();
                this.currentList.addAll(cp.originalReferences);
                for (int i = 0; i < this.currentList.size(); ++i) {
                    ((IOFXRevertableObject)this.currentList.get(i)).load((IOFXRevertableObject)cp.currentList.get(i), fullRevertNotMerge);
                }
            }
        } else if (this.currentList != null) {
            this.currentList.clear();
        }
    }

    @Override
    public void requestFocus() {
        this.requestFocus = new Boolean(true);
    }

    @Override
    public boolean getFocusAndClearIt() {
        if (this.requestFocus != null && this.requestFocus.equals(true)) {
            this.requestFocus = null;
            return true;
        }
        this.requestFocus = null;
        return false;
    }

    @Override
    public void setValidationError(String val) {
        this.validationErrorText = val;
    }

    @Override
    public String getValidationError() {
        return this.validationErrorText;
    }
}

