/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;

public class OFXProblem
implements IOFXProblem {
    private String problemDesc;
    private String instanceDesc;
    private Throwable forwarded;
    private boolean wasGuard;
    private IOFXProblem.Opt[] options;
    private HashMap<String, Object> propertiesMap;
    private IOFXSession.IUxEventActionable basisCmdStart;

    public OFXProblem(String problem, String instance, HashMap<String, Object> paramMap, IOFXProblem.Opt ... opts) {
        this.problemDesc = problem;
        this.instanceDesc = instance;
        this.options = opts;
        this.wasGuard = false;
        this.propertiesMap = paramMap;
    }

    public OFXProblem(IOFXSession.IUxEventActionable cmdStart, String problem, String instance, HashMap<String, Object> paramMap, IOFXProblem.Opt ... opts) {
        this.problemDesc = problem;
        this.instanceDesc = instance;
        this.options = opts;
        this.wasGuard = false;
        this.basisCmdStart = cmdStart;
        this.propertiesMap = paramMap;
    }

    public OFXProblem(boolean fromGuard, String problem, String instance, Throwable forwardedFromGuard) {
        this(problem, instance, null, new IOFXProblem.Opt[0]);
        this.forwarded = forwardedFromGuard;
        this.wasGuard = fromGuard;
    }

    @Override
    public HashMap<String, Object> getPropMapOrNull() {
        return this.propertiesMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getProblemDescOrNull() != null) {
            sb.append(this.getProblemDescOrNull() + ". ");
        }
        if (this.getInstanceDescOrNull() != null) {
            sb.append(this.getInstanceDescOrNull() + ". ");
        }
        if (this.hasForwardedEx()) {
            sb.append(this.getForwardedEx().getClass().getName() + ": " + this.getForwardedEx().getMessage());
        }
        if (this.isWarningOnly()) {
            sb.append(" (warning)");
        }
        return sb.toString();
    }

    @Override
    public String getProblemDescOrNull() {
        return this.problemDesc;
    }

    @Override
    public String getInstanceDescOrNull() {
        return this.instanceDesc;
    }

    @Override
    public boolean hasForwardedEx() {
        return this.forwarded != null;
    }

    @Override
    public Throwable getForwardedEx() {
        return this.forwarded;
    }

    @Override
    public boolean isFromGuard() {
        return this.wasGuard;
    }

    @Override
    public boolean isWarningOnly() {
        return this.hasOption(IOFXProblem.Opt.WARNING_HINT);
    }

    @Override
    public boolean isJobIgnore() {
        return this.hasOption(IOFXProblem.Opt.JOB_IGNORE);
    }

    @Override
    public boolean isJobItemAlreadDone() {
        return this.hasOption(IOFXProblem.Opt.JOB_ITEM_ALREAD_DONE);
    }

    public boolean noPrioOptionGiven() {
        if (this.options != null) {
            for (IOFXProblem.Opt opt : this.options) {
                if (!opt.equals((Object)IOFXProblem.Opt.PRIO_FATAL) && !opt.equals((Object)IOFXProblem.Opt.PRIO_ERROR) && !opt.equals((Object)IOFXProblem.Opt.PRIO_INFO)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isPrioInfo() {
        if (this.hasOption(IOFXProblem.Opt.PRIO_INFO)) {
            return true;
        }
        return this.isWarningOnly() && this.noPrioOptionGiven();
    }

    @Override
    public boolean isPrioError() {
        if (this.hasOption(IOFXProblem.Opt.PRIO_ERROR)) {
            return true;
        }
        return !this.isWarningOnly() && this.noPrioOptionGiven();
    }

    @Override
    public boolean isPrioFatal() {
        return this.hasOption(IOFXProblem.Opt.PRIO_FATAL);
    }

    @Override
    public IOFXCoreReporter.LogPriority translatedLogPrio() {
        if (this.isPrioInfo()) {
            return IOFXCoreReporter.LogPriority.INFO;
        }
        if (this.isPrioError()) {
            return IOFXCoreReporter.LogPriority.ERROR;
        }
        return IOFXCoreReporter.LogPriority.FATAL;
    }

    @Override
    public String getSimpleUserText() {
        Object msg = this.getProblemDescOrNull();
        if (this.getForwardedEx() != null) {
            msg = msg == null ? this.getForwardedEx().getClass().getName() + ": " + this.getForwardedEx().getMessage() : (String)msg + " [" + this.getForwardedEx().getClass().getName() + ": " + this.getForwardedEx().getMessage() + "]";
        } else if (msg == null) {
            msg = "[?]";
        }
        return msg;
    }

    public boolean hasOption(IOFXProblem.Opt lookingFor) {
        if (this.options != null) {
            for (IOFXProblem.Opt opt : this.options) {
                if (!opt.equals((Object)lookingFor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IOFXSession.IUxEventActionable getResolveActionOrNull() {
        return this.basisCmdStart;
    }
}

