/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.OFXSimpleManMapSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class OFXSimpleAppFactory
implements IOFXApplicationFactory {
    @Autowired
    protected ApplicationContext context;
    @Autowired
    protected DataSource dataSource;
    @Autowired
    protected IOFXPlatform platform;
    private String connectionInfo;
    private boolean mowareTrace = false;
    protected boolean alwaysRollbackSession = false;

    @Override
    public IOFXPlatform getPlatform() {
        return this.platform;
    }

    public void setMowareTrace(boolean val) {
        this.mowareTrace = val;
    }

    public boolean getMowareTrace() {
        return this.mowareTrace;
    }

    public void setPortJ(boolean val) {
        if (val) {
            OFXLogger.enablePortJ();
        }
    }

    public boolean getPortJ() {
        return OFXLogger.isEnabledPortJ();
    }

    public void setPortJLocal(boolean val) {
        this.setPortJ(val);
    }

    public boolean getPortJLocal() {
        return this.getPortJ();
    }

    public boolean getAlwaysRollbackSession() {
        return this.alwaysRollbackSession;
    }

    public void setAlwaysRollbackSession(boolean val) {
        this.alwaysRollbackSession = val;
    }

    @Override
    public IOFXCmdModule getModuleByInstanceName(String fqName) {
        return (IOFXCmdModule)this.context.getBean(fqName);
    }

    @Override
    public Object getNewClassInstanceByFQName(String fqName) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> bean = cl.loadClass(fqName);
            Object instance = this.context.getAutowireCapableBeanFactory().createBean(bean);
            return instance;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Class '" + fqName + "' not found!", cnfe);
        }
    }

    @Override
    public IOFXSession createNewSession(IOFXUserEnvironment userEnv, IOFXUserServices usrServ) {
        if (userEnv == null || usrServ == null) {
            throw new RuntimeException("This can not happen " + userEnv + " / " + usrServ + " - none should be null.");
        }
        OFXSimpleManMapSession session = (OFXSimpleManMapSession)this.context.getAutowireCapableBeanFactory().createBean(OFXSimpleManMapSession.class);
        session.initSession(userEnv, usrServ, this.alwaysRollbackSession);
        return session;
    }

    @Override
    public IOFXCommand createNewCommand(Class commandClass) {
        return (IOFXCommand)this.context.getAutowireCapableBeanFactory().createBean(commandClass);
    }

    @Override
    public void report(CoreReporterInfo cri) {
        if (cri.getMsgType() != IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE || this.mowareTrace) {
            if (this.getPortJ()) {
                if (this.sendToPortJ(cri)) {
                    OFXLogger.logCoreInfoToJOrConsole(cri);
                }
            } else {
                OFXLogger.logCoreInfoToJOrConsole(cri);
            }
        }
    }

    @Override
    public String getConnectionUrl() {
        if (this.connectionInfo == null) {
            try {
                this.connectionInfo = this.dataSource.getConnection().getMetaData().getURL();
            }
            catch (SQLException e) {
                this.connectionInfo = "(not available due to SQLException)";
            }
        }
        return this.connectionInfo;
    }
}

