/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.manmap.runtime.IM3Entity;
import org.modellwerkstatt.manmap.runtime.IM3UserEnvironment;
import org.modellwerkstatt.manmap.runtime.MMAdditionalInfoException;
import org.modellwerkstatt.manmap.runtime.MMSession;
import org.modellwerkstatt.manmap.runtime.MMShutdownRequestException;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXSessionOperation;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class OFXSimpleManMapSession
extends MMSession
implements IOFXSession {
    private PlatformTransactionManager transactionManager;
    private DefaultTransactionDefinition transactionDefinition;
    private boolean isShared = false;
    private boolean alwaysRollbackSession = false;
    private volatile boolean isLocked = false;
    private String lockedByUser = null;
    private boolean immediateTransactionExecuted = false;
    private DateTime lastTransactionStart = null;
    private List<IOFXSessionOperation> okOperations = ListSequence.fromList(new ArrayList());
    private IOFXSessionOperation postTransactionOperation;
    private List<IOFXProblem> sessionProblems = ListSequence.fromList(new ArrayList());
    private String sessionOwnerFqName;
    private String graphEditFqName;
    private IOFXSession.IUxEvent registeredEvent;
    @Deprecated
    private IOFXUserServices usersServices;
    private IOFXUserEnvironment userEnviormentInformation;

    @Autowired
    public OFXSimpleManMapSession(DefaultTransactionDefinition definition, PlatformTransactionManager manager) {
        this.transactionDefinition = definition;
        this.transactionManager = manager;
        this.sessionOwnerFqName = "";
        this.graphEditFqName = null;
        this.postTransactionOperation = null;
        this.registeredEvent = null;
    }

    public void initSession(IOFXUserEnvironment evn, IOFXUserServices srv, boolean rollbackAlways) {
        this.userEnviormentInformation = evn;
        this.usersServices = srv;
        this.alwaysRollbackSession = rollbackAlways;
    }

    @Override
    public synchronized void setLockedByOtherUser(String whom) {
        this.setReadOnly();
        this.lockedByUser = whom;
        this.isLocked = true;
    }

    @Override
    public boolean isLockedByOtherUser() {
        return this.isLocked;
    }

    @Override
    public String getLockedByUser() {
        return this.lockedByUser;
    }

    @Override
    public void setSharedSession() {
        this.isShared = true;
    }

    @Override
    public boolean inSuccessorPattern() {
        return this.isShared;
    }

    @Override
    public IOFXUserEnvironment getUserEnvironment() {
        return this.userEnviormentInformation;
    }

    @Override
    public IOFXUserServices getUserServices() {
        return this.usersServices;
    }

    @Override
    public void registerUxEvent(IOFXSession.IUxEvent uxEvent) {
        if (this.registeredEvent != null) {
            throw new RuntimeException("There is already the event " + uxEvent.name() + " [" + uxEvent.paramInfo() + "] registered, while you are registering " + uxEvent.name());
        }
        this.registeredEvent = uxEvent;
    }

    @Override
    public IOFXSession.IUxEvent getRegisteredUxEvent() {
        return this.registeredEvent;
    }

    public DateTime getCurrentTransactionTimestamp() {
        if (this.lastTransactionStart == null) {
            throw new IllegalStateException("Requesting timestamp, but no transaction started. ");
        }
        return this.lastTransactionStart;
    }

    public LocalDate getCurrentTransactionLocalDate() {
        return this.getCurrentTransactionTimestamp().toLocalDate();
    }

    @Override
    public void addProblem(IOFXProblem problem) {
        ListSequence.fromList(this.sessionProblems).addElement((Object)problem);
    }

    @Override
    public List<IOFXProblem> getAndclearProblemState() {
        List<IOFXProblem> currentProblems = this.sessionProblems;
        this.sessionProblems = ListSequence.fromList(new ArrayList());
        return currentProblems;
    }

    @Override
    public List<IOFXProblem> getCopyOfProblemState() {
        IListSequence currentProblems = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)currentProblems).addSequence((ISequence)ListSequence.fromList(this.sessionProblems));
        return currentProblems;
    }

    @Override
    public boolean hasProblemsOtherThanWarnings() {
        for (IOFXProblem prb : this.sessionProblems) {
            if (prb.isWarningOnly()) continue;
            return true;
        }
        return false;
    }

    public void reportProblemsByEx() {
        if (this.hasProblemsOtherThanWarnings()) {
            throw new OFXAbortedException();
        }
    }

    @Override
    public void setPostTransactionOperation(IOFXSessionOperation operation) {
        this.postTransactionOperation = operation;
    }

    @Override
    public void startTransactionAndFlush() throws Exception {
        TransactionStatus status = null;
        if (ListSequence.fromList(this.sessionProblems).any(it -> !it.isWarningOnly())) {
            throw new RuntimeException("Programming error: We can not start a transaction and flush it, when we have non-warning problems in the session. " + this.sessionProblems);
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("Programming error: Trying execute startTransactionAndFlush() on a readonly session.");
        }
        if (this.immediateTransactionExecuted) {
            throw new RuntimeException("There was alread an immediateTransactionExecuted in this session. No more transactions are available within this session.");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new MMShutdownRequestException("starting transaction - Thread.interrupted()=true, raising ShutDownRequest Exception.");
        }
        if (this.userEnviormentInformation == null) {
            throw new RuntimeException("UserEnv is null! This can not happen.");
        }
        try {
            int i;
            status = this.transactionManager.getTransaction((TransactionDefinition)this.transactionDefinition);
            this.lastTransactionStart = DeprecatedServerDateProvider.getSqlServerDateTime();
            ListSequence.fromList((List)this.transactionEntities).clear();
            for (i = 0; i < ListSequence.fromList(this.okOperations).count(); ++i) {
                ((IOFXSessionOperation)ListSequence.fromList(this.okOperations).getElement(i)).execute();
            }
            if (this.alwaysRollbackSession) {
                this.transactionManager.rollback(status);
            } else {
                this.transactionManager.commit(status);
            }
            for (i = 0; i < ListSequence.fromList((List)this.transactionEntities).count(); ++i) {
                IM3Entity entity = (IM3Entity)ListSequence.fromList((List)this.transactionEntities).getElement(i);
                entity.clearDirtySetReadonly(false);
            }
            if (this.postTransactionOperation != null) {
                this.postTransactionOperation.execute();
                this.postTransactionOperation = null;
            }
        }
        catch (Exception eWhileTransaction) {
            if (status != null) {
                try {
                    this.transactionManager.rollback(status);
                    if (this.postTransactionOperation != null) {
                        this.postTransactionOperation.execute();
                        this.postTransactionOperation = null;
                    }
                    for (int i = 0; i < ListSequence.fromList((List)this.transactionEntities).count(); ++i) {
                        IM3Entity entity = (IM3Entity)ListSequence.fromList((List)this.transactionEntities).getElement(i);
                        entity.rollback();
                    }
                }
                catch (Throwable tWhileRollback) {
                    eWhileTransaction.addSuppressed((Throwable)new MMAdditionalInfoException("Additionally exception while trying to rollback the transaction" + OFXConsoleHelper.stackTrace2String(tWhileRollback)));
                }
            }
            throw eWhileTransaction;
        }
        finally {
            ListSequence.fromList(this.okOperations).clear();
            ListSequence.fromList((List)this.transactionEntities).clear();
            this.lastTransactionStart = null;
        }
    }

    @Override
    public void immediateTransactionForOperation(IOFXSessionOperation markerOp, IOFXSessionOperation journalOp) throws Exception {
        TransactionStatus status = null;
        if (this.isReadOnly()) {
            throw new RuntimeException("Programming error: Trying execute immediateTransactionForOperation on a readonly session.");
        }
        if (this.immediateTransactionExecuted) {
            throw new RuntimeException("There was alread an immediateTransactionExecuted in this session. No more transactions are available within this session.");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new MMShutdownRequestException("starting transaction - Thread.interrupted()=true, raising ShutDownRequest Exception.");
        }
        if (this.userEnviormentInformation == null) {
            throw new RuntimeException("UserEnv is null! This can not happen.");
        }
        try {
            status = this.transactionManager.getTransaction((TransactionDefinition)this.transactionDefinition);
            this.lastTransactionStart = DeprecatedServerDateProvider.getSqlServerDateTime();
            ListSequence.fromList((List)this.transactionEntities).clear();
            if (markerOp != null) {
                markerOp.execute();
            }
            if (journalOp != null) {
                journalOp.execute();
            }
            if (this.alwaysRollbackSession) {
                this.transactionManager.rollback(status);
            } else {
                this.transactionManager.commit(status);
            }
            for (int i = 0; i < ListSequence.fromList((List)this.transactionEntities).count(); ++i) {
                ((IM3Entity)ListSequence.fromList((List)this.transactionEntities).getElement(i)).clearDirtySetReadonly(false);
            }
            if (this.postTransactionOperation != null) {
                this.postTransactionOperation.execute();
                this.postTransactionOperation = null;
            }
        }
        catch (Exception ex) {
            if (status != null) {
                try {
                    this.transactionManager.rollback(status);
                    if (this.postTransactionOperation != null) {
                        this.postTransactionOperation.execute();
                        this.postTransactionOperation = null;
                    }
                }
                catch (Throwable tWhileRollback) {
                    ex.addSuppressed((Throwable)new MMAdditionalInfoException("Additionally exception while trying to rollback the transaction" + OFXConsoleHelper.stackTrace2String(tWhileRollback)));
                }
            }
            throw ex;
        }
        finally {
            ListSequence.fromList((List)this.transactionEntities).clear();
            this.lastTransactionStart = null;
            this.immediateTransactionExecuted = true;
        }
    }

    @Override
    public List<IOFXSessionOperation> getOperations() {
        return this.okOperations;
    }

    @Override
    public void addOperation(IOFXSessionOperation operation) {
        ListSequence.fromList(this.okOperations).addElement((Object)operation);
    }

    public String toString() {
        return this.getSessionInformation();
    }

    @Override
    public String getCurrentCmdName() {
        if (this.graphEditFqName == null) {
            return this.sessionOwnerFqName;
        }
        return this.graphEditFqName;
    }

    @Override
    public void setSessionOwnerFqName(String cmdFqName) {
        this.sessionOwnerFqName = cmdFqName;
    }

    @Override
    public void setGraphEditFqName(String cmdFqName) {
        this.graphEditFqName = cmdFqName;
    }

    @Override
    public void clearGraphEditFqName() {
        this.graphEditFqName = null;
    }

    @Override
    public String getSessionLoggingId() {
        return "" + this.hashCode();
    }

    @Override
    public String getSessionInformation() {
        int i;
        StringBuilder st = new StringBuilder();
        st.append("x - x - x - x - x - x - x - x - this is a OFXSimpleManMapSession - x - x - x - x - x - x - x - x\n");
        st.append("Session owner fqName: " + this.sessionOwnerFqName + "\n");
        st.append("Graph edit fqName: " + this.graphEditFqName + "\n");
        st.append("Read only session: " + this.isReadOnly() + "\n\n");
        st.append(this.getKeyStoreInfo());
        st.append("\n\n\n");
        for (i = 0; i < ListSequence.fromList(this.okOperations).count(); ++i) {
            st.append(" Operation " + i + ":" + ((IOFXSessionOperation)ListSequence.fromList(this.okOperations).getElement(i)).getInformation() + "\n");
        }
        for (i = 0; i < ListSequence.fromList((List)this.transactionEntities).count(); ++i) {
            st.append(" Entity to commit " + i + ":" + ((IM3Entity)ListSequence.fromList((List)this.transactionEntities).getElement(i)).getClass().getName() + " - " + ListSequence.fromList((List)this.transactionEntities).getElement(i) + "\n");
        }
        st.append("\n\nCurrent problems:");
        for (IOFXProblem prob : this.sessionProblems) {
            st.append("\n" + prob.getProblemDescOrNull() + " / " + prob.getInstanceDescOrNull());
        }
        return st.toString();
    }

    @Override
    public void clearAllKeystoresAndOperations() {
        super.clearAllKeystores();
        ListSequence.fromList(this.okOperations).clear();
    }

    @Override
    public void closeSessionAndfreeGC() {
        this.clearAllKeystoresAndOperations();
        this.usersServices = null;
    }

    public IM3UserEnvironment getIM3UserEnvironment() {
        return this.userEnviormentInformation;
    }

    @Deprecated
    public boolean hasSessionProblems_Lgcy() {
        return ListSequence.fromList(this.sessionProblems).count() > 0;
    }

    @Deprecated
    public IOFXProblem getLastProblem_Lgcy() {
        if (!this.hasSessionProblems_Lgcy()) {
            throw new RuntimeException("This can not happen. Session Problems are 0, but getLastProblem_Lgcy requesgted.");
        }
        return (IOFXProblem)ListSequence.fromList(this.sessionProblems).last();
    }
}

