/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.lang.reflect.Array;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableAttribute;

public class OFXStatus<T extends IOFXMetaStatus.IOFXStatusElement<T>>
implements IOFXMetaStatus<T>,
IOFXRevertableAttribute<OFXStatus<T>> {
    protected boolean optional = false;
    protected boolean enabled = true;
    protected String label;
    protected T defaultStatus;
    protected T[] enabledElements;
    protected T value;
    private Boolean requestFocus;
    private String validationErrorText;

    public OFXStatus(T deflt) {
        this.defaultStatus = deflt;
        this.enabledElements = (IOFXMetaStatus.IOFXStatusElement[])deflt.getAllStatusElements();
        this.value = deflt;
    }

    public boolean setValue(T val) {
        if (this.value == null) {
            if (val != null) {
                this.value = val;
                return true;
            }
        } else if (val == null || !this.value.equals(val)) {
            this.value = val;
            return true;
        }
        return false;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public void load(OFXStatus<T> status, boolean fullRevertNotMerge) {
        if (fullRevertNotMerge) {
            this.enabled = status.enabled;
            this.optional = status.optional;
            this.label = status.label;
            this.enabledElements = status.enabledElements;
        }
        this.value = status.value;
        if (!this.defaultStatus.equals(status.defaultStatus)) {
            throw new RuntimeException("This can not happen.");
        }
    }

    @Override
    public OFXStatus<T> copy() {
        OFXStatus<T> obj = new OFXStatus<T>(this.defaultStatus);
        obj.enabled = this.enabled;
        obj.optional = this.optional;
        obj.label = this.label;
        obj.value = this.value;
        obj.enabledElements = this.enabledElements;
        return obj;
    }

    @Override
    public void setElementsNotTypeSafe(List<T> statusElements) {
        this.enabledElements = (IOFXMetaStatus.IOFXStatusElement[])Array.newInstance(this.defaultStatus.getClass(), statusElements.size());
        for (int i = 0; i < statusElements.size(); ++i) {
            this.enabledElements[i] = (IOFXMetaStatus.IOFXStatusElement)statusElements.get(i);
        }
    }

    @Override
    public T[] getElements() {
        return this.enabledElements;
    }

    @Override
    public T[] getAllElements() {
        return (IOFXMetaStatus.IOFXStatusElement[])this.defaultStatus.getAllStatusElements();
    }

    @Override
    public boolean isElementEnabled(T status) {
        for (T elem : this.enabledElements) {
            if (!elem.equals(status)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void enableElementsByDBValue(String databaseValues) {
        String[] options = databaseValues.split(",");
        IOFXMetaStatus.IOFXStatusElement[] elements = (IOFXMetaStatus.IOFXStatusElement[])Array.newInstance(this.defaultStatus.getClass(), options.length);
        for (int i = 0; i < options.length; ++i) {
            String dbValue = options[i].trim();
            IOFXMetaStatus.IOFXStatusElement elem = (IOFXMetaStatus.IOFXStatusElement)Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])((IOFXMetaStatus.IOFXStatusElement[])this.defaultStatus.getAllStatusElements()))).findFirst(it -> it.getDbValue().equals(dbValue));
            if (elem == null) {
                throw new RuntimeException("No Element with db-value '" + dbValue + "' found for status " + this.defaultStatus.getClass().getName() + ".");
            }
            elements[i] = elem;
        }
        this.enabledElements = elements;
    }

    @Override
    public void setElements(T ... statusObject) {
        this.enabledElements = statusObject;
    }

    @Override
    public void setAllElements() {
        this.enabledElements = this.getAllElements();
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setEnabled(boolean val) {
        this.enabled = val;
    }

    @Override
    public void setOptional(boolean val) {
        this.optional = val;
    }

    @Override
    public void setLabel(String lbl) {
        this.label = lbl;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void requestFocus() {
        this.requestFocus = new Boolean(true);
    }

    @Override
    public boolean getFocusAndClearIt() {
        if (this.requestFocus != null && this.requestFocus.equals(true)) {
            this.requestFocus = null;
            return true;
        }
        this.requestFocus = null;
        return false;
    }

    @Override
    public void setValidationError(String val) {
        this.validationErrorText = val;
    }

    @Override
    public String getValidationError() {
        return this.validationErrorText;
    }
}

