/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.lang.reflect.Array;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableAttribute;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;

public class OFXStatusVP<T extends IOFXMetaStatus.IOFXStatusElement<T>>
extends OFXVPBase<T>
implements IOFXMetaStatus<T>,
IOFXRevertableAttribute<OFXStatusVP<T>> {
    protected T defaultStatus;
    protected T[] enabledElements;
    private String validationErrorText;

    public OFXStatusVP(T deflt) {
        this.defaultStatus = deflt;
        this.enabledElements = (IOFXMetaStatus.IOFXStatusElement[])deflt.getAllStatusElements();
    }

    @Override
    public void load(OFXStatusVP<T> status, boolean fullRevertNotMerge) {
        if (fullRevertNotMerge) {
            this.enabled = status.enabled;
            this.optional = status.optional;
            this.label = status.label;
            this.enabledElements = status.enabledElements;
        }
        if (!this.defaultStatus.equals(status.defaultStatus)) {
            throw new RuntimeException("This can not happen.");
        }
    }

    @Override
    public OFXStatusVP<T> copy() {
        OFXStatusVP<T> obj = new OFXStatusVP<T>(this.defaultStatus);
        obj.enabled = this.enabled;
        obj.optional = this.optional;
        obj.label = this.label;
        obj.enabledElements = this.enabledElements;
        return obj;
    }

    @Override
    public void setElementsNotTypeSafe(List<T> statusElements) {
        this.enabledElements = (IOFXMetaStatus.IOFXStatusElement[])Array.newInstance(this.defaultStatus.getClass(), statusElements.size());
        for (int i = 0; i < statusElements.size(); ++i) {
            this.enabledElements[i] = (IOFXMetaStatus.IOFXStatusElement)statusElements.get(i);
        }
    }

    @Override
    public T[] getElements() {
        return this.enabledElements;
    }

    @Override
    public T[] getAllElements() {
        return (IOFXMetaStatus.IOFXStatusElement[])this.defaultStatus.getAllStatusElements();
    }

    @Override
    public boolean isElementEnabled(T status) {
        for (T elem : this.enabledElements) {
            if (!elem.equals(status)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void enableElementsByDBValue(String databaseValues) {
        String[] options = databaseValues.split(",");
        IOFXMetaStatus.IOFXStatusElement[] elements = (IOFXMetaStatus.IOFXStatusElement[])Array.newInstance(this.defaultStatus.getClass(), options.length);
        for (int i = 0; i < options.length; ++i) {
            String dbValue = options[i].trim();
            IOFXMetaStatus.IOFXStatusElement elem = (IOFXMetaStatus.IOFXStatusElement)Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])((IOFXMetaStatus.IOFXStatusElement[])this.defaultStatus.getAllStatusElements()))).findFirst(it -> it.getDbValue().equals(dbValue));
            if (elem == null) {
                throw new RuntimeException("No Element with db-value '" + dbValue + "' found for status " + this.defaultStatus.getClass().getName() + ".");
            }
            elements[i] = elem;
        }
        this.enabledElements = elements;
    }

    @Override
    public void setElements(T ... statusObject) {
        this.enabledElements = statusObject;
    }

    public String getShortText(T status) {
        return status.getShortDesc();
    }

    public String getLongText(T status) {
        return status.getLongDesc();
    }

    public String getDBText(T status) {
        return status.getDbValue();
    }

    @Override
    public void setAllElements() {
        this.enabledElements = this.getAllElements();
    }

    @Override
    public void setValidationError(String val) {
        this.validationErrorText = val;
    }

    @Override
    public String getValidationError() {
        return this.validationErrorText;
    }
}

