/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.objectflow.runtime.CSVReader;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.JavaStringFromatHelper;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;
import org.springframework.beans.factory.InitializingBean;

public class OFXStringFormatter2
implements IOFXTranslationProvider,
InitializingBean {
    public static final String NULL_STRING = "#NULL?";
    public static IOFXTranslationProvider GLOBAL_INSTANCE_DEFAULT_LANG = null;
    public static final String DEFAULT_LOCALE = "de";
    public static final String DATETIME_DELEGATE_EDITOR_PTRN = "dd.MM.yy HH:mm";
    private String bigDecimalFormat = "#,##0.00";
    private String dateTimeFormat = "dd.MM.yyyy HH:mm:ss";
    private String timeDateTimeFormat = "HH:mm";
    private String localDateFormat = "dd.MM.yy";
    private String shortLocalDateFormat = "dd.MMM";
    public static final String[] FORMAT_KEYS_MOWARE = new String[]{"st", "sts", "stdb", "dt", "ld", "sld", "tdt", "bd"};
    public static final char[] FORMAT_KEYS_SINGLE = new char[]{'d', 's', 'f', 'c', 'o', 'x'};
    private DecimalFormat[] bigDecimalFormatter;
    private DateTimeFormatter[] dateTimeFormatter;
    private DateTimeFormatter[] timeDateTimeFormatter;
    private DateTimeFormatter[] localDateFormatter;
    private DateTimeFormatter[] shortLocalDateFormatter;
    private DateTimeFormatter[] delegateDateTimeEditorFormatter;
    private Map<Integer, String[]> translationMap = null;
    private String pathToFile = null;
    private String relativeFileLocationClass = null;
    private List<String> indexAndLocale = ListSequence.fromList(new ArrayList());

    public void setBigDecimalFormat(String frmt) {
        this.bigDecimalFormat = frmt;
    }

    public void setDateTimeFormat(String frmt) {
        this.dateTimeFormat = frmt;
    }

    public void setTimeDateTimeFormat(String frmt) {
        this.timeDateTimeFormat = frmt;
    }

    public void setLocalDateFormat(String frmt) {
        this.localDateFormat = frmt;
    }

    public void setShortLocalDateFormat(String frmt) {
        this.shortLocalDateFormat = frmt;
    }

    public void setTranslationCsvFileAbsolute(String absolutePathNFile) {
        this.relativeFileLocationClass = null;
        this.pathToFile = absolutePathNFile;
    }

    public void setTranslationCsvFileRelative(String classFqName, String relativePathnFile) {
        this.pathToFile = this.relativeFileLocationClass = classFqName;
    }

    public void setLocaleForTranslation(String locale) {
        this.checkAndAddLocale(locale);
    }

    @Override
    public String translate(int lang, String formatString, Object ... args) {
        formatString = this.translateSingle(lang, formatString);
        String[] splitted = JavaStringFromatHelper.getPercentFormatters(formatString);
        StringBuilder result = new StringBuilder();
        int argsCnt = -1;
        int argsLength = args.length;
        int startOffset = 0;
        result.append(splitted[0]);
        for (int i = 1; i < splitted.length; ++i) {
            String toConvert = splitted[i];
            if (toConvert.startsWith("bd")) {
                result.append("%s" + toConvert.substring(2));
                this.ensureArgAvailabel(++argsCnt, argsLength);
                if (args[argsCnt] instanceof BigDecimal) {
                    args[argsCnt] = this.bigDecimalFormatter[lang + 1].format(args[argsCnt]);
                    continue;
                }
                if (args[argsCnt] == null) {
                    args[argsCnt] = NULL_STRING;
                    continue;
                }
                throw new RuntimeException(this.errorArgExpected(formatString, "BigDecimal", argsCnt, args));
            }
            if (toConvert.startsWith("st") || toConvert.startsWith("sts") || toConvert.startsWith("stdb")) {
                this.ensureArgAvailabel(++argsCnt, argsLength);
                if (args[argsCnt] == null) {
                    args[argsCnt] = NULL_STRING;
                    if (toConvert.startsWith("stdb")) {
                        result.append("%s" + toConvert.substring(4));
                        continue;
                    }
                    if (toConvert.startsWith("sts")) {
                        result.append("%s" + toConvert.substring(3));
                        continue;
                    }
                    if (toConvert.startsWith("st")) {
                        result.append("%s" + toConvert.substring(2));
                        continue;
                    }
                    throw new RuntimeException("This can not happen.");
                }
                if (args[argsCnt] instanceof IOFXMetaStatus.IOFXStatusElement) {
                    if (toConvert.startsWith("stdb")) {
                        result.append("%s" + toConvert.substring(4));
                        args[argsCnt] = ((IOFXMetaStatus.IOFXStatusElement)args[argsCnt]).getDbValue();
                        continue;
                    }
                    if (toConvert.startsWith("sts")) {
                        result.append("%s" + toConvert.substring(3));
                        args[argsCnt] = ((IOFXMetaStatus.IOFXStatusElement)args[argsCnt]).getShortDesc();
                        continue;
                    }
                    if (toConvert.startsWith("st")) {
                        result.append("%s" + toConvert.substring(2));
                        args[argsCnt] = ((IOFXMetaStatus.IOFXStatusElement)args[argsCnt]).getLongDesc();
                        continue;
                    }
                    throw new RuntimeException("This can not happen.");
                }
                throw new RuntimeException(this.errorArgExpected(formatString, "Status", argsCnt, args));
            }
            if (toConvert.startsWith("sld")) {
                String printed;
                result.append("%s" + toConvert.substring(3));
                this.ensureArgAvailabel(++argsCnt, argsLength);
                if (args[argsCnt] instanceof ReadableInstant) {
                    args[argsCnt] = this.shortLocalDateFormatter[lang + 1].print((ReadableInstant)args[argsCnt]);
                } else if (args[argsCnt] instanceof ReadablePartial) {
                    args[argsCnt] = this.shortLocalDateFormatter[lang + 1].print((ReadablePartial)args[argsCnt]);
                } else if (args[argsCnt] == null) {
                    args[argsCnt] = NULL_STRING;
                } else {
                    throw new RuntimeException(this.errorArgExpected(formatString, "LocalDate/Datetime", argsCnt, args));
                }
                if (!this.shortLocalDateFormat.endsWith(".MMM") || NULL_STRING.equals(printed = (String)args[argsCnt])) continue;
                int start = printed.indexOf(".");
                if (printed.length() <= start + 4) continue;
                args[argsCnt] = printed.substring(0, start + 4);
                continue;
            }
            if (toConvert.startsWith("ld")) {
                result.append("%s" + toConvert.substring(2));
                this.ensureArgAvailabel(++argsCnt, argsLength);
                if (args[argsCnt] instanceof ReadableInstant) {
                    args[argsCnt] = this.localDateFormatter[lang + 1].print((ReadableInstant)args[argsCnt]);
                    continue;
                }
                if (args[argsCnt] instanceof ReadablePartial) {
                    args[argsCnt] = this.localDateFormatter[lang + 1].print((ReadablePartial)args[argsCnt]);
                    continue;
                }
                if (args[argsCnt] == null) {
                    args[argsCnt] = NULL_STRING;
                    continue;
                }
                throw new RuntimeException(this.errorArgExpected(formatString, "LocalDate/Datetime", argsCnt, args));
            }
            if (toConvert.startsWith("tdt")) {
                result.append("%s" + toConvert.substring(3));
                this.ensureArgAvailabel(++argsCnt, argsLength);
                if (args[argsCnt] instanceof ReadableInstant) {
                    args[argsCnt] = this.timeDateTimeFormatter[lang + 1].print((ReadableInstant)args[argsCnt]);
                    continue;
                }
                if (args[argsCnt] instanceof ReadablePartial) {
                    args[argsCnt] = this.timeDateTimeFormatter[lang + 1].print((ReadablePartial)args[argsCnt]);
                    continue;
                }
                if (args[argsCnt] == null) {
                    args[argsCnt] = NULL_STRING;
                    continue;
                }
                throw new RuntimeException(this.errorArgExpected(formatString, "LocalDate/Datetime", argsCnt, args));
            }
            if (toConvert.startsWith("dt")) {
                result.append("%s" + toConvert.substring(2));
                this.ensureArgAvailabel(++argsCnt, argsLength);
                if (args[argsCnt] instanceof ReadableInstant) {
                    args[argsCnt] = this.dateTimeFormatter[lang + 1].print((ReadableInstant)args[argsCnt]);
                    continue;
                }
                if (args[argsCnt] instanceof ReadablePartial) {
                    args[argsCnt] = this.dateTimeFormatter[lang + 1].print((ReadablePartial)args[argsCnt]);
                    continue;
                }
                if (args[argsCnt] == null) {
                    args[argsCnt] = NULL_STRING;
                    continue;
                }
                throw new RuntimeException(this.errorArgExpected(formatString, "LocalDate/Datetime", argsCnt, args));
            }
            if (toConvert.startsWith("n")) {
                result.append("%n");
                continue;
            }
            if (toConvert.startsWith("%")) {
                result.append("%%" + toConvert.substring(1));
                continue;
            }
            startOffset = JavaStringFromatHelper.isFlagsAndPrecission(toConvert);
            if (startOffset >= 0) {
                String remainder;
                this.ensureArgAvailabel(++argsCnt, argsLength);
                Object convertedFormat = "%";
                if (startOffset != 1 || !toConvert.startsWith("0s") && !toConvert.startsWith("0d")) {
                    convertedFormat = (String)convertedFormat + toConvert.substring(0, startOffset);
                }
                if ((remainder = toConvert.substring(startOffset)).startsWith("bd")) {
                    convertedFormat = (String)convertedFormat + "f" + remainder.substring(2);
                } else if (JavaStringFromatHelper.in(remainder.charAt(0), FORMAT_KEYS_SINGLE)) {
                    convertedFormat = (String)convertedFormat + remainder;
                } else {
                    throw new RuntimeException("FlagsAndPrecession (offset " + startOffset + "): It is unclear how we should handle '%" + toConvert + "' as formatString");
                }
                if (args[argsCnt] == null) {
                    args[argsCnt] = NULL_STRING;
                    result.append("%s");
                    continue;
                }
                if (args[argsCnt] instanceof ReadableInstant || args[argsCnt] instanceof ReadablePartial) {
                    throw new RuntimeException(this.errorArgExpected(formatString, "Int/BigDeci/String", argsCnt, args));
                }
                result.append((String)convertedFormat);
                continue;
            }
            throw new RuntimeException("Completely unclear how we should handle the partial format string '%" + toConvert + "'.");
        }
        return String.format(result.toString(), args);
    }

    @Override
    public String translateSingle(int lang, String label) {
        String[] transLations;
        int index;
        if (lang < 0) {
            return label;
        }
        int hashCode = label.hashCode();
        if (this.translationMap != null && this.translationMap.containsKey(hashCode) && (index = lang + 3) < (transLations = this.translationMap.get(hashCode)).length) {
            return transLations[index];
        }
        return label;
    }

    @Override
    public boolean providesTranslationKey(String key) {
        return this.translationMap != null && this.translationMap.containsKey(key.hashCode());
    }

    @Override
    public DecimalFormat getDecimalFormatter(int langIndex, String formatOrNull) {
        if (formatOrNull == null || "".equals(formatOrNull.trim()) || "no0".equals(formatOrNull)) {
            return this.bigDecimalFormatter[langIndex + 1];
        }
        return MoWareFormattersFactory.forDecimalFormatPattern(formatOrNull, (String)ListSequence.fromList(this.indexAndLocale).getElement(langIndex + 1));
    }

    @Override
    public String getDefaultDecimalFormat() {
        return this.bigDecimalFormat;
    }

    @Override
    public DecimalFormat getIntegerFormatterOrNull(int langIndex, String formatOrNull) {
        if (formatOrNull == null || "".equals(formatOrNull.trim()) || "no0".equals(formatOrNull.trim())) {
            return null;
        }
        return MoWareFormattersFactory.forDecimalFormatPattern(formatOrNull, (String)ListSequence.fromList(this.indexAndLocale).getElement(langIndex + 1));
    }

    @Override
    public DateTimeFormatter getLocalDateFormatter(int langIndex, String formatOrNull) {
        if (formatOrNull == null || "".equals(formatOrNull.trim())) {
            return this.localDateFormatter[langIndex + 1];
        }
        return MoWareFormattersFactory.forDateTimePattern(formatOrNull, (String)ListSequence.fromList(this.indexAndLocale).getElement(langIndex + 1));
    }

    @Override
    public String getDefaultLocalDateFormat() {
        return this.localDateFormat;
    }

    @Override
    public DateTimeFormatter getDelegateDateTimeEditorFormatter(int langIndex, String formatOrNull) {
        if (formatOrNull == null || "".equals(formatOrNull.trim())) {
            return this.delegateDateTimeEditorFormatter[langIndex + 1];
        }
        return MoWareFormattersFactory.forDateTimePattern(formatOrNull, (String)ListSequence.fromList(this.indexAndLocale).getElement(langIndex + 1));
    }

    @Override
    public String getDefaultDelegateDateTimeEditorFormat() {
        return DATETIME_DELEGATE_EDITOR_PTRN;
    }

    @Override
    public Map<Integer, String> getStatusTranslationMap(int langIndex, IOFXMetaStatus.IOFXStatusElement<? extends IOFXMetaStatus.IOFXStatusElement> statusElement, boolean longDesc) {
        HashMap<Integer, String> translations = new HashMap<Integer, String>();
        for (IOFXMetaStatus.IOFXStatusElement elem : statusElement.getAllStatusElements()) {
            if (longDesc) {
                translations.put(elem.getDbValue().hashCode(), this.translateSingle(langIndex, elem.getLongDesc()));
                continue;
            }
            translations.put(elem.getDbValue().hashCode(), this.translateSingle(langIndex, elem.getShortDesc()));
        }
        return translations;
    }

    private void ensureArgAvailabel(int cur, int argsLenght) {
        if (cur >= argsLenght) {
            throw new RuntimeException("Expecting to format argument " + (cur + 1) + " but we have only " + argsLenght + " in total.");
        }
    }

    private String errorArgExpected(String formatString, String type, int argsCnt, Object ... args) {
        return type + " is required, but argument no. " + argsCnt + " given is (" + args[argsCnt] + ") for '" + formatString + "'";
    }

    public void afterPropertiesSet() {
        ListSequence.fromList(this.indexAndLocale).insertElement(0, (Object)DEFAULT_LOCALE);
        int transCnt = ListSequence.fromList(this.indexAndLocale).count();
        this.bigDecimalFormatter = new DecimalFormat[transCnt];
        this.dateTimeFormatter = new DateTimeFormatter[transCnt];
        this.timeDateTimeFormatter = new DateTimeFormatter[transCnt];
        this.localDateFormatter = new DateTimeFormatter[transCnt];
        this.shortLocalDateFormatter = new DateTimeFormatter[transCnt];
        this.delegateDateTimeEditorFormatter = new DateTimeFormatter[transCnt];
        for (int i = 0; i < transCnt; ++i) {
            this.bigDecimalFormatter[i] = MoWareFormattersFactory.forDecimalFormatPattern(this.bigDecimalFormat, (String)ListSequence.fromList(this.indexAndLocale).getElement(i));
            this.dateTimeFormatter[i] = MoWareFormattersFactory.forDateTimePattern(this.dateTimeFormat, (String)ListSequence.fromList(this.indexAndLocale).getElement(i));
            this.timeDateTimeFormatter[i] = MoWareFormattersFactory.forDateTimePattern(this.timeDateTimeFormat, (String)ListSequence.fromList(this.indexAndLocale).getElement(i));
            this.localDateFormatter[i] = MoWareFormattersFactory.forDateTimePattern(this.localDateFormat, (String)ListSequence.fromList(this.indexAndLocale).getElement(i));
            this.shortLocalDateFormatter[i] = MoWareFormattersFactory.forDateTimePattern(this.shortLocalDateFormat, (String)ListSequence.fromList(this.indexAndLocale).getElement(i));
            this.delegateDateTimeEditorFormatter[i] = MoWareFormattersFactory.forDateTimePattern(DATETIME_DELEGATE_EDITOR_PTRN, (String)ListSequence.fromList(this.indexAndLocale).getElement(i));
        }
        try {
            if (this.relativeFileLocationClass == null && this.pathToFile != null) {
                this.acutallyLoadIt(new FileReader(new File(this.pathToFile)));
            } else if (this.relativeFileLocationClass != null && this.pathToFile != null) {
                Class<?> classDef = Class.forName(this.relativeFileLocationClass);
                InputStream stream = classDef.getResourceAsStream(this.pathToFile);
                this.acutallyLoadIt(new InputStreamReader(stream));
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        GLOBAL_INSTANCE_DEFAULT_LANG = this;
    }

    private void acutallyLoadIt(Reader reader) throws IOException {
        CSVReader csvReader = new CSVReader(reader);
        List<String[]> allLines = csvReader.readAll();
        this.translationMap = new HashMap<Integer, String[]>();
        for (String[] line : allLines) {
            if (line.length < 3) {
                throw new RuntimeException("Expected format is: <orig-text>, <origin of text>, <mps code>, trans_0, trans_1 etc. Here we have: " + OFXStringFormatter2.printArray(line));
            }
            this.translationMap.put(line[0].hashCode(), line);
            if (line.length <= 3 + (ListSequence.fromList(this.indexAndLocale).count() - 1)) continue;
            throw new RuntimeException("Seems that there are " + (line.length - 3) + " translation(s), but only " + (ListSequence.fromList(this.indexAndLocale).count() - 1) + " locales defined.");
        }
        csvReader.close();
        reader.close();
    }

    private void checkAndAddLocale(String locale) {
        String val = "trans_" + ListSequence.fromList(this.indexAndLocale).count();
        int lang = -1;
        if (val == null) {
            throw new RuntimeException("Do not set Language to null");
        }
        if (!val.startsWith("trans_")) {
            throw new RuntimeException("Languages can be set to 'trans_<xxx>' only. You specified an illegal lang label: " + val);
        }
        try {
            lang = Integer.parseInt(val.substring(6));
        }
        catch (Exception e) {
            throw new RuntimeException("Languages can be set to 'trans_<xxx>' only. You specified an illegal integer suffix: " + val);
        }
        if (lang != ListSequence.fromList(this.indexAndLocale).count()) {
            throw new RuntimeException("You have to set the locale one by one, starting with index 0. You provided index " + lang + " and there are " + ListSequence.fromList(this.indexAndLocale).count() + " already registered.");
        }
        ListSequence.fromList(this.indexAndLocale).addElement((Object)locale);
    }

    private static String printArray(String[] ar) {
        StringBuilder sb = new StringBuilder();
        for (String s : ar) {
            sb.append(s + ", ");
        }
        return sb.toString();
    }

    public static void someMain(String[] args) {
        System.err.println(" my value is " + MoWareFormattersFactory.forDecimalFormatPattern("#,##0.00", DEFAULT_LOCALE).format(new BigDecimal("4711.03")));
    }
}

