/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;

public class OFXUrlParams {
    public static final String PICKUPURL = "__startcmd__";
    protected List<String> segments;

    public OFXUrlParams() {
        this.segments = new ArrayList<String>();
    }

    public OFXUrlParams(List<String> path) {
        this.segments = path;
    }

    public void parse(String path) {
        if (path == null) {
            this.segments.clear();
        } else {
            int endIndex = path.indexOf("?");
            String basePath = endIndex >= 0 ? path.substring(0, endIndex) : (path.contains("#") ? path.substring(0, path.indexOf(35)) : path);
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            this.segments = Arrays.asList(basePath.split("/"));
        }
    }

    public boolean isPickup() {
        if (this.segments.size() == 0) {
            return false;
        }
        return PICKUPURL.equals(this.segments.get(0));
    }

    public boolean hasCmdName() {
        if (this.segments.size() == 0) {
            return false;
        }
        String name = this.segments.get(0);
        return name != null && !"".equals(name.trim());
    }

    public String getCmdName() {
        return this.segments.get(0);
    }

    public String getFirstOrEmpty() {
        if (this.hasCmdName()) {
            return this.getCmdName();
        }
        return "";
    }

    public int numParams() {
        int num = this.segments.size() - 1;
        if (num < 0) {
            num = 0;
        }
        return num;
    }

    public String getStringParamOrNull(int index) {
        if (++index < this.segments.size()) {
            return this.segments.get(index);
        }
        return null;
    }

    public Integer getIntParamOr0(int index) {
        if (++index < this.segments.size()) {
            return Integer.valueOf(this.segments.get(index));
        }
        return 0;
    }

    public IOFXMetaStatus.IOFXStatusElement getStatusParamOrNull(int index, IOFXMetaStatus.IOFXStatusElement onCreate) {
        IOFXMetaStatus.IOFXStatusElement[] allElements = (IOFXMetaStatus.IOFXStatusElement[])onCreate.getAllStatusElements();
        String lookingFor = this.segments.get(++index);
        for (IOFXMetaStatus.IOFXStatusElement elem : allElements) {
            if (!elem.getDbValue().equals(lookingFor)) continue;
            return elem;
        }
        throw new IllegalArgumentException("'" + lookingFor + "' is not a valid status value for " + onCreate.getClass().getName());
    }

    public static String cmdParamObjectToString(Object o) {
        if (o instanceof IOFXMetaStatus.IOFXStatusElement) {
            return ((IOFXMetaStatus.IOFXStatusElement)o).getDbValue();
        }
        return "" + o;
    }

    public String asUrl() {
        return "/" + String.join((CharSequence)"/", this.segments);
    }

    public boolean same(String someUrl) {
        return this.asUrl().equals(someUrl);
    }

    public String toString() {
        return "Params: size " + this.segments.size() + " as URL '" + this.asUrl() + "'";
    }

    public static void main(String[] args) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("dan");
        segments.add("man");
        OFXUrlParams p = new OFXUrlParams(segments);
        System.err.println(p.asUrl());
        p = new OFXUrlParams();
        p.parse("/dan/man//////////");
        System.err.println(p.asUrl());
        System.err.println(p.numParams());
        p.parse("dan/man");
        System.err.println(p.asUrl());
        p = new OFXUrlParams((List<String>)ListSequence.fromList(new ArrayList()));
        System.err.println(p.hasCmdName());
    }

    public static interface OFXUrlCmdParams {
        public Object[] calc(OFXUrlParams var1);
    }
}

