/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class Selection<T>
implements IOFXSelection<T> {
    protected List<T> selectedObjects;
    protected Class typeOfT;
    protected int issuedComponent;

    public Selection(Class type, List<T> objects) {
        this.typeOfT = type;
        this.selectedObjects = objects;
        this.issuedComponent = this.hashCode();
    }

    public Selection(Class type, T[] objects) {
        this.typeOfT = type;
        this.selectedObjects = Arrays.asList(objects);
    }

    public Selection(T object) {
        this.typeOfT = object.getClass();
        this.selectedObjects = new ArrayList<T>();
        this.selectedObjects.add(object);
    }

    public Selection(Class objectType) {
        this.typeOfT = objectType;
        this.selectedObjects = new ArrayList<T>();
    }

    public void setIssuer(int hashCode) {
        this.issuedComponent = hashCode;
    }

    @Override
    public int getIssuer() {
        return this.issuedComponent;
    }

    @Override
    public boolean isEmpty() {
        return this.selectedObjects.size() == 0;
    }

    @Override
    public boolean isSingleObject() {
        return this.selectedObjects.size() == 1;
    }

    @Override
    public T getObject() {
        if (this.selectedObjects.size() != 1) {
            throw new IllegalArgumentException("More than one or none " + this.typeOfT.getName() + " were selected, although only one was expected!");
        }
        return this.selectedObjects.get(0);
    }

    @Override
    public T getObjectOrNull() {
        if (this.selectedObjects.size() != 1) {
            return null;
        }
        return this.selectedObjects.get(0);
    }

    @Override
    public List<T> getObjects() {
        return this.selectedObjects;
    }

    @Override
    public boolean isContainedIn(List<T> containedList) {
        boolean noFasterMethod = ListSequence.fromList(containedList).containsSequence((ISequence)ListSequence.fromList(this.selectedObjects));
        return noFasterMethod;
    }

    public void setObject(T object) {
        this.selectedObjects = new ArrayList<T>();
        this.selectedObjects.add(object);
    }

    public void setObjects(List<T> objects) {
        if (!objects.get(0).getClass().equals(this.typeOfT)) {
            throw new IllegalArgumentException("Setting object list with wrong type " + objects.get(0).getClass().getName() + "  expected  " + this.typeOfT.getName());
        }
        this.selectedObjects = objects;
    }

    @Override
    public int size() {
        return this.selectedObjects.size();
    }

    @Override
    public Class getType() {
        return this.typeOfT;
    }

    public boolean equals(Object otherSelectionUnCast) {
        if (!(otherSelectionUnCast instanceof Selection)) {
            return false;
        }
        if (otherSelectionUnCast == null) {
            return false;
        }
        Selection otherSelection = (Selection)otherSelectionUnCast;
        if (this.size() != otherSelection.size()) {
            return false;
        }
        if (!this.getType().equals(otherSelection.getType())) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (SaveObjectComperator.equals(this.selectedObjects.get(i), otherSelection.selectedObjects.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsList(List<T> objects) {
        if (ListSequence.fromList(objects).count() != this.selectedObjects.size()) {
            return false;
        }
        Wrappers._int i = new Wrappers._int(0);
        while (i.value < this.selectedObjects.size()) {
            if (!ListSequence.fromList(objects).any(it -> it.equals(this.selectedObjects.get(i.value)))) {
                return false;
            }
            ++i.value;
        }
        return true;
    }

    public String toString() {
        if (this.typeOfT == null) {
            return "";
        }
        return "(" + this.selectedObjects.size() + " * " + this.typeOfT.getName() + ")";
    }

    public static IOFXSelection convertObject2Selection(Object obj) {
        if (obj instanceof List) {
            if (((List)obj).size() > 0) {
                return new Selection(((List)obj).get(0).getClass(), (List)obj);
            }
            return null;
        }
        if (obj != null) {
            return new Selection<Object>(obj);
        }
        return null;
    }
}

