/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.sdservices.CField;
import org.modellwerkstatt.objectflow.sdservices.CObjectField;
import org.modellwerkstatt.objectflow.sdservices.MoWareEntityReflector;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.serdes.SerdesException;

public abstract class BaseSerdes<T>
implements IConvSerdes<T> {
    protected IConvFormatOptions formatters;
    protected MoWareEntityReflector reflector;
    protected Class<T> rootClass;
    protected CObjectField objTreeMeta;
    protected boolean arraySerdes;
    protected boolean useCompactingArrays;

    public BaseSerdes(Class<T> cls, IConvFormatOptions frmt) {
        this.rootClass = cls;
        this.formatters = frmt;
        this.reflector = new MoWareEntityReflector();
        this.useCompactingArrays = this.formatters.hasMode(IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO);
        String className = this.rootClass.getName();
        if (className.startsWith("[L") && className.endsWith(";")) {
            className = className.substring(2, className.length() - 1);
            try {
                this.rootClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.expectArrayAtRoot();
        }
        this.objTreeMeta = new CObjectField(this.rootClass.getSimpleName(), CField.OFXType.OFX_VALUE_OBJ, this.rootClass);
        this.reflector.constructCObjectTree(this.objTreeMeta);
    }

    public void expectArrayAtRoot() {
        this.arraySerdes = true;
    }

    public static Integer parseInt(String value) {
        return value == null ? -1 : Integer.parseInt(value);
    }

    public static LocalDate parseLocalDate(IConvFormatOptions frmt, String value) {
        try {
            if (value == null || "".equals(value)) {
                return null;
            }
            LocalDate date = frmt.parseLocalDate(value);
            return date;
        }
        catch (Throwable t) {
            throw new SerdesException("Expected LocalDate but got '" + value + "' (wrong format?).");
        }
    }

    public static DateTime parseDateTime(IConvFormatOptions frmt, String value) {
        try {
            if (value == null || "".equals(value)) {
                return null;
            }
            DateTime dt = frmt.parseDateTime(value);
            return dt;
        }
        catch (Throwable t) {
            throw new SerdesException("Expected DateTime but got '" + value + "' (wrong format?).");
        }
    }

    public static BigDecimal parseBigDecimal(IConvFormatOptions frmt, String value) {
        try {
            if (value == null || "".equals(value)) {
                return null;
            }
            BigDecimal deci = frmt.parseBigDecimal(value);
            return deci;
        }
        catch (Throwable t) {
            throw new SerdesException("Expected BigDecimal but got '" + value + "' (wrong format?).");
        }
    }

    public static Object parseStatus(Class statusClass, String value) {
        try {
            return MoWareEntityReflector.statusFromString(statusClass, value);
        }
        catch (Exception ex) {
            throw new SerdesException("Can not convert '" + value + "' to status " + statusClass.getSimpleName() + ".");
        }
    }

    protected Object valueToObjectByType(String value, CField.OFXType type) {
        if (type == CField.OFXType.OFX_INT) {
            return BaseSerdes.parseInt(value);
        }
        if (type == CField.OFXType.OFX_STRING) {
            return value;
        }
        if (type == CField.OFXType.OFX_LOCALDATE) {
            return BaseSerdes.parseLocalDate(this.formatters, value);
        }
        if (type == CField.OFXType.OFX_DATETIME) {
            return BaseSerdes.parseDateTime(this.formatters, value);
        }
        if (type == CField.OFXType.OFX_BIGDECIMAL) {
            return BaseSerdes.parseBigDecimal(this.formatters, value);
        }
        throw new RuntimeException("This can not happen. Unknown type " + type);
    }
}

