/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.List;
import org.modellwerkstatt.objectflow.sdservices.CField;
import org.modellwerkstatt.objectflow.sdservices.CListField;
import org.modellwerkstatt.objectflow.sdservices.CObjectField;
import org.modellwerkstatt.objectflow.sdservices.JackyFieldSerdes;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.modellwerkstatt.objectflow.sdservices.JackyParsed;
import org.modellwerkstatt.objectflow.sdservices.VElement;
import org.modellwerkstatt.objectflow.sdservices.VField;
import org.modellwerkstatt.objectflow.sdservices.VList;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.sdservices.VParent;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.SerdesException;

public class JackyGraphSerdes<T>
extends JackyFieldSerdes<T> {
    public JackyGraphSerdes(Class<T> cls, IConvFormatOptions frmt) {
        super(new JackyInfra(), cls, frmt);
    }

    public JackyGraphSerdes(JackyInfra infra, Class<T> cls, IConvFormatOptions frmt) {
        super(infra, cls, frmt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deserObject(String basePath, Object currentInstance, CObjectField objMeta, VElement objData) {
        if (objData instanceof VObject) {
            Object resultInstance = this.deserToObject(basePath, objMeta, (VObject)objData);
            objMeta.set(currentInstance, resultInstance);
            return;
        } else if (objData instanceof VField) {
            VField nullField = (VField)objData;
            if (nullField.type != VField.VType.NULL) throw new SerdesException("Expected object value but found a field value " + nullField + " instead.");
            objMeta.set(currentInstance, null);
            return;
        } else {
            if (objData != null) return;
            objMeta.set(currentInstance, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deserList(String basePath, Object currentInstance, CListField listMeta, VElement objData) {
        if (objData == null) return;
        if (objData instanceof VField) {
            VField nullField = (VField)objData;
            if (nullField.type != VField.VType.NULL) throw new SerdesException("Expecting list for " + listMeta.name + " but found " + nullField.value + " in json.");
            if (this.formatters.hasMode(IConvFormatOptions.Mode.NULL_ARRAY_TO_EMPTY)) return;
            listMeta.set(currentInstance, null);
            return;
        } else {
            VList realItemsInList = (VList)objData;
            Object listObject = listMeta.get(currentInstance);
            String path = basePath + "." + listMeta.name;
            for (VObject listValueItem : realItemsInList.objects) {
                Object resultInstance = this.deserToObject(path, listMeta, listValueItem);
                this.reflector.callListAdder(listObject, resultInstance);
            }
        }
    }

    protected <OBJTYPE> OBJTYPE deserToObject(String basePath, CObjectField curConcept, VObject data) {
        Object currentInstance = curConcept.newInstance();
        if (this.formatters.hasMode(IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY) && curConcept.fields.size() != data.fields.size()) {
            throw new SerdesException("Number of fields in json data '" + data + "' do not match " + curConcept + " " + curConcept.fields + " (mode " + IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY + ")");
        }
        for (CField trgt : curConcept.fields) {
            String fqPath = basePath + "." + trgt.name;
            if (trgt instanceof CListField) {
                CListField listField = (CListField)trgt;
                VElement itemsInList = this.resolveJSonField(data, curConcept, listField.name);
                this.deserList(basePath, currentInstance, listField, itemsInList);
                continue;
            }
            if (trgt instanceof CObjectField) {
                CObjectField objField = (CObjectField)trgt;
                VElement valueElem = this.resolveJSonField(data, curConcept, objField.name);
                this.deserObject(fqPath, currentInstance, objField, valueElem);
                continue;
            }
            CField fldMeta = trgt;
            VField fldDAta = (VField)this.resolveJSonField(data, curConcept, fldMeta.name);
            this.deserField(fqPath, currentInstance, fldMeta, fldDAta);
        }
        return (OBJTYPE)currentInstance;
    }

    protected T deserToRootObject(CObjectField objectMeta, VObject dataObj) {
        return (T)this.deserToObject("ROOT", this.objTreeMeta, dataObj);
    }

    protected T deserToRootArray(CObjectField objectMeta, VList theList) {
        int arrayLength = theList.objects.size();
        Object ar = Array.newInstance(this.rootClass, arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            VObject valueItem = theList.objects.get(i);
            Object item = this.deserToObject("ROOT", this.objTreeMeta, valueItem);
            Array.set(ar, i, item);
        }
        return (T)ar;
    }

    @Override
    public T deser(String st) {
        JackyParsed parser = new JackyParsed();
        VParent rootObject = parser.parse(this.infra.createParser(st));
        if (this.formatters.hasMode(IConvFormatOptions.Mode.DEBUG_TO_STDERR)) {
            JackyInfra.printDebugObject("", rootObject);
            JackyInfra.printDebugObject("", this.objTreeMeta);
        }
        if (this.arraySerdes) {
            return this.deserToRootArray(this.objTreeMeta, (VList)rootObject);
        }
        return this.deserToRootObject(this.objTreeMeta, (VObject)rootObject);
    }

    public T internalDeser(VParent rootObject) {
        if (this.arraySerdes) {
            return this.deserToRootArray(this.objTreeMeta, (VList)rootObject);
        }
        return this.deserToRootObject(this.objTreeMeta, (VObject)rootObject);
    }

    protected void serObject(JsonGenerator gen, String fqPath, CObjectField objMeta, Object dto, boolean compactThis) throws IOException {
        gen.writeFieldName(this.formatters.fieldPathToJson(objMeta.name));
        if (dto != null) {
            gen.writeStartObject();
            this.serDispatchFields(gen, fqPath, objMeta.fields, dto, compactThis);
            gen.writeEndObject();
        } else {
            gen.writeNull();
        }
    }

    protected void serList(JsonGenerator gen, String fqPath, CListField listMeta, List listOfObject, boolean compactThis) throws IOException {
        gen.writeFieldName(this.formatters.fieldPathToJson(listMeta.name));
        if (listOfObject != null) {
            gen.writeStartArray();
            boolean toCompact = this.useCompactingArrays && listMeta.fields.size() == 1;
            for (Object listItem : listOfObject) {
                if (!toCompact) {
                    gen.writeStartObject();
                }
                this.serDispatchFields(gen, fqPath, listMeta.fields, listItem, toCompact);
                if (toCompact) continue;
                gen.writeEndObject();
            }
            gen.writeEndArray();
        } else {
            gen.writeNull();
        }
    }

    protected void serDispatchFields(JsonGenerator gen, String partentPath, List<CField> fields, Object dto, boolean compactThis) throws IOException {
        for (CField trgt : fields) {
            String fqPath = partentPath + "." + trgt.name;
            if (trgt instanceof CListField) {
                CListField listField = (CListField)trgt;
                List listObject = (List)listField.get(dto);
                this.serList(gen, fqPath, listField, listObject, compactThis);
                continue;
            }
            if (trgt instanceof CObjectField) {
                CObjectField objField = (CObjectField)trgt;
                Object dtoOfProperty = objField.get(dto);
                this.serObject(gen, fqPath, objField, dtoOfProperty, compactThis);
                continue;
            }
            CField fldConcept = trgt;
            Object fieldValue = fldConcept.get(dto);
            JackyFieldSerdes.serField(gen, this.formatters, fldConcept.type, fldConcept.name, fieldValue, compactThis);
        }
    }

    protected void serRootObject(JsonGenerator gen, Object dto) throws IOException {
        gen.writeStartObject();
        this.serDispatchFields(gen, "ROOT", this.objTreeMeta.fields, dto, false);
        gen.writeEndObject();
    }

    protected void serRootArray(JsonGenerator gen, Object graph) throws IOException {
        int arrayLength = Array.getLength(graph);
        boolean toCompact = this.useCompactingArrays && this.objTreeMeta.fields.size() == 1;
        gen.writeStartArray();
        for (int i = 0; i < arrayLength; ++i) {
            Object item = Array.get(graph, i);
            if (!toCompact) {
                gen.writeStartObject();
            }
            this.serDispatchFields(gen, "ROOT", this.objTreeMeta.fields, item, toCompact);
            if (toCompact) continue;
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    public void internalSer(JsonGenerator gen, String fldName, T graph, boolean compactThis) throws IOException {
        if (!compactThis) {
            gen.writeFieldName(fldName);
        }
        if (!this.arraySerdes) {
            this.serRootObject(gen, graph);
        } else {
            this.serRootArray(gen, graph);
        }
    }

    @Override
    public String ser(T graph) {
        String result;
        JsonGenerator gen = null;
        if (this.formatters.hasMode(IConvFormatOptions.Mode.DEBUG_TO_STDERR)) {
            JackyInfra.printDebugObject("", this.objTreeMeta);
        }
        try (StringWriter sw = new StringWriter();){
            gen = this.infra.createGenerator(sw, this.formatters.hasMode(IConvFormatOptions.Mode.PRETTY));
            if (!this.arraySerdes) {
                this.serRootObject(gen, graph);
            } else {
                this.serRootArray(gen, graph);
            }
            gen.close();
            gen = null;
            result = sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (gen != null) {
                try {
                    gen.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }
}

