/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.sdservices.CField;
import org.modellwerkstatt.objectflow.sdservices.CListField;
import org.modellwerkstatt.objectflow.sdservices.CObjectField;
import org.modellwerkstatt.objectflow.sdservices.VElement;
import org.modellwerkstatt.objectflow.sdservices.VField;
import org.modellwerkstatt.objectflow.sdservices.VList;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;

public class JackyInfra {
    private JsonFactory factory = new JsonFactory();

    public JsonGenerator createGenerator(StringWriter sw, boolean prettyPrint) {
        try {
            JsonGenerator gen = this.factory.createGenerator((Writer)sw);
            if (prettyPrint) {
                gen.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            }
            return gen;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonParser createParser(String forString) {
        try {
            return this.factory.createParser(forString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object identifyString(IConvFormatOptions formatters, String value) {
        try {
            LocalDate date = formatters.parseLocalDate(value);
            return date;
        }
        catch (Throwable date) {
            try {
                DateTime dt = formatters.parseDateTime(value);
                return dt;
            }
            catch (Throwable dt) {
                try {
                    BigDecimal deci = formatters.parseBigDecimal(value);
                    return deci;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
    }

    public static VField.VType cTypeFromFQName(String typeFqName) {
        if (typeFqName.contains("LocalDate")) {
            return VField.VType.LOCALDATE;
        }
        if (typeFqName.contains("DateTime")) {
            return VField.VType.DATETIME;
        }
        if (typeFqName.contains("BigDecimal")) {
            return VField.VType.BIGDECIMAL;
        }
        return VField.VType.STRING;
    }

    public static void debugObjectToString(StringBuilder result, String indent, VElement elem) {
        if (elem instanceof VObject) {
            VObject obj = (VObject)elem;
            result.append(indent + obj + "\n");
            for (VElement vElement : obj.fields) {
                JackyInfra.debugObjectToString(result, indent + "\t", vElement);
            }
        } else if (elem instanceof VList) {
            VList obj = (VList)elem;
            result.append(indent + obj + " [\n");
            for (VElement vElement : obj.objects) {
                JackyInfra.debugObjectToString(result, indent, vElement);
            }
            result.append(indent + "]\n");
        } else {
            VField fld = (VField)elem;
            result.append(indent + elem + "\n");
        }
    }

    public static void printDebugObject(String indent, VElement elem) {
        if (elem instanceof VObject) {
            VObject obj = (VObject)elem;
            System.err.println(indent + obj);
            for (VElement vElement : obj.fields) {
                JackyInfra.printDebugObject(indent + "\t", vElement);
            }
        } else if (elem instanceof VList) {
            VList obj = (VList)elem;
            System.err.println(indent + obj + " [");
            for (VElement vElement : obj.objects) {
                JackyInfra.printDebugObject(indent, vElement);
            }
            System.err.println(indent + "]");
        } else {
            VField fld = (VField)elem;
            System.err.println(indent + elem);
        }
    }

    public static void printDebugObject(String indent, CField elem) {
        if (elem instanceof CObjectField) {
            CObjectField obj;
            System.err.println(indent + obj + ((obj = (CObjectField)elem).isOrigNotAttached() ? "" : " (not orig)"));
            if (obj.isOrigNotAttached()) {
                for (CField it : obj.fields) {
                    JackyInfra.printDebugObject(indent + "\t", it);
                }
            }
        } else if (elem instanceof CListField) {
            CListField obj;
            System.err.println(indent + obj + ((obj = (CListField)elem).isOrigNotAttached() ? "" : " (not orig)") + " [");
            if (obj.isOrigNotAttached()) {
                for (CField it : obj.fields) {
                    JackyInfra.printDebugObject(indent, it);
                }
            }
            System.err.println(indent + "]");
        } else {
            System.err.println(indent + elem);
        }
    }

    public static void main(String[] args) {
        JackyInfra helper = new JackyInfra();
        try {
            StringWriter sw = new StringWriter();
            JsonGenerator gen = helper.createGenerator(sw, true);
            gen.writeStartObject();
            gen.writeFieldName("test");
            gen.writeNumber(1.0f);
            gen.writeEndObject();
            gen.close();
            System.err.println("> " + sw.toString() + "<");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

