/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import org.modellwerkstatt.objectflow.sdservices.VField;
import org.modellwerkstatt.objectflow.sdservices.VList;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.sdservices.VParent;
import org.modellwerkstatt.objectflow.serdes.SerdesException;

public class JackyParsed {
    private JsonParser p;
    private long tokenCnt = 0L;
    private VParent root;
    private VParent current;

    public void error(String desc) {
        throw new SerdesException("Token num " + this.tokenCnt + " [" + this.p.getCurrentToken() + "] : " + desc);
    }

    public void l(String s) {
    }

    public void processToken(JsonToken token) throws IOException {
        this.l(String.format("ConvJacksonParser.parse(): %20s %20s %20s", token, this.p.getCurrentName(), this.p.getValueAsString()));
        if (token == null) {
            this.error("processToken() can not process null token.");
        }
        switch (token) {
            case START_OBJECT: {
                VObject newObject = new VObject(this.current, this.p.getCurrentName());
                this.current = newObject;
                break;
            }
            case END_OBJECT: {
                VParent parent;
                if (this.current.isList()) {
                    this.error("This can not happen, we are no longer working on an objet item here. current is " + this.current);
                }
                if ((parent = this.current.parent) != null) {
                    if (parent.isList()) {
                        parent.addObjectToList(this.current);
                    } else {
                        parent.addField(this.current);
                    }
                }
                this.current = parent;
                break;
            }
            case START_ARRAY: {
                String listName = this.p.getCurrentName();
                if (listName == null) {
                    listName = "listContent";
                }
                VList newList = new VList(this.current, listName);
                this.current = newList;
                break;
            }
            case END_ARRAY: {
                VParent parent;
                if (!this.current.isList()) {
                    this.error("This can not happen, we are no longer working on a list item here. current is " + this.current);
                }
                if ((parent = this.current.parent) != null) {
                    parent.addField(this.current);
                }
                this.current = parent;
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.current.addField(new VField(this.p.currentName(), this.p.getValueAsString(), VField.VType.OBJECT));
                break;
            }
            case VALUE_NULL: {
                this.current.addField(new VField(this.p.currentName(), this.p.getValueAsString(), VField.VType.NULL));
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.current.addField(new VField(this.p.currentName(), this.p.getValueAsString(), VField.VType.BIGDECIMAL));
                break;
            }
            case VALUE_NUMBER_INT: {
                this.current.addField(new VField(this.p.currentName(), this.p.getValueAsString(), VField.VType.INT));
                break;
            }
            case VALUE_STRING: {
                this.current.addField(new VField(this.p.currentName(), this.p.getValueAsString(), VField.VType.STRING));
                break;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                this.current.addField(new VField(this.p.currentName(), this.p.getValueAsString(), VField.VType.BOOLEAN));
                break;
            }
        }
        ++this.tokenCnt;
    }

    public VParent parse(JsonParser parser) {
        this.l("\n\n\n\n ---------------------------- PARSE ------------------------------");
        try {
            this.p = parser;
            JsonToken token = this.p.nextToken();
            if (token.equals((Object)JsonToken.START_ARRAY)) {
                this.root = this.current = new VList(null, "ROOTLIST");
            } else if (token.equals((Object)JsonToken.START_OBJECT)) {
                this.root = this.current = new VObject(null, "ROOT");
            } else {
                this.error("The JackyParser needs a json string start with Array or Object, but it is " + token);
            }
            token = this.p.nextToken();
            while (!this.p.isClosed() && token != null) {
                this.processToken(token);
                token = this.p.nextToken();
            }
            if (this.current != null) {
                this.error("The Json tree was not closed completle. We are at object " + this.current + " now.");
            }
            VParent vParent = this.root;
            return vParent;
        }
        catch (JsonParseException e) {
            String desc = this.current != null ? "last successfully parsed was '" + this.current + "'" : "problems within first element.";
            throw new SerdesException("Can not parse json content - " + desc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (this.p != null) {
                    this.p.close();
                }
            }
            catch (IOException iOException) {}
            this.l("ConvJacksonParser.parse() DONE; processer " + this.tokenCnt + " tokens.");
        }
    }
}

