/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OPPOSITE;
import org.modellwerkstatt.objectflow.sdservices.CField;
import org.modellwerkstatt.objectflow.sdservices.CListField;
import org.modellwerkstatt.objectflow.sdservices.CObjectField;

public class MoWareEntityReflector {
    private Method theListAdderMethodOfListClass;
    private HashMap<String, CObjectField> createdObjectFields = new HashMap();

    public MoWareEntityReflector() {
        try {
            String methodName1 = "add";
            Class<List> listClass = List.class;
            this.theListAdderMethodOfListClass = listClass.getMethod(methodName1, Object.class);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void constructCObjectTree(CObjectField root) {
        try {
            for (Field field : root.typeParameter.getDeclaredFields()) {
                field.setAccessible(true);
                this.addFieldIfRelevant(root, field);
            }
            for (Class superCls = root.typeParameter.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
                for (Field field : superCls.getDeclaredFields()) {
                    field.setAccessible(true);
                    this.addFieldIfRelevant(root, field);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void addFieldIfRelevant(CObjectField root, Field field) throws ClassNotFoundException {
        CField cFld = this.getCTypeWhenOFXRelatedOrNull(root, field);
        if (cFld != null) {
            CListField listFld;
            if (cFld instanceof CObjectField) {
                CObjectField objField = (CObjectField)cFld;
                if (objField.isOrigNotAttached()) {
                    this.constructCObjectTree(objField);
                }
            } else if (cFld instanceof CListField && (listFld = (CListField)cFld).isOrigNotAttached()) {
                this.constructCObjectTree(listFld);
            }
            root.addFieldAndInit(cFld);
        }
    }

    public CObjectField createNewCObjectOrNull(String fieldName, CField.OFXType ofxtype, Class typeParam) {
        CObjectField field;
        if (ofxtype.equals((Object)CField.OFXType.OFX_KEY_REFERENCE)) {
            field = new CObjectField(fieldName, CField.OFXType.OFX_KEY_REFERENCE, typeParam);
        } else if (ofxtype.equals((Object)CField.OFXType.OFX_LIST)) {
            field = new CListField(fieldName, CField.OFXType.OFX_LIST, typeParam);
        } else if (ofxtype.equals((Object)CField.OFXType.OFX_VALUE_OBJ)) {
            field = new CObjectField(fieldName, CField.OFXType.OFX_VALUE_OBJ, typeParam);
        } else {
            throw new RuntimeException("This can not happen. We do not support " + ofxtype);
        }
        String key = typeParam.getName();
        CObjectField existing = this.createdObjectFields.get(key);
        if (existing != null) {
            field.attachFieldsFromOrigObject(existing);
        } else {
            this.createdObjectFields.put(key, field);
        }
        return field;
    }

    private CField getCTypeWhenOFXRelatedOrNull(CObjectField rootOfField, Field f) throws ClassNotFoundException {
        Class<?> cls = f.getType();
        Type type = f.getGenericType();
        Object name = f.getName();
        if (cls == OFXInteger.class) {
            return new CField((String)name, CField.OFXType.OFX_INT, Integer.TYPE);
        }
        if (cls == OFXBigDecimal.class) {
            return new CField((String)name, CField.OFXType.OFX_BIGDECIMAL, BigDecimal.class);
        }
        if (cls == OFXString.class) {
            return new CField((String)name, CField.OFXType.OFX_STRING, String.class);
        }
        if (cls == OFXLocalDate.class) {
            return new CField((String)name, CField.OFXType.OFX_LOCALDATE, LocalDate.class);
        }
        if (cls == OFXDateTime.class) {
            return new CField((String)name, CField.OFXType.OFX_DATETIME, DateTime.class);
        }
        if (cls == OFXStatus.class) {
            ParameterizedType pt = (ParameterizedType)type;
            Class<?> typeParam = Class.forName(pt.getActualTypeArguments()[0].getTypeName());
            return new CField((String)name, CField.OFXType.OFX_STATUS, typeParam);
        }
        if (cls == OFXValueObject.class) {
            ParameterizedType pt = (ParameterizedType)type;
            Class<?> typeParam = Class.forName(pt.getActualTypeArguments()[0].getTypeName());
            return this.createNewCObjectOrNull((String)name, CField.OFXType.OFX_VALUE_OBJ, typeParam);
        }
        if (cls == OFXKeyReference.class) {
            if (f.getAnnotation(OPPOSITE.class) == null) {
                ParameterizedType pt = (ParameterizedType)type;
                Class<?> typeParam = Class.forName(pt.getActualTypeArguments()[1].getTypeName());
                return this.createNewCObjectOrNull((String)name, CField.OFXType.OFX_KEY_REFERENCE, typeParam);
            }
            ParameterizedType pt = (ParameterizedType)type;
            Class<?> typeParam = Class.forName(pt.getActualTypeArguments()[0].getTypeName());
            name = (String)name + "KEY";
            if (typeParam == Integer.class) {
                return new CField((String)name, CField.OFXType.OFX_INT, Integer.class);
            }
            if (typeParam == String.class) {
                return new CField((String)name, CField.OFXType.OFX_STRING, String.class);
            }
            return this.createNewCObjectOrNull((String)name, CField.OFXType.OFX_VALUE_OBJ, typeParam);
        }
        if (cls == OFXList.class) {
            ParameterizedType pt = (ParameterizedType)type;
            Class<?> typeParam = Class.forName(pt.getActualTypeArguments()[0].getTypeName());
            return this.createNewCObjectOrNull((String)name, CField.OFXType.OFX_LIST, typeParam);
        }
        if (cls == OFXVPBase.class) {
            throw new RuntimeException("VirtualProps are not supported for serdes yet.");
        }
        return null;
    }

    public void callListAdder(Object list, Object arg) {
        try {
            this.theListAdderMethodOfListClass.invoke(list, arg);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object statusFromString(Class statusClass, String value) {
        try {
            String methodName = "fromString";
            Method method = statusClass.getMethod(methodName, String.class);
            return method.invoke(null, value);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

