/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.sdservices.BaseSerdes;
import org.modellwerkstatt.objectflow.sdservices.CField;
import org.modellwerkstatt.objectflow.sdservices.CObjectField;
import org.modellwerkstatt.objectflow.sdservices.MoWareEntityReflector;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XmlFieldSerdes<T>
extends BaseSerdes<T> {
    public XmlFieldSerdes(Class<T> cls, IConvFormatOptions frmt) {
        super(cls, frmt);
    }

    protected List filterOnElements(Node node) {
        ArrayList<Element> elementNodes = new ArrayList<Element>();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node cld = node.getChildNodes().item(i);
            if (cld.getNodeType() != 1) continue;
            elementNodes.add((Element)cld);
        }
        return elementNodes;
    }

    protected Node resolveXMLField(List<Node> nodes, CObjectField concept, String name) {
        Node nd;
        int i;
        name = this.formatters.fieldPathToJson(name);
        for (i = 0; i < nodes.size(); ++i) {
            nd = nodes.get(i);
            if (!name.equals(nd.getNodeName())) continue;
            return nd;
        }
        for (i = 0; i < nodes.size(); ++i) {
            nd = nodes.get(i);
            if (!name.toLowerCase().equals(nd.getNodeName().toLowerCase())) continue;
            return nd;
        }
        if (this.formatters.hasMode(IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL)) {
            return null;
        }
        if (this.useCompactingArrays && nodes.size() == 1) {
            return nodes.get(0);
        }
        throw new SerdesException("DTO Field " + concept.name + "." + name + " not found in xml " + nodes);
    }

    protected boolean needsCdata(String st) {
        return st.matches(".*[&<>].*");
    }

    protected void deserField(String fqPath, Object currentInstance, CField fld, Document xmlRootDoc, Node parentElement, Node domElement) {
        Object objToSet = null;
        if (fld.type == CField.OFXType.OFX_STATUS) {
            objToSet = MoWareEntityReflector.statusFromString(fld.typeParameter, domElement != null ? domElement.getTextContent() : null);
        } else if (domElement != null) {
            String nodeTextContent = domElement.getTextContent();
            objToSet = this.valueToObjectByType(nodeTextContent, fld.type);
        }
        fld.set(currentInstance, objToSet);
    }

    protected Element serField(Document rootDocument, String fqPath, CField fld, Object value, boolean compactArray) {
        if (value == null) {
            Element nullElement = rootDocument.createElement(this.formatters.fieldPathToJson(fld.name));
            return nullElement;
        }
        Element elem = rootDocument.createElement(this.formatters.fieldPathToJson(fld.name));
        if (fld.type == CField.OFXType.OFX_INT) {
            Integer integer = (Integer)value;
            elem.setTextContent("" + integer);
        } else if (fld.type == CField.OFXType.OFX_STRING) {
            String strng = (String)value;
            if (this.needsCdata(strng)) {
                elem.appendChild(rootDocument.createCDATASection(strng));
            } else {
                elem.setTextContent(strng);
            }
        } else if (fld.type == CField.OFXType.OFX_LOCALDATE) {
            LocalDate ld = (LocalDate)value;
            elem.setTextContent(this.formatters.printLocalDate(ld));
        } else if (fld.type == CField.OFXType.OFX_DATETIME) {
            DateTime dt = (DateTime)value;
            elem.setTextContent(this.formatters.printDateTime(dt));
        } else if (fld.type == CField.OFXType.OFX_BIGDECIMAL) {
            BigDecimal bd = (BigDecimal)value;
            if (this.formatters.serializeBigDecimalAsString()) {
                elem.setTextContent(this.formatters.printBigDecimal(bd));
            } else {
                elem.setTextContent(this.formatters.printBigDecimal(bd));
            }
        } else if (fld.type == CField.OFXType.OFX_STATUS) {
            boolean hasTwoElements;
            IOFXMetaStatus.IOFXStatusElement statusElem = (IOFXMetaStatus.IOFXStatusElement)value;
            String dbVal = statusElem.getDbValue();
            String dbValLower = dbVal.toLowerCase();
            boolean bl = hasTwoElements = statusElem.getAllStatusElements().length == 2;
            if (hasTwoElements && "true".equals(dbValLower)) {
                elem.setTextContent("true");
            } else if (hasTwoElements && "false".equals(dbValLower)) {
                elem.setTextContent("false");
            } else {
                elem.setTextContent(dbVal);
            }
        } else {
            throw new RuntimeException("This can not happen. Unknown type " + fld.type);
        }
        return elem;
    }
}

