/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import java.lang.reflect.Array;
import java.util.List;
import org.modellwerkstatt.objectflow.sdservices.CField;
import org.modellwerkstatt.objectflow.sdservices.CListField;
import org.modellwerkstatt.objectflow.sdservices.CObjectField;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.modellwerkstatt.objectflow.sdservices.XmlFieldSerdes;
import org.modellwerkstatt.objectflow.sdservices.XmlInfra;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlGraphSerdes<T>
extends XmlFieldSerdes<T>
implements IConvSerdes<T> {
    private XmlInfra infra;

    public XmlGraphSerdes(Class<T> cls, IConvFormatOptions frmt) {
        this(cls, frmt, new XmlInfra());
        this.infra.init();
    }

    public XmlGraphSerdes(Class<T> cls, IConvFormatOptions frmt, XmlInfra aInfra) {
        super(cls, frmt);
        this.infra = aInfra;
    }

    protected void deserObject(String basePath, Object currentInstance, CObjectField objConcept, Document xmlRootDoc, Node domObject) {
        List domObjectContent = this.filterOnElements(domObject);
        if (objConcept.type == CField.OFXType.OFX_VALUE_OBJ && domObjectContent.size() > 1) {
            Object resultInstance = this.deserToObject(basePath, objConcept, xmlRootDoc, domObject);
            objConcept.set(currentInstance, resultInstance);
        } else if (domObjectContent.size() == 1) {
            Object resultInstance = this.deserToObject(basePath, objConcept, xmlRootDoc, (Node)domObjectContent.get(0));
            objConcept.set(currentInstance, resultInstance);
        } else if (domObjectContent.size() == 0) {
            objConcept.set(currentInstance, null);
        } else {
            throw new SerdesException("Expected an object for field " + objConcept.name + " but found in xml:\n" + this.infra.DEBUG_DOMNODE(domObject));
        }
    }

    protected void deserList(String basePath, Object currentInstance, CListField listConcept, Document xmlRootDoc, Node domListItem) {
        List domListItemContent = this.filterOnElements(domListItem);
        if (domListItem != null && domListItemContent.size() != 0) {
            Object listObject = listConcept.get(currentInstance);
            String path = basePath + "." + listConcept.name;
            for (int i = 0; i < domListItemContent.size(); ++i) {
                Node domObject = (Node)domListItemContent.get(i);
                Object resultInstance = this.deserToObject(path, listConcept, xmlRootDoc, domObject);
                this.reflector.callListAdder(listObject, resultInstance);
            }
        }
    }

    protected <OBJTYPE> OBJTYPE deserToObject(String basePath, CObjectField curConcept, Document xmlRootDoc, Node domNode) {
        Object currentInstance = curConcept.newInstance();
        List domCurrentElems = this.filterOnElements(domNode);
        if (this.formatters.hasMode(IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY) && curConcept.fields.size() != domCurrentElems.size()) {
            throw new SerdesException("Mode is " + IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY + " but number of fields in " + curConcept + " (" + curConcept.fields.size() + ") do not match " + domNode.getNodeName() + " (" + domCurrentElems.size() + ").");
        }
        for (CField trgt : curConcept.fields) {
            String fqPath = basePath + "." + trgt.name;
            if (trgt instanceof CListField) {
                CListField listField = (CListField)trgt;
                Node domListItem = this.resolveXMLField(domCurrentElems, curConcept, listField.name);
                this.deserList(fqPath, currentInstance, listField, xmlRootDoc, domListItem);
                continue;
            }
            if (trgt instanceof CObjectField) {
                CObjectField objField = (CObjectField)trgt;
                Node domObject = this.resolveXMLField(domCurrentElems, curConcept, objField.name);
                this.deserObject(fqPath, currentInstance, objField, xmlRootDoc, domObject);
                continue;
            }
            CField fldConcept = trgt;
            Node domElement = this.resolveXMLField(domCurrentElems, curConcept, fldConcept.name);
            this.deserField(fqPath, currentInstance, fldConcept, xmlRootDoc, domNode, domElement);
        }
        return (OBJTYPE)currentInstance;
    }

    protected T deserRootObject(Document xmlRootDoc) {
        List rootDocElements = this.filterOnElements(xmlRootDoc);
        if (rootDocElements.size() != 1) {
            throw new SerdesException("Expected one root object in xml to deserialize, but found " + rootDocElements.size() + ".\n" + this.infra.DEBUG_DOMNODE(xmlRootDoc));
        }
        return (T)this.deserToObject("ROOT", this.objTreeMeta, xmlRootDoc, (Node)rootDocElements.get(0));
    }

    protected T deserRootList(Document xmlRootDoc) {
        List rootDocElements = this.filterOnElements(xmlRootDoc);
        if (rootDocElements.size() != 1) {
            throw new SerdesException("Expected list in one root object in xml to deserialize, but found " + rootDocElements.size() + ".\n" + this.infra.DEBUG_DOMNODE(xmlRootDoc));
        }
        Node rootList = (Node)rootDocElements.get(0);
        List listOfObjs = this.filterOnElements(rootList);
        int arrayLength = listOfObjs.size();
        Object ar = Array.newInstance(this.rootClass, arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            Node domObj = (Node)listOfObjs.get(i);
            Object item = this.deserToObject("ROOT", this.objTreeMeta, xmlRootDoc, domObj);
            Array.set(ar, i, item);
        }
        return (T)ar;
    }

    @Override
    public T deser(String st) {
        Document xmlRootDoc = this.infra.parseDoc(st);
        if (this.formatters.hasMode(IConvFormatOptions.Mode.DEBUG_TO_STDERR)) {
            JackyInfra.printDebugObject("", this.objTreeMeta);
        }
        if (this.arraySerdes) {
            return this.deserRootList(xmlRootDoc);
        }
        return this.deserRootObject(xmlRootDoc);
    }

    protected void serObject(Document xmlRootDoc, String fqPath, Element curXmlElem, CObjectField objConcept, Object dtoOfProp, boolean compactThis) {
        Element elm = xmlRootDoc.createElement(this.formatters.fieldPathToJson(objConcept.name));
        if (dtoOfProp != null) {
            Element obj = xmlRootDoc.createElement(objConcept.getTypeShortName());
            this.serDispatchFields(xmlRootDoc, fqPath, obj, objConcept, dtoOfProp, compactThis);
            elm.appendChild(obj);
        }
        curXmlElem.appendChild(elm);
    }

    protected void serList(Document xmlRootDoc, String fqPath, Element curXmlElem, CListField listConcept, List listOfObject, boolean compactThis) {
        Element elm = xmlRootDoc.createElement(this.formatters.fieldPathToJson(listConcept.name));
        if (listOfObject != null) {
            boolean toCompact = this.useCompactingArrays && listConcept.fields.size() == 1;
            for (Object listItem : listOfObject) {
                if (!toCompact) {
                    Element obj = xmlRootDoc.createElement(listConcept.getTypeShortName());
                    this.serDispatchFields(xmlRootDoc, fqPath, obj, listConcept, listItem, toCompact);
                    elm.appendChild(obj);
                    continue;
                }
                this.serDispatchFields(xmlRootDoc, fqPath, elm, listConcept, listItem, toCompact);
            }
        }
        curXmlElem.appendChild(elm);
    }

    protected void serDispatchFields(Document xmlRootDoc, String parentPath, Element curXmlElem, CObjectField curConcept, Object dto, boolean compactThis) {
        for (CField trgt : curConcept.fields) {
            String fqPath = parentPath + "." + trgt.name;
            if (trgt instanceof CListField) {
                CListField listField = (CListField)trgt;
                List listObject = (List)listField.get(dto);
                this.serList(xmlRootDoc, fqPath, curXmlElem, listField, listObject, compactThis);
                continue;
            }
            if (trgt instanceof CObjectField) {
                CObjectField objField = (CObjectField)trgt;
                Object dtoOfProperty = objField.get(dto);
                this.serObject(xmlRootDoc, fqPath, curXmlElem, objField, dtoOfProperty, compactThis);
                continue;
            }
            CField fldConcept = trgt;
            Object fieldValue = fldConcept.get(dto);
            Element elm = this.serField(xmlRootDoc, fqPath, fldConcept, fieldValue, compactThis);
            curXmlElem.appendChild(elm);
        }
    }

    protected void serRootObject(Document xmlRootDoc, Object graph) {
        Element obj = xmlRootDoc.createElement(this.formatters.fieldPathToJson(this.objTreeMeta.getTypeShortName()));
        this.serDispatchFields(xmlRootDoc, "ROOT", obj, this.objTreeMeta, graph, false);
        xmlRootDoc.appendChild(obj);
    }

    protected void serRootList(Document xmlRootDoc, Object graph) {
        Element listElem = xmlRootDoc.createElement(this.formatters.fieldPathToJson(this.objTreeMeta.getTypeShortName() + "List"));
        int arrayLength = Array.getLength(graph);
        boolean toCompact = this.useCompactingArrays && this.objTreeMeta.fields.size() == 1;
        for (int i = 0; i < arrayLength; ++i) {
            Object item = Array.get(graph, i);
            if (!toCompact) {
                Element obj = xmlRootDoc.createElement(this.formatters.fieldPathToJson(this.objTreeMeta.getTypeShortName()));
                this.serDispatchFields(xmlRootDoc, "ROOT", obj, this.objTreeMeta, item, toCompact);
                listElem.appendChild(obj);
                continue;
            }
            this.serDispatchFields(xmlRootDoc, "ROOT", listElem, this.objTreeMeta, item, toCompact);
        }
        xmlRootDoc.appendChild(listElem);
    }

    @Override
    public String ser(T graph) {
        Document xmlRootDoc = null;
        if (this.formatters.hasMode(IConvFormatOptions.Mode.DEBUG_TO_STDERR)) {
            JackyInfra.printDebugObject("", this.objTreeMeta);
        }
        xmlRootDoc = this.infra.newRootDoc();
        if (!this.arraySerdes) {
            this.serRootObject(xmlRootDoc, graph);
        } else {
            this.serRootList(xmlRootDoc, graph);
        }
        String result = this.infra.writeXml(xmlRootDoc);
        return result;
    }
}

