/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.services;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IMoLdapService;

public class DeprMoLdapService
implements IMoLdapService {
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String DEFAULT_SECURITY_AUTHENTICATION = "Simple";
    private String initialBindSearchbase;
    private String initialBindPrincipal;
    private String initialBindPrincipalPassword;
    private String ldapServerAddress;
    private boolean useSsl = false;

    public DeprMoLdapService(String server, String principal, String pwd, String searchbase) {
        this.ldapServerAddress = server;
        this.initialBindPrincipal = principal;
        this.initialBindPrincipalPassword = pwd;
        this.initialBindSearchbase = searchbase;
    }

    public DeprMoLdapService(String server, String principal, String pwd, String searchbase, boolean aUseSsl) {
        this(server, principal, pwd, searchbase);
        this.useSsl = aUseSsl;
    }

    @Override
    public void setBindUserPassword(String pwd) {
        this.initialBindPrincipalPassword = pwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticateUser(String username, String pwd) {
        LdapContext bindContext = null;
        boolean usernamePwdOk = false;
        String distinguishedName = null;
        if (pwd == null || "".equals(pwd)) {
            return false;
        }
        try {
            bindContext = this.getContextToUserPwd(this.initialBindPrincipal, this.initialBindPrincipalPassword);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            String[] attrIDs = new String[]{"distinguishedName", "sn", "givenname"};
            constraints.setReturningAttributes(attrIDs);
            NamingEnumeration<SearchResult> answer = bindContext.search(this.initialBindSearchbase, "sAMAccountName=" + username, constraints);
            if (answer.hasMore()) {
                Attributes attrs = answer.next().getAttributes();
                distinguishedName = (String)attrs.get("distinguishedName").get();
            }
            if (answer.hasMore()) {
                throw new RuntimeException("More then one distinguishedName for sAMAccountName " + username + " retrieved, contact directory admin.");
            }
            this.closeIfNotNull(bindContext);
        }
        catch (NamingException nex) {
            try {
                throw new RuntimeException("Ldap Bind: Connection failed", nex);
            }
            catch (Throwable throwable) {
                this.closeIfNotNull(bindContext);
                throw throwable;
            }
        }
        if (distinguishedName != null) {
            LdapContext userContext = null;
            try {
                userContext = this.getContextToUserPwd(distinguishedName, pwd);
                usernamePwdOk = true;
            }
            catch (NamingException namingException) {
            }
            finally {
                this.closeIfNotNull(userContext);
            }
        }
        return usernamePwdOk;
    }

    @Override
    public List<IMoLdapService.ICnInfo> getGroupsOfUser(String username) {
        LdapContext bindContext = null;
        Object distinguishedName = null;
        IListSequence groupInfo = ListSequence.fromList(new ArrayList());
        try {
            Attributes attrs;
            Attribute memberOf;
            bindContext = this.getContextToUserPwd(this.initialBindPrincipal, this.initialBindPrincipalPassword);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            String[] attrIDs = new String[]{"distinguishedName", "sn", "givenname", "memberOf"};
            constraints.setReturningAttributes(attrIDs);
            NamingEnumeration<SearchResult> answer = bindContext.search(this.initialBindSearchbase, "sAMAccountName=" + username, constraints);
            if (answer.hasMore() && (memberOf = (attrs = answer.next().getAttributes()).get("memberOf")) != null) {
                NamingEnumeration<?> e1 = memberOf.getAll();
                while (e1.hasMoreElements()) {
                    ListSequence.fromList((List)groupInfo).addElement((Object)this.processGroupInformation(e1.nextElement().toString()));
                }
            }
            if (answer.hasMore()) {
                throw new RuntimeException("More then one distinguishedName for sAMAccountName " + username + " retrieved, contact directory admin.");
            }
            this.closeIfNotNull(bindContext);
        }
        catch (NamingException nex) {
            try {
                throw new RuntimeException("Ldap Bind: Connection failed", nex);
            }
            catch (Throwable throwable) {
                this.closeIfNotNull(bindContext);
                throw throwable;
            }
        }
        return groupInfo;
    }

    @Override
    public List<IMoLdapService.ICnInfo> getGroupsOfCommonName(String searchBase, String commonName) {
        LdapContext bindContext = null;
        Object distinguishedName = null;
        IListSequence groupInfo = ListSequence.fromList(new ArrayList());
        try {
            Attributes attrs;
            Attribute memberOf;
            bindContext = this.getContextToUserPwd(this.initialBindPrincipal, this.initialBindPrincipalPassword);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            String[] attrIDs = new String[]{"distinguishedName", "sn", "memberOf"};
            constraints.setReturningAttributes(attrIDs);
            NamingEnumeration<SearchResult> answer = bindContext.search(searchBase, "cn=" + commonName, constraints);
            if (answer.hasMore() && (memberOf = (attrs = answer.next().getAttributes()).get("memberOf")) != null) {
                NamingEnumeration<?> e1 = memberOf.getAll();
                while (e1.hasMoreElements()) {
                    ListSequence.fromList((List)groupInfo).addElement((Object)this.processGroupInformation(e1.nextElement().toString()));
                }
            }
            if (answer.hasMore()) {
                throw new RuntimeException("More then one entry for commonName " + commonName + " retrieved, contact directory admin.");
            }
            this.closeIfNotNull(bindContext);
        }
        catch (NamingException nex) {
            try {
                throw new RuntimeException("Ldap Bind: Connection failed", nex);
            }
            catch (Throwable throwable) {
                this.closeIfNotNull(bindContext);
                throw throwable;
            }
        }
        return groupInfo;
    }

    private GroupInformation processGroupInformation(String rawInfo) {
        GroupInformation info = new GroupInformation(rawInfo, this.getCommonName(rawInfo));
        return info;
    }

    private String getCommonName(String cnName) {
        int position;
        if (cnName != null && cnName.toUpperCase().startsWith("CN=")) {
            cnName = cnName.substring(3);
        }
        if ((position = cnName.indexOf(44)) == -1) {
            return cnName;
        }
        return cnName.substring(0, position);
    }

    private void closeIfNotNull(LdapContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException ex) {
                throw new RuntimeException("LdapContext : Error while closing context", ex);
            }
        }
    }

    public LdapContext getContextToUserPwd(String distuingishedName, String pwd) throws NamingException {
        Hashtable<String, String> userEnv = new Hashtable<String, String>();
        userEnv = new Hashtable();
        userEnv.put("java.naming.factory.initial", DEFAULT_INITIAL_CONTEXT_FACTORY);
        userEnv.put("java.naming.security.authentication", DEFAULT_SECURITY_AUTHENTICATION);
        userEnv.put("java.naming.security.principal", distuingishedName);
        userEnv.put("java.naming.security.credentials", pwd);
        userEnv.put("java.naming.provider.url", this.ldapServerAddress);
        if (this.useSsl) {
            userEnv.put("java.naming.security.protocol", "ssl");
        }
        return new InitialLdapContext(userEnv, null);
    }

    @Override
    public List<IMoLdapService.ICnInfo> getNamesToAttrAndCommonName(String searchBase, String attr, String commonName) {
        throw new RuntimeException("Not implemented.");
    }

    public static class GroupInformation
    implements IMoLdapService.ICnInfo {
        private String unprocessedName;
        private String processedName;

        public GroupInformation(String unprocessed, String processed) {
            this.unprocessedName = unprocessed;
            this.processedName = processed;
        }

        @Override
        public String getProcessedName() {
            return this.processedName;
        }

        @Override
        public String getUnprocessedName() {
            return this.unprocessedName;
        }
    }
}

