/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.testsuit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class MoTestSuitHandler
implements IOFXTestSuit.IOFXTestSuitHandler {
    private int testsPassed = 0;
    private int testsDone = 0;
    private boolean instantiateNew = true;
    private StringBuilder reportLines;
    private Map<String, IOFXTestSuit> testSuit = MapSequence.fromMap(new HashMap());

    public MoTestSuitHandler() {
        this.reportLines = new StringBuilder();
    }

    @Override
    public IOFXTestSuit getOrCreateTestSuit(String fqName) {
        if (MapSequence.fromMap(this.testSuit).get((Object)fqName) != null) {
            return (IOFXTestSuit)MapSequence.fromMap(this.testSuit).get((Object)fqName);
        }
        if (!this.instantiateNew) {
            throw new RuntimeException("Test " + fqName + " requested but not initialized in this setup (possibly a moware bug?)");
        }
        try {
            Class<?> testSuitClass = Class.forName(fqName);
            MapSequence.fromMap(this.testSuit).put((Object)fqName, (Object)((IOFXTestSuit)OFXConsoleHelper.createBean(testSuitClass)));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can not retrieve Class for test " + fqName, e);
        }
        return (IOFXTestSuit)MapSequence.fromMap(this.testSuit).get((Object)fqName);
    }

    @Override
    public void testSuitCreateInitDone() {
        this.instantiateNew = false;
    }

    @Override
    public void startingTest() {
        ++this.testsDone;
    }

    @Override
    public void testDone(IOFXSession __manMapSession, String testsuitFqName, String testName, boolean passed) {
        if (passed) {
            String msg = "* * * * * PASSED " + testName + " * * * * * \n";
            this.reportLines.append(msg + "\n");
            __manMapSession.getUserServices().logOnCoreReporter("", "", testsuitFqName, IOFXCoreReporter.LogPriority.INFO, msg, null);
            ++this.testsPassed;
        }
    }

    @Override
    public void logError(IOFXSession __manMapSession, String testsuitFqName, String testName, Throwable t) {
        String msg = t.getClass().getName() + ": " + t.getMessage() + "\n";
        msg = msg + this.getSessionProblemInfo(__manMapSession);
        msg = msg + "\n\n" + OFXConsoleHelper.stackTrace2String(t);
        msg = "\n   " + msg.replace("\n", "\n     ");
        String s = "! ! ! ! ! NOT PASSED " + testName + "\n  " + msg + "\n\n";
        this.reportLines.append(s);
        __manMapSession.getUserServices().logOnCoreReporter("", "", testsuitFqName, IOFXCoreReporter.LogPriority.FATAL, s, null);
    }

    @Override
    public void logError(IOFXSession __manMapSession, String testFqName, String testName, String st) {
        String s = "! ! ! ! ! NOT PASSED " + testName + "\n  " + st + "\n\n";
        s = s + this.getSessionProblemInfo(__manMapSession);
        this.reportLines.append(s);
        __manMapSession.getUserServices().logOnCoreReporter("", "", testFqName, IOFXCoreReporter.LogPriority.FATAL, s, null);
    }

    @Override
    public void print(IOFXSession __manMapSession, String testFqName, String msg) {
        __manMapSession.getUserServices().logOnCoreReporter("", "", testFqName, IOFXCoreReporter.LogPriority.INFO, msg, null);
    }

    @Override
    public void breakLine(IOFXSession __manMapSession, String testFqName, String testName) {
        __manMapSession.getUserServices().logOnCoreReporter("", "", testFqName, IOFXCoreReporter.LogPriority.INFO, "\n\n- - - - - - - - - " + testName + " - - - - - - - - -", null);
    }

    @Override
    public void debug(IOFXSession __manMapSession, String testFqName, String msg) {
        __manMapSession.getUserServices().logOnCoreReporter("", "", testFqName, IOFXCoreReporter.LogPriority.INFO, msg, null);
    }

    public String getSessionProblemInfo(IOFXSession __manMapSession) {
        List<IOFXProblem> problems = __manMapSession.getAndclearProblemState();
        StringBuilder infos = new StringBuilder();
        for (IOFXProblem problm : problems) {
            infos.append("\nPROBLEM > " + problm.getSimpleUserText());
        }
        return infos.toString();
    }

    @Override
    public boolean allTestsPassed() {
        return this.testsPassed != 0 && this.testsPassed == this.testsDone;
    }

    @Override
    public String summary() {
        StringBuilder b = new StringBuilder();
        b.append("\n\n");
        if (this.allTestsPassed()) {
            b.append("\n\n");
            b.append("+ + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + \n");
            b.append("     _    _ _   _            _                                      _ _ \n");
            b.append("    / \\  | | | | |_ ___  ___| |_ ___   _ __   __ _ ___ ___  ___  __| | |\n");
            b.append("   / _ \\ | | | | __/ _ \\/ __| __/ __| | '_ \\ / _` / __/ __|/ _ \\/ _` | |\n");
            b.append("  / ___ \\| | | | ||  __/\\__ \\ |_\\__ \\ | |_) | (_| \\__ \\__ \\  __/ (_| |_|\n");
            b.append(" /_/   \\_\\_|_|  \\__\\___||___/\\__|___/ | .__/ \\__,_|___/___/\\___|\\__,_(_)\n");
            b.append("                                      |_|                               \n");
            b.append(" " + this.testsPassed + " out of " + this.testsDone + " in total \n");
        } else {
            b.append("\n\n");
            b.append("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - \n");
            b.append("- - - - -    In TOTAL " + this.testsPassed + " of " + this.testsDone + " were PASSED.\n");
            b.append("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - \n");
        }
        return b.toString();
    }
}

