/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.conventions;

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.model.SNode;
import org.modellwerkstatt.manmap.behavior.L2RTComponentCall__BehaviorDescriptor;

public class L2RuntimeDefinitions {
    private static final String IOFXPLATFORM_TO_ADD = "org.modellwerkstatt.objectflow.runtime.IOFXPlatform";
    private static final String IOFXTRANSLATOR_TO_ADD = "org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider";

    public static List<String> calcL2RTRequirementsInComponent(SNode aComponent) {
        List calls = SNodeOperations.getNodeDescendants((SNode)aComponent, (SAbstractConcept)CONCEPTS.L2RTComponentCall$gr, (boolean)false, (SAbstractConcept[])new SAbstractConcept[0]);
        List components = ListSequence.fromList((List)calls).select(it -> (String)L2RTComponentCall__BehaviorDescriptor.getRtComponentFQName_id4Wj1gYKHbnw.invoke(it, new Object[0])).where(it -> !it.equals(INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(aComponent, new Object[0]))).toList();
        ListSequence.fromList((List)components).addElement((Object)IOFXPLATFORM_TO_ADD);
        ListSequence.fromList((List)components).addElement((Object)IOFXTRANSLATOR_TO_ADD);
        return ListSequence.fromList((List)components).distinct().toList();
    }

    public static boolean isPlatformOrTransProvider(String st) {
        return IOFXPLATFORM_TO_ADD.equals(st) || IOFXTRANSLATOR_TO_ADD.equals(st);
    }

    public static String getInstanceNameFromFQName(String fqName) {
        int namePoint = fqName.lastIndexOf(".");
        Object resulting = fqName.substring(namePoint + 1);
        if (namePoint > 0) {
            String packageStr = fqName.substring(0, namePoint);
            int packagePoint = packageStr.lastIndexOf(".");
            resulting = packageStr.substring(packagePoint + 1) + ((String)resulting).substring(0, 1).toUpperCase() + ((String)resulting).substring(1);
        }
        return "__" + (String)resulting;
    }

    public static String depLegacyNaming(String fqName) {
        String name = fqName.replace(".", "_");
        String shortName = name.substring(0, 1).toLowerCase() + name.substring(1);
        return "__" + shortName.replaceAll("\\s", "_");
    }

    public static void main(String[] args) {
        String fq = "org.mytest.dan.man";
        String fq2 = "dan.man";
        String fq3 = "man";
        System.err.println("> " + L2RuntimeDefinitions.getInstanceNameFromFQName(fq));
        System.err.println("> " + L2RuntimeDefinitions.getInstanceNameFromFQName(fq2));
        System.err.println("> " + L2RuntimeDefinitions.getInstanceNameFromFQName(fq3));
    }

    private static final class CONCEPTS {
        static final SInterfaceConcept L2RTComponentCall$gr = MetaAdapterFactory.getInterfaceConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)6016457422555514873L, (String)"org.modellwerkstatt.manmap.structure.L2RTComponentCall");

        private CONCEPTS() {
        }
    }
}

