/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.conventions;

import java.util.List;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.model.SNode;
import org.modellwerkstatt.manmap.behavior.IAtomMapping__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.ISizeSpecified__BehaviorDescriptor;
import org.modellwerkstatt.manmap.conventions.ISqlTableDescriberVendor;

public class OracleVendor
implements ISqlTableDescriberVendor {
    @Override
    public String createTable(String tblName) {
        return "CREATE TABLE " + tblName;
    }

    @Override
    public String createNumber(SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
        String st = fldName + " NUMBER ";
        if (sizeOpt != null) {
            st = st + " (" + (Integer)ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt, new Object[0]) + ", " + (Integer)ISizeSpecified__BehaviorDescriptor.getDecValue_id7K21hvEcg2G.invoke(sizeOpt, new Object[0]) + ") ";
        } else if (((Boolean)IAtomMapping__BehaviorDescriptor.isInteger_id7kypvuI$E7P.invoke(SNodeOperations.asSConcept((SAbstractConcept)CONCEPTS.IAtomMapping$dv), new Object[]{SLinkOperations.getTarget((SNode)SLinkOperations.getTarget((SNode)fldMap, (SReferenceLink)LINKS.property$JxuR), (SContainmentLink)LINKS.type$56v0)})).booleanValue()) {
            st = st + " (9) ";
        } else if (((Boolean)IAtomMapping__BehaviorDescriptor.isBigDecimal_id7kypvuI$E9r.invoke(SNodeOperations.asSConcept((SAbstractConcept)CONCEPTS.IAtomMapping$dv), new Object[]{SLinkOperations.getTarget((SNode)SLinkOperations.getTarget((SNode)fldMap, (SReferenceLink)LINKS.property$JxuR), (SContainmentLink)LINKS.type$56v0)})).booleanValue()) {
            st = st + " (13, 4) ";
        } else {
            throw new RuntimeException("This can not happen.");
        }
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String createVarchar(SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
        String st = fldName + " VARCHAR2 ";
        st = sizeOpt != null ? st + " (" + (Integer)ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt, new Object[0]) + " CHAR) " : ((Boolean)IAtomMapping__BehaviorDescriptor.isStatus_id3wMahqxhMld.invoke(SNodeOperations.asSConcept((SAbstractConcept)CONCEPTS.IAtomMapping$dv), new Object[]{SLinkOperations.getTarget((SNode)SLinkOperations.getTarget((SNode)fldMap, (SReferenceLink)LINKS.property$JxuR), (SContainmentLink)LINKS.type$56v0)}) != false ? st + " (5 CHAR) " : st + " (50 CHAR) ");
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String createBlob(SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
        String st = fldName + " BLOB ";
        if (sizeOpt != null) {
            throw new RuntimeException("Oracle Blob fields do not support any size!");
        }
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String createLocalDate(SNode fldMap, String fldName, boolean notNull) {
        String st = fldName + " DATE ";
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String createDateTime(SNode fldMap, String fldName, boolean notNull) {
        String st = fldName + " DATE ";
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String createTCN() {
        return "TCN NUMBER (9) NOT NULL   /* entity version */";
    }

    @Override
    public String createSequence(String name) {
        return "CREATE SEQUENCE " + name + " START WITH 1 MINVALUE 1 MAXVALUE 999999999 NOCYCLE CACHE 20 ORDER;\n";
    }

    @Override
    public String createAutoIncrement(String tableName, String fieldName) {
        return "";
    }

    @Override
    public String createUniqueConstraint(String name, List<SNode> fields) {
        String concat = IterableUtils.join((Iterable)ListSequence.fromList(fields).select(it -> SPropertyOperations.getString((SNode)SLinkOperations.getTarget((SNode)it, (SContainmentLink)LINKS.fieldName$un98), (SProperty)PROPS.value$w7MM)), (String)", ");
        return "CONSTRAINT " + name + " UNIQUE (" + concat + ")";
    }

    @Override
    public String createPrimKeyConstraint(String name, List<SNode> fields) {
        String concat = IterableUtils.join((Iterable)ListSequence.fromList(fields).select(it -> SPropertyOperations.getString((SNode)SLinkOperations.getTarget((SNode)it, (SContainmentLink)LINKS.fieldName$un98), (SProperty)PROPS.value$w7MM)), (String)", ");
        return "CONSTRAINT " + name + " PRIMARY KEY (" + concat + ")";
    }

    @Override
    public String alterNumber(String tblName, String afterCol, SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
        String st = "ALTER TABLE " + tblName + " ADD " + fldName + " NUMBER ";
        if (sizeOpt != null) {
            st = st + " (" + (Integer)ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt, new Object[0]) + ", " + (Integer)ISizeSpecified__BehaviorDescriptor.getDecValue_id7K21hvEcg2G.invoke(sizeOpt, new Object[0]) + ") ";
        } else if (((Boolean)IAtomMapping__BehaviorDescriptor.isInteger_id7kypvuI$E7P.invoke(SNodeOperations.asSConcept((SAbstractConcept)CONCEPTS.IAtomMapping$dv), new Object[]{SLinkOperations.getTarget((SNode)SLinkOperations.getTarget((SNode)fldMap, (SReferenceLink)LINKS.property$JxuR), (SContainmentLink)LINKS.type$56v0)})).booleanValue()) {
            st = st + " (9) ";
        } else if (((Boolean)IAtomMapping__BehaviorDescriptor.isBigDecimal_id7kypvuI$E9r.invoke(SNodeOperations.asSConcept((SAbstractConcept)CONCEPTS.IAtomMapping$dv), new Object[]{SLinkOperations.getTarget((SNode)SLinkOperations.getTarget((SNode)fldMap, (SReferenceLink)LINKS.property$JxuR), (SContainmentLink)LINKS.type$56v0)})).booleanValue()) {
            st = st + " (13, 4) ";
        } else {
            throw new RuntimeException("This can not happen.");
        }
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String alterVarchar(String tblName, String afterCol, SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
        String st = "ALTER TABLE " + tblName + " ADD " + fldName + " VARCHAR2 ";
        st = sizeOpt != null ? st + " (" + (Integer)ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt, new Object[0]) + " CHAR) " : ((Boolean)IAtomMapping__BehaviorDescriptor.isStatus_id3wMahqxhMld.invoke(SNodeOperations.asSConcept((SAbstractConcept)CONCEPTS.IAtomMapping$dv), new Object[]{SLinkOperations.getTarget((SNode)SLinkOperations.getTarget((SNode)fldMap, (SReferenceLink)LINKS.property$JxuR), (SContainmentLink)LINKS.type$56v0)}) != false ? st + " (5 CHAR) " : st + " (50 CHAR) ");
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String alterBlob(String tblName, String afterCol, SNode fldMap, String fldName, SNode sizeOpt, boolean notNull) {
        String st = "ALTER TABLE " + tblName + " ADD " + fldName + " BLOB ";
        st = sizeOpt != null ? st + " (" + (Integer)ISizeSpecified__BehaviorDescriptor.getValue_id7K21hvEcg1K.invoke(sizeOpt, new Object[0]) + ") " : st + " (1M) ";
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String alterLocalDate(String tblName, String afterCol, SNode fldMap, String fldName, boolean notNull) {
        String st = "ALTER TABLE " + tblName + " ADD " + fldName + " DATE ";
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String alterDateTime(String tblName, String afterCol, SNode fldMap, String fldName, boolean notNull) {
        String st = "ALTER TABLE " + tblName + " ADD " + fldName + " DATE ";
        if (notNull) {
            st = st + " NOT NULL ";
        }
        return st;
    }

    @Override
    public String alterTCN(String tblName, String afterCol) {
        return "ALTER TABLE " + tblName + " ADD TCN NUMBER (9) NOT NULL";
    }

    private static final class CONCEPTS {
        static final SInterfaceConcept IAtomMapping$dv = MetaAdapterFactory.getInterfaceConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900244163L, (String)"org.modellwerkstatt.manmap.structure.IAtomMapping");

        private CONCEPTS() {
        }
    }

    private static final class LINKS {
        static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209251L, (long)871579071900248751L, (String)"property");
        static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1201370618622L, (long)1201371521209L, (String)"type");
        static final SContainmentLink fieldName$un98 = MetaAdapterFactory.getContainmentLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209251L, (long)871579071900290535L, (String)"fieldName");

        private LINKS() {
        }
    }

    private static final class PROPS {
        static final SProperty value$w7MM = MetaAdapterFactory.getProperty((long)-935030926396207931L, (long)-6610165693999523818L, (long)1070475926800L, (long)1070475926801L, (String)"value");

        private PROPS() {
        }
    }
}

