/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.util.SQLDescTableParser;

public class DbDescribeToEntity_Action
extends BaseAction {
    private static final Icon ICON = null;

    public DbDescribeToEntity_Action() {
        super("Werkbank - Create Entity / Mapping from DESC", "Entity from SQL desc table", ICON);
        this.setIsAlwaysVisible(true);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Frame p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        if (p == null) {
            return false;
        }
        p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        if (p == null) {
            return false;
        }
        SNode sNode = (SNode)event.getData(MPSCommonDataKeys.NODE);
        return true;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        SNode persistanceDescription = (SNode)event.getData(MPSCommonDataKeys.NODE);
        if (persistanceDescription == null || !SNodeOperations.isInstanceOf((SNode)persistanceDescription, (SAbstractConcept)CONCEPTS.PersistenceDescription$pP)) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "Selected a 'persistance description' where EntityMapping should be put in . . .", "Wrong selection in project explorer", 0);
            return;
        }
        CopyPasteDialog dialog = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Paste SQL here...");
        dialog.showDialog();
        SModel mod = SNodeOperations.getModel((SNode)persistanceDescription);
        if (dialog.isOkay()) {
            String content = dialog.myText.getText().toString();
            SNode createdBusinessObject = SNodeFactoryOperations.createNewRootNode((SModel)mod, (SAbstractConcept)CONCEPTS.Entity$WP, null);
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)createdBusinessObject, (SContainmentLink)LINKS.businessProperties$cI4J)).clear();
            SNode entityMapping = SNodeFactoryOperations.addNewChild((SNode)SNodeOperations.cast((SNode)persistanceDescription, (SAbstractConcept)CONCEPTS.PersistenceDescription$pP), (SContainmentLink)LINKS.persistenceMapping$S18_, (SAbstractConcept)CONCEPTS.EntityMapping$ux);
            try {
                SQLDescTableParser parser = new SQLDescTableParser(content);
                parser.parse(createdBusinessObject, entityMapping);
            }
            catch (Exception e) {
                e.printStackTrace();
                SNodeOperations.deleteNode((SNode)createdBusinessObject);
                SNodeOperations.deleteNode((SNode)entityMapping);
                JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), e.getMessage(), "Problem while parsing ... ", 0);
            }
        }
    }

    private static final class CONCEPTS {
        static final SConcept PersistenceDescription$pP = MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900124823L, (String)"org.modellwerkstatt.manmap.structure.PersistenceDescription");
        static final SConcept Entity$WP = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)1372017518093514468L, (String)"org.modellwerkstatt.objectflow.structure.Entity");
        static final SConcept EntityMapping$ux = MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900209258L, (String)"org.modellwerkstatt.manmap.structure.EntityMapping");

        private CONCEPTS() {
        }
    }

    private static final class LINKS {
        static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4313579457188683399L, (long)3207218222495905601L, (String)"businessProperties");
        static final SContainmentLink persistenceMapping$S18_ = MetaAdapterFactory.getContainmentLink((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900124823L, (long)871579071900209328L, (String)"persistenceMapping");

        private LINKS() {
        }
    }
}

