/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class ExportProjectStatiToDB_Action
extends BaseAction {
    private static final Icon ICON = null;

    public ExportProjectStatiToDB_Action() {
        super("Werkbank - Export project stati", "Export project stati for Oracle", ICON);
        this.setIsAlwaysVisible(true);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Object p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        if (p == null) {
            return false;
        }
        p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        return p != null;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        StringBuilder bldr = new StringBuilder();
        try {
            List<SModel> allRelevantModels = MoMdlAccess.relevantModels((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), true);
            bldr.append("MoWare Werkbank - simple oracle db export for all stati  run @ " + new LocalDate() + "\n");
            bldr.append("for project " + ((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT)).getName() + "\n");
            bldr.append("\n\n");
            Object schema = "";
            schema = (String)schema + "DROP TABLE PROJECT_STATUSDECLARATIONS;\n";
            schema = (String)schema + "CREATE TABLE PROJECT_STATUSDECLARATIONS(\n";
            schema = (String)schema + " FQ_NAME VARCHAR2  (250 CHAR) /* fqName */,\n";
            schema = (String)schema + " STATUS VARCHAR2  (50 CHAR) /* status */,\n";
            schema = (String)schema + " DB_VALUE VARCHAR2  (50 CHAR) /* dbValue */,\n";
            schema = (String)schema + " SHORT_DESC VARCHAR2  (50 CHAR) /* shortDesc */,\n";
            schema = (String)schema + " LONG_DESC VARCHAR2  (50 CHAR) /* longDesc */,\n";
            schema = (String)schema + "\n";
            schema = (String)schema + " CONSTRAINT PK_PROJECT_STATUSDECLARATIONS PRIMARY KEY (FQ_NAME, STATUS)\n";
            schema = (String)schema + ");\n\n";
            bldr.append((String)schema);
            bldr.append("\n\n");
            for (SModel mod : allRelevantModels) {
                List sds = SModelOperations.nodes((SModel)mod, (SAbstractConcept)CONCEPTS.StatusDeclaration$of);
                ListSequence.fromList((List)sds).visitAll(status -> ListSequence.fromList((List)SLinkOperations.getChildren((SNode)status, (SContainmentLink)LINKS.element$GLWK)).visitAll(elem -> {
                    String shortDesc = SLinkOperations.getTarget((SNode)elem, (SContainmentLink)LINKS.shortDescNew$mKyp) == null ? "" : SPropertyOperations.getString((SNode)SLinkOperations.getTarget((SNode)elem, (SContainmentLink)LINKS.shortDescNew$mKyp), (SProperty)PROPS.value$w7MM);
                    String longDesc = SLinkOperations.getTarget((SNode)elem, (SContainmentLink)LINKS.longDescNew$pIm2) == null ? "" : SPropertyOperations.getString((SNode)SLinkOperations.getTarget((SNode)elem, (SContainmentLink)LINKS.longDescNew$pIm2), (SProperty)PROPS.value$w7MM);
                    String sql = String.format("INSERT INTO \"PROJECT_STATUSDECLARATIONS\" (FQ_NAME, STATUS, DB_VALUE, SHORT_DESC, LONG_DESC) VALUES ('%s', '%s', '%s', '%s', '%s');\n", INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(status, new Object[0]), SPropertyOperations.getString((SNode)elem, (SProperty)PROPS.name$MnvL), SPropertyOperations.getString((SNode)elem, (SProperty)PROPS.value$GToT), shortDesc, longDesc);
                    bldr.append(sql);
                }));
            }
            CopyPasteDialog dialog = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated report");
            dialog.myText.setText(bldr.toString());
            dialog.showDialog();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String((Throwable)npe), "Problem while generating report ..", 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", 0);
        }
    }

    private static final class CONCEPTS {
        static final SConcept StatusDeclaration$of = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4533072425307715669L, (String)"org.modellwerkstatt.objectflow.structure.StatusDeclaration");

        private CONCEPTS() {
        }
    }

    private static final class LINKS {
        static final SContainmentLink element$GLWK = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4533072425307715669L, (long)4533072425307715672L, (String)"element");
        static final SContainmentLink shortDescNew$mKyp = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4533072425307715670L, (long)6436022531938294753L, (String)"shortDescNew");
        static final SContainmentLink longDescNew$pIm2 = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4533072425307715670L, (long)6436022531938294806L, (String)"longDescNew");

        private LINKS() {
        }
    }

    private static final class PROPS {
        static final SProperty value$w7MM = MetaAdapterFactory.getProperty((long)-935030926396207931L, (long)-6610165693999523818L, (long)1070475926800L, (long)1070475926801L, (String)"value");
        static final SProperty name$MnvL = MetaAdapterFactory.getProperty((long)-3554657779850784990L, (long)-7236703803128771572L, (long)1169194658468L, (long)1169194664001L, (String)"name");
        static final SProperty value$GToT = MetaAdapterFactory.getProperty((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4533072425307715670L, (long)4533072425307715682L, (String)"value");

        private PROPS() {
        }
    }
}

