/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.smodel.builder.SNodeBuilder;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SLanguage;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.plugin.BldrHlpr;
import org.modellwerkstatt.objectflow.plugin.ObjHlpr;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.modellwerkstatt.objectflow.sdservices.VElement;
import org.modellwerkstatt.objectflow.sdservices.VField;
import org.modellwerkstatt.objectflow.sdservices.VList;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;

public class JsonCreator {
    private SModel mod;
    private IConvFormatOptions formatters;
    private boolean allEncompassing;
    private List<SNode> allCreatedObjects = ListSequence.fromList(new ArrayList());

    public JsonCreator(SModel m, IConvFormatOptions form, boolean all) {
        this.mod = m;
        this.formatters = form;
        this.allEncompassing = all;
    }

    private String nameFor(String name, VField.VType t) {
        if (t == VField.VType.NULL) {
            return name + "_NULL";
        }
        if (t == VField.VType.OBJECT) {
            return name + "_OBJECT";
        }
        return name;
    }

    private void createField(SNode currentObj, String name, String value, VField.VType type) {
        name = this.nameFor(name, type);
        if (type == VField.VType.NULL) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, JsonCreator._quotation_createNode_bnsruq_b0a0a0c0k(), name));
        } else if (type == VField.VType.INT) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, JsonCreator._quotation_createNode_bnsruq_b0a0a0a2a01(), name));
        } else if (type == VField.VType.STRING) {
            Object obj = JackyInfra.identifyString((IConvFormatOptions)this.formatters, (String)value);
            if (obj instanceof LocalDate) {
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, JsonCreator._quotation_createNode_bnsruq_b0a0a0e0b2a01(), name));
            } else if (obj instanceof DateTime) {
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, JsonCreator._quotation_createNode_bnsruq_b0a0a0a4a1c0k(), name));
            } else if (obj instanceof BigDecimal) {
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, JsonCreator._quotation_createNode_bnsruq_b0a0a0b4a1c0k(), name));
            } else {
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, JsonCreator._quotation_createNode_bnsruq_b0a0a0a4a1c0k_0(), name));
            }
        } else if (type == VField.VType.BIGDECIMAL) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, JsonCreator._quotation_createNode_bnsruq_b0a0a0c2a01(), name));
        } else if (type == VField.VType.BOOLEAN) {
            SNode statusType = ObjHlpr.getTrueFalseStatus((SNode)ListSequence.fromList(this.allCreatedObjects).getElement(0));
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, statusType, name));
        } else if (type == VField.VType.OBJECT) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForField(this.mod, JsonCreator._quotation_createNode_bnsruq_b0a0a0e2a01(), name));
        } else {
            throw new RuntimeException("Unknown field type " + type);
        }
    }

    private void createBuilderForField(SNode currentObj, SNode currentBuilder, String name, String value, VField.VType cls) {
        Wrappers._T _name = new Wrappers._T((Object)name);
        _name.value = this.nameFor((String)_name.value, cls);
        _name.value = ObjHlpr.ESCAPED_OBJ_NAMES((String)_name.value);
        SNode prop = (SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentObj, (SContainmentLink)LINKS.businessProperties$cI4J)).findFirst(it -> SPropertyOperations.getString((SNode)it, (SProperty)PROPS.propertyName$DLW4).equals(_name.value));
        if (cls == VField.VType.NULL) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop));
        } else if (cls == VField.VType.INT) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop, new Integer(value)));
        } else if (cls == VField.VType.STRING) {
            VField.VType type = VField.VType.STRING;
            if (SNodeOperations.isInstanceOf((SNode)SLinkOperations.getTarget((SNode)prop, (SContainmentLink)LINKS.type$56v0), (SAbstractConcept)CONCEPTS.ClassifierType$bL)) {
                type = JackyInfra.cTypeFromFQName((String)((String)INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(SLinkOperations.getTarget((SNode)SNodeOperations.cast((SNode)SLinkOperations.getTarget((SNode)prop, (SContainmentLink)LINKS.type$56v0), (SAbstractConcept)CONCEPTS.ClassifierType$bL), (SReferenceLink)LINKS.classifier$cxMr), new Object[0])));
            }
            if (type == VField.VType.LOCALDATE) {
                LocalDate date = this.formatters.parseLocalDate(value);
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop, date));
            } else if (type == VField.VType.DATETIME) {
                DateTime dt = this.formatters.parseDateTime(value);
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop, dt));
            } else if (type == VField.VType.BIGDECIMAL) {
                BigDecimal deci = this.formatters.parseBigDecimal(value);
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop, deci));
            } else {
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop, value));
            }
        } else if (cls == VField.VType.BIGDECIMAL) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop, this.formatters.parseBigDecimal(value)));
        } else if (cls == VField.VType.BOOLEAN) {
            SNode statusType = ObjHlpr.getTrueFalseStatus((SNode)ListSequence.fromList(this.allCreatedObjects).getElement(0));
            if (value.toLowerCase().equals("true")) {
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop, (SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)SLinkOperations.getTarget((SNode)statusType, (SReferenceLink)LINKS.status$PoDo), (SContainmentLink)LINKS.element$GLWK)).first()));
            } else {
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop, (SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)SLinkOperations.getTarget((SNode)statusType, (SReferenceLink)LINKS.status$PoDo), (SContainmentLink)LINKS.element$GLWK)).last()));
            }
        } else if (cls == VField.VType.OBJECT) {
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentBuilder, (SContainmentLink)LINKS.elements$1zqT)).addElement((Object)BldrHlpr.belem(prop));
        } else {
            throw new RuntimeException("Unknown field type " + cls);
        }
    }

    private SNode createObjectDtoGraph(SNode currentVo, VElement elem) {
        if (elem instanceof VObject) {
            VObject obj = (VObject)elem;
            SNode newVo = null;
            newVo = ObjHlpr.createVo(this.mod, obj);
            ListSequence.fromList(this.allCreatedObjects).addElement((Object)newVo);
            ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentVo, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForDTO(this.mod, newVo, obj.name));
            for (VElement it : obj.fields) {
                this.createObjectDtoGraph(newVo, it);
            }
            return newVo;
        }
        if (elem instanceof VList) {
            VList list = (VList)elem;
            VObject elementPrototype = list.objects.size() == 0 ? new VObject(null, null) : (VObject)list.objects.get(0);
            elementPrototype.name = MoVersion.getCapitalizedShortNameFromFQ((String)list.name);
            SNode proto = this.createObjectDtoGraph(currentVo, (VElement)elementPrototype);
            SLinkOperations.setTarget((SNode)SNodeFactoryOperations.setNewChild((SNode)((SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentVo, (SContainmentLink)LINKS.businessProperties$cI4J)).last()), (SContainmentLink)LINKS.type$56v0, (SAbstractConcept)CONCEPTS.ListType$LR), (SContainmentLink)LINKS.elementType$ssn, (SNode)ObjHlpr.ct(proto));
            if (this.allEncompassing) {
                for (int i = 1; i < list.objects.size(); ++i) {
                    VObject otherProto = (VObject)list.objects.get(i);
                    otherProto.name = elementPrototype.name;
                    this.checkAndAdd(currentVo, (VElement)otherProto);
                }
            }
        } else {
            VField fld = (VField)elem;
            this.createField(currentVo, fld.name, fld.value, fld.type);
        }
        return null;
    }

    private SNode checkAndAdd(SNode currentVo, VElement elem) {
        if (elem instanceof VObject) {
            VObject obj = (VObject)elem;
            String name = MoVersion.getCapitalizedShortNameFromFQ((String)ObjHlpr.ESCAPED_OBJ_NAMES(obj.name));
            SNode newVo = (SNode)ListSequence.fromList(this.allCreatedObjects).findFirst(it -> SPropertyOperations.getString((SNode)it, (SProperty)PROPS.name$MnvL).equals(name));
            String propName = MoVersion.getLowerShortNameFromFQ((String)obj.name);
            if (!ObjHlpr.PROP_EXISTS(currentVo, propName)) {
                ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentVo, (SContainmentLink)LINKS.businessProperties$cI4J)).addElement((Object)ObjHlpr.propForDTO(this.mod, newVo, obj.name));
            }
            for (VElement it2 : obj.fields) {
                this.checkAndAdd(newVo, it2);
            }
            return newVo;
        }
        if (elem instanceof VList) {
            VList list = (VList)elem;
            if (list.objects.size() > 0) {
                VObject elementPrototype = (VObject)list.objects.get(0);
                elementPrototype.name = MoVersion.getCapitalizedShortNameFromFQ((String)list.name);
                this.checkAndAdd(currentVo, (VElement)elementPrototype);
                for (int i = 1; i < list.objects.size(); ++i) {
                    VObject otherProto = (VObject)list.objects.get(i);
                    otherProto.name = elementPrototype.name;
                    this.checkAndAdd(currentVo, (VElement)otherProto);
                }
            }
        } else {
            VField fld = (VField)elem;
            String propName = this.nameFor(fld.name, fld.type);
            if (!ObjHlpr.PROP_EXISTS(currentVo, propName)) {
                this.createField(currentVo, fld.name, fld.value, fld.type);
            }
        }
        return null;
    }

    private void createBuilder(SNode currentVo, SNode currentBldr, VElement elem, int listElementNum) {
        if (elem instanceof VObject) {
            VObject obj = (VObject)elem;
            String voName = MoVersion.getCapitalizedShortNameFromFQ((String)ObjHlpr.ESCAPED_OBJ_NAMES(obj.name));
            SNode theVo = (SNode)ListSequence.fromList(this.allCreatedObjects).findFirst(it -> SPropertyOperations.getString((SNode)it, (SProperty)PROPS.name$MnvL).equals(voName));
            if (theVo == null) {
                throw new RuntimeException("This can not happen. Looking for obj.name '" + voName + "' but did not find anything.");
            }
            String propertyName = ObjHlpr.ESCAPED_OBJ_NAMES(MoVersion.getLowerShortNameFromFQ((String)obj.name));
            SNode prop = (SNode)ListSequence.fromList((List)SLinkOperations.getChildren((SNode)currentVo, (SContainmentLink)LINKS.businessProperties$cI4J)).findFirst(it -> SPropertyOperations.getString((SNode)it, (SProperty)PROPS.propertyName$DLW4).equals(propertyName));
            if (prop == null) {
                throw new RuntimeException("This can not happen. Looking for prop '" + propertyName + "' but did not find the property in " + SPropertyOperations.getString((SNode)currentVo, (SProperty)PROPS.name$MnvL));
            }
            if (listElementNum == -1) {
                SNode sbe = SNodeFactoryOperations.addNewChild((SNode)currentBldr, (SContainmentLink)LINKS.elements$1zqT, (SAbstractConcept)CONCEPTS.SimpleBuilderElement$6W);
                SLinkOperations.setTarget((SNode)sbe, (SReferenceLink)LINKS.property$b3UB, (SNode)prop);
                SNode newBuilder = SNodeFactoryOperations.setNewChild((SNode)sbe, (SContainmentLink)LINKS.expression$aYxg, (SAbstractConcept)CONCEPTS.BuilderExpression$5Y);
                SLinkOperations.setTarget((SNode)newBuilder, (SContainmentLink)LINKS.type$ovXx, (SNode)ObjHlpr.ct(theVo));
                for (VElement it2 : obj.fields) {
                    this.createBuilder(theVo, newBuilder, it2, -1);
                }
            } else if (listElementNum >= 0) {
                SNode lbe = SNodeFactoryOperations.addNewChild((SNode)currentBldr, (SContainmentLink)LINKS.elements$1zqT, (SAbstractConcept)CONCEPTS.ListBuilderElement$fh);
                SLinkOperations.setTarget((SNode)lbe, (SReferenceLink)LINKS.property$b3UB, (SNode)prop);
                SNode newListBuilder = SNodeFactoryOperations.setNewChild((SNode)lbe, (SContainmentLink)LINKS.expression$aYxg, (SAbstractConcept)CONCEPTS.BuilderExpression$5Y);
                SLinkOperations.setTarget((SNode)newListBuilder, (SContainmentLink)LINKS.type$ovXx, (SNode)ObjHlpr.ct(theVo));
                for (VElement it3 : obj.fields) {
                    this.createBuilder(theVo, newListBuilder, it3, -1);
                }
            }
        } else if (elem instanceof VList) {
            VList list = (VList)elem;
            for (int i = 0; i < list.objects.size(); ++i) {
                ((VObject)list.objects.get((int)i)).name = MoVersion.getCapitalizedShortNameFromFQ((String)list.name);
                this.createBuilder(currentVo, currentBldr, (VElement)list.objects.get(i), i);
            }
        } else {
            VField fld = (VField)elem;
            this.createBuilderForField(currentVo, currentBldr, fld.name, fld.value, fld.type);
        }
    }

    public void create(VObject elem) {
        JackyInfra.printDebugObject((String)"", (VElement)elem);
        SNode root = ObjHlpr.createVo(this.mod, elem);
        ListSequence.fromList(this.allCreatedObjects).addElement((Object)root);
        for (VElement it : elem.fields) {
            this.createObjectDtoGraph(root, it);
        }
        SNode factory = SNodeFactoryOperations.createNewRootNode((SModel)this.mod, (SAbstractConcept)CONCEPTS.Service$HK, null);
        SPropertyOperations.assign((SNode)factory, (SProperty)PROPS.name$MnvL, (String)"JsonRootFactory");
        SNode simd = SNodeFactoryOperations.addNewChild((SNode)factory, (SContainmentLink)LINKS.member$L_2d, (SAbstractConcept)CONCEPTS.ServiceInstanceMethodDeclaration$ww);
        ListSequence.fromList((List)SLinkOperations.getChildren((SNode)SLinkOperations.getTarget((SNode)simd, (SContainmentLink)LINKS.body$5xQk), (SContainmentLink)LINKS.statement$53DE)).clear();
        SPropertyOperations.assign((SNode)simd, (SProperty)PROPS.name$MnvL, (String)"create");
        SNode rootBuilder = BldrHlpr.configSimd(simd, root);
        for (VElement it : elem.fields) {
            this.createBuilder(root, rootBuilder, it, -1);
        }
    }

    private static SNode _quotation_createNode_bnsruq_b0a0a0a2a01() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1070534370425L, (String)"IntegerType"));
        quotedNode_1 = nb.getResult();
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_bnsruq_b0a0a0c0k() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1225271177708L, (String)"StringType"));
        quotedNode_1 = nb.getResult();
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_bnsruq_b0a0a0e0b2a01() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1107535904670L, (String)"ClassifierType"));
        quotedNode_1 = nb.getResult();
        nb.setReference(MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (long)1107535924139L, (String)"classifier"), "37fdf88a-1025-4d01-864a-0bf987f72e6f/java:org.joda.time(org.modellwerkstatt.manmap.runtime/)/~LocalDate");
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_bnsruq_b0a0a0a4a1c0k() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1107535904670L, (String)"ClassifierType"));
        quotedNode_1 = nb.getResult();
        nb.setReference(MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (long)1107535924139L, (String)"classifier"), "37fdf88a-1025-4d01-864a-0bf987f72e6f/java:org.joda.time(org.modellwerkstatt.manmap.runtime/)/~DateTime");
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_bnsruq_b0a0a0b4a1c0k() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1107535904670L, (String)"ClassifierType"));
        quotedNode_1 = nb.getResult();
        nb.setReference(MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (long)1107535924139L, (String)"classifier"), "6354ebe7-c22a-4a0f-ac54-50b52ab9b065/java:java.math(JDK/)/~BigDecimal");
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_bnsruq_b0a0a0a4a1c0k_0() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1225271177708L, (String)"StringType"));
        quotedNode_1 = nb.getResult();
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_bnsruq_b0a0a0c2a01() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1107535904670L, (String)"ClassifierType"));
        quotedNode_1 = nb.getResult();
        nb.setReference(MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (long)1107535924139L, (String)"classifier"), "6354ebe7-c22a-4a0f-ac54-50b52ab9b065/java:java.math(JDK/)/~BigDecimal");
        return quotedNode_1;
    }

    private static SNode _quotation_createNode_bnsruq_b0a0a0e2a01() {
        SNode quotedNode_1 = null;
        SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept((SLanguage)MetaAdapterFactory.getLanguage((long)-935030926396207931L, (long)-6610165693999523818L, (String)"jetbrains.mps.baseLanguage"), (long)1225271177708L, (String)"StringType"));
        quotedNode_1 = nb.getResult();
        return quotedNode_1;
    }

    private static final class LINKS {
        static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4313579457188683399L, (long)3207218222495905601L, (String)"businessProperties");
        static final SContainmentLink elements$1zqT = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6135709767654760052L, (long)6135709767654760053L, (String)"elements");
        static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1201370618622L, (long)1201371521209L, (String)"type");
        static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (long)1107535924139L, (String)"classifier");
        static final SReferenceLink status$PoDo = MetaAdapterFactory.getReferenceLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4533072425307800381L, (long)6600213247848012755L, (String)"status");
        static final SContainmentLink element$GLWK = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4533072425307715669L, (long)4533072425307715672L, (String)"element");
        static final SContainmentLink elementType$ssn = MetaAdapterFactory.getContainmentLink((long)-8968771020793164004L, (long)-7182180101671965361L, (long)1151688443754L, (long)1151688676805L, (String)"elementType");
        static final SReferenceLink property$b3UB = MetaAdapterFactory.getReferenceLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)3860064244070526091L, (long)3860064244073851670L, (String)"property");
        static final SContainmentLink expression$aYxg = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)3860064244070526091L, (long)3860064244073851668L, (String)"expression");
        static final SContainmentLink type$ovXx = MetaAdapterFactory.getContainmentLink((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6135709767654760052L, (long)8174619299762601960L, (String)"type");
        static final SContainmentLink member$L_2d = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107461130800L, (long)5375687026011219971L, (String)"member");
        static final SContainmentLink body$5xQk = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1068580123132L, (long)1068580123135L, (String)"body");
        static final SContainmentLink statement$53DE = MetaAdapterFactory.getContainmentLink((long)-935030926396207931L, (long)-6610165693999523818L, (long)1068580123136L, (long)1068581517665L, (String)"statement");

        private LINKS() {
        }
    }

    private static final class CONCEPTS {
        static final SConcept ClassifierType$bL = MetaAdapterFactory.getConcept((long)-935030926396207931L, (long)-6610165693999523818L, (long)1107535904670L, (String)"jetbrains.mps.baseLanguage.structure.ClassifierType");
        static final SConcept ListType$LR = MetaAdapterFactory.getConcept((long)-8968771020793164004L, (long)-7182180101671965361L, (long)1151688443754L, (String)"jetbrains.mps.baseLanguage.collections.structure.ListType");
        static final SConcept SimpleBuilderElement$6W = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6135709767654760054L, (String)"org.modellwerkstatt.objectflow.structure.SimpleBuilderElement");
        static final SConcept BuilderExpression$5Y = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)6135709767654760052L, (String)"org.modellwerkstatt.objectflow.structure.BuilderExpression");
        static final SConcept ListBuilderElement$fh = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)3860064244065287790L, (String)"org.modellwerkstatt.objectflow.structure.ListBuilderElement");
        static final SConcept Service$HK = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)4517030675489743647L, (String)"org.modellwerkstatt.objectflow.structure.Service");
        static final SConcept ServiceInstanceMethodDeclaration$ww = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)7919209473506305655L, (String)"org.modellwerkstatt.objectflow.structure.ServiceInstanceMethodDeclaration");

        private CONCEPTS() {
        }
    }

    private static final class PROPS {
        static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty((long)-935030926396207931L, (long)-6610165693999523818L, (long)1201370618622L, (long)1201371481316L, (String)"propertyName");
        static final SProperty name$MnvL = MetaAdapterFactory.getProperty((long)-3554657779850784990L, (long)-7236703803128771572L, (long)1169194658468L, (long)1169194664001L, (String)"name");

        private PROPS() {
        }
    }
}

