/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import org.modellwerkstatt.objectflow.plugin.JSONImportDialog;
import org.modellwerkstatt.objectflow.plugin.JsonCreator;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.modellwerkstatt.objectflow.sdservices.JackyParsed;
import org.modellwerkstatt.objectflow.sdservices.VList;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.sdservices.VParent;
import org.modellwerkstatt.objectflow.serdes.ConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.ConvStdFormatters;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;

public class JsonToDTO_Action
extends BaseAction {
    private static final Icon ICON = null;

    public JsonToDTO_Action() {
        super("Werkbank - Create DTOs from JSON", "JSON data to DTO hierarchy", ICON);
        this.setIsAlwaysVisible(true);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        Frame p = (Frame)event.getData(MPSCommonDataKeys.FRAME);
        if (p == null) {
            return false;
        }
        p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        if (p == null) {
            return false;
        }
        SModel sModel = (SModel)event.getData(MPSCommonDataKeys.MODEL);
        return true;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        SModel targetMod = (SModel)event.getData(MPSCommonDataKeys.MODEL);
        if (targetMod == null) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "Selected a model where DTOs should be put in . . . [" + event.getData(MPSCommonDataKeys.MODEL) + "]", "Wrong selection in project explorer", 0);
            return;
        }
        if (ListSequence.fromList((List)SModelOperations.roots((SModel)targetMod, (SAbstractConcept)CONCEPTS.DTO$UE)).any(it -> "ROOT".equals(SPropertyOperations.getString((SNode)it, (SProperty)PROPS.name$MnvL)))) {
            JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), "Model contains already a DTO named as ROOT. Rename that one first.", "There is already a ROOT present in the model.", 0);
            return;
        }
        JSONImportDialog dialog = new JSONImportDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Paste JSON here...");
        dialog.showDialog();
        if (dialog.isOkay()) {
            String jSonContent = dialog.myText.getText().toString();
            ConvFormatOptions options = new ConvFormatOptions(dialog.dateTimeFormat.getText(), dialog.localDateFormat.getText(), dialog.bigDeciFormat.getText(), "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
            try {
                JackyParsed parser = new JackyParsed();
                JackyInfra hlp = new JackyInfra();
                JsonCreator creator = new JsonCreator((SModel)event.getData(MPSCommonDataKeys.MODEL), (IConvFormatOptions)new ConvStdFormatters(options), dialog.allEncompassing.isSelected());
                VParent elem = parser.parse(hlp.createParser(jSonContent));
                VObject rootObject = null;
                if (elem.isList()) {
                    rootObject = (VObject)((VList)elem).objects.get(0);
                    rootObject.name = "ROOT";
                } else {
                    rootObject = (VObject)elem;
                }
                creator.create(rootObject);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog((Component)event.getData(MPSCommonDataKeys.FRAME), e.getMessage(), "Problem while parsing ... ", 0);
            }
        }
    }

    private static final class CONCEPTS {
        static final SConcept DTO$UE = MetaAdapterFactory.getConcept((long)-1438478098872647182L, (long)-8899840368585285001L, (long)5225022991485184063L, (String)"org.modellwerkstatt.objectflow.structure.DTO");

        private CONCEPTS() {
        }
    }

    private static final class PROPS {
        static final SProperty name$MnvL = MetaAdapterFactory.getProperty((long)-3554657779850784990L, (long)-7236703803128771572L, (long)1169194658468L, (long)1169194664001L, (String)"name");

        private PROPS() {
        }
    }
}

