/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.workbench.action.ActionAccess;
import jetbrains.mps.workbench.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import org.jetbrains.mps.openapi.module.SModule;
import org.modellwerkstatt.manmap.conventions.ISqlTableDescriberVendor;
import org.modellwerkstatt.manmap.conventions.MySqlVendor;
import org.modellwerkstatt.manmap.conventions.OracleVendor;
import org.modellwerkstatt.manmap.conventions.SqlTableDescriber;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import org.modellwerkstatt.objectflow.plugin.SchemaExportDialog;

public class MoWareSchemaExport_Action
extends BaseAction {
    private static final Icon ICON = null;

    public MoWareSchemaExport_Action() {
        super("Werkbank - Schema export", "Generate schema info", ICON);
        this.setIsAlwaysVisible(true);
        this.setActionAccess((ActionAccess)ActionAccess.UNDO_PROJECT);
        this.updateInBackground(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean collectActionData(AnActionEvent event, Map<String, Object> _params) {
        if (!super.collectActionData(event, _params)) {
            return false;
        }
        MPSProject p = (MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT);
        if (p == null) {
            return false;
        }
        List list = (List)event.getData(MPSCommonDataKeys.MODULES);
        list = (SNode)event.getData(MPSCommonDataKeys.NODE);
        list = (SModel)event.getData(MPSCommonDataKeys.CONTEXT_MODEL);
        return true;
    }

    public void doExecute(@NotNull AnActionEvent event, Map<String, Object> _params) {
        try {
            IListSequence persDescriptions = ListSequence.fromList(new ArrayList());
            Wrappers._T sourceDescription = new Wrappers._T((Object)"");
            if (event.getData(MPSCommonDataKeys.NODE) != null && ((SNode)event.getData(MPSCommonDataKeys.NODE)).isInstanceOfConcept((SAbstractConcept)CONCEPTS.PersistenceDescription$pP)) {
                ListSequence.fromList((List)persDescriptions).addElement((Object)SNodeOperations.cast((SNode)((SNode)event.getData(MPSCommonDataKeys.NODE)), (SAbstractConcept)CONCEPTS.PersistenceDescription$pP));
                sourceDescription.value = INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(SNodeOperations.cast((SNode)((SNode)event.getData(MPSCommonDataKeys.NODE)), (SAbstractConcept)CONCEPTS.PersistenceDescription$pP), new Object[0]);
            } else if (event.getData(MPSCommonDataKeys.CONTEXT_MODEL) != null) {
                List pds = SModelOperations.roots((SModel)((SModel)event.getData(MPSCommonDataKeys.CONTEXT_MODEL)), (SAbstractConcept)CONCEPTS.PersistenceDescription$pP);
                if (ListSequence.fromList((List)pds).count() > 0) {
                    ListSequence.fromList((List)persDescriptions).addSequence((ISequence)ListSequence.fromList((List)pds));
                    ListSequence.fromList((List)pds).visitAll(it -> {
                        sourceDescription.value = sourceDescription.value + (String)INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(it, new Object[0]) + "\n";
                    });
                }
            } else if (event.getData(MPSCommonDataKeys.MODULES) != null && ((List)event.getData(MPSCommonDataKeys.MODULES)).size() > 0) {
                for (SModule singleModule : (List)event.getData(MPSCommonDataKeys.MODULES)) {
                    for (SModel mod : singleModule.getModels()) {
                        List pds = SModelOperations.roots((SModel)mod, (SAbstractConcept)CONCEPTS.PersistenceDescription$pP);
                        if (ListSequence.fromList((List)pds).count() <= 0) continue;
                        ListSequence.fromList((List)persDescriptions).addSequence((ISequence)ListSequence.fromList((List)pds));
                        ListSequence.fromList((List)pds).visitAll(it -> {
                            sourceDescription.value = sourceDescription.value + (String)INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(it, new Object[0]) + "\n";
                        });
                    }
                }
            }
            if (ListSequence.fromList((List)persDescriptions).count() == 0) {
                JOptionPane.showMessageDialog(null, "No PersistanceDescriptions found, select a single one or one+ solutions.", "Serious problem", 0);
            } else {
                SchemaExportDialog dlg = new SchemaExportDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Schema/Alters Export", "persistence descriptions");
                dlg.setDescriptionsText((List<SNode>)persDescriptions);
                dlg.showDialog();
                if (dlg.isOkay()) {
                    Wrappers._T resultSt = new Wrappers._T((Object)"");
                    if (dlg.isResultSelected(SchemaExportDialog.ResultSelection.ORACLE_SCHEMA)) {
                        desc = new SqlTableDescriber((ISqlTableDescriberVendor)new OracleVendor());
                        ListSequence.fromList((List)persDescriptions).visitAll(it -> {
                            resultSt.value = resultSt.value + desc.getSchemaForPersistenceDesc(it) + "\n\n";
                        });
                    } else if (dlg.isResultSelected(SchemaExportDialog.ResultSelection.MYSQL_SCHEMA)) {
                        desc = new SqlTableDescriber((ISqlTableDescriberVendor)new MySqlVendor());
                        ListSequence.fromList((List)persDescriptions).visitAll(it -> {
                            resultSt.value = resultSt.value + desc.getSchemaForPersistenceDesc(it) + "\n\n";
                        });
                    } else if (dlg.isResultSelected(SchemaExportDialog.ResultSelection.ORACLE_ALTER)) {
                        desc = new SqlTableDescriber((ISqlTableDescriberVendor)new OracleVendor());
                        ListSequence.fromList((List)persDescriptions).visitAll(it -> {
                            resultSt.value = resultSt.value + desc.getAlterForPersistenceDesc(it) + "\n\n";
                        });
                    } else if (dlg.isResultSelected(SchemaExportDialog.ResultSelection.MYSQL_ALTER)) {
                        desc = new SqlTableDescriber((ISqlTableDescriberVendor)new MySqlVendor());
                        ListSequence.fromList((List)persDescriptions).visitAll(it -> {
                            resultSt.value = resultSt.value + desc.getAlterForPersistenceDesc(it) + "\n\n";
                        });
                    } else {
                        throw new RuntimeException("This can not happen.");
                    }
                    CopyPasteDialog resultDlg = new CopyPasteDialog((MPSProject)event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated result", (String)resultSt.value);
                    resultDlg.showDialog();
                }
            }
        }
        catch (Exception e) {
            System.err.println("\n\n\n ------ SERIOUS Problem while generating schema -----------------------------------------\n");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "A problem occurred while trying to generate sql schema!\n\n" + e.getMessage() + "\n\n\n", "Serious problem", 0);
        }
    }

    private static final class CONCEPTS {
        static final SConcept PersistenceDescription$pP = MetaAdapterFactory.getConcept((long)6533198583024797571L, (long)-5622828788674067564L, (long)871579071900124823L, (String)"org.modellwerkstatt.manmap.structure.PersistenceDescription");

        private CONCEPTS() {
        }
    }
}

