/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.plugin;

import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import jetbrains.mps.project.MPSProject;
import org.jetbrains.mps.openapi.model.SNode;

public class SchemaExportDialog
extends DialogBuilder {
    private JComponent myComponent;
    public JTextArea textArea;
    public JComboBox selectedOptions = new JComboBox();
    private boolean isOkayButton = false;

    public SchemaExportDialog(MPSProject project, String title, String nodeName) {
        super(project.getProject());
        this.selectedOptions.addItem("Oracle schema for " + nodeName);
        this.selectedOptions.addItem("Oracle alters for " + nodeName);
        this.selectedOptions.addItem("MySql schema for " + nodeName);
        this.selectedOptions.addItem("MySql alters for " + nodeName);
        this.textArea = new JTextArea("");
        this.myComponent = this.createPanel();
        this.setCenterPanel(this.myComponent);
        this.myComponent.setMinimumSize(new Dimension(600, 400));
        this.setTitle(title);
    }

    protected JComponent getMainComponent() {
        return this.myComponent;
    }

    public JComponent createPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.selectedOptions, "North");
        panel.add((Component)this.textArea, "Center");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel);
        scrollPane.getVerticalScrollBar().setBlockIncrement(40);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.getHorizontalScrollBar().setBlockIncrement(40);
        return scrollPane;
    }

    public void setDescriptionsText(List<SNode> allPds) {
        Wrappers._T text = new Wrappers._T((Object)"");
        ListSequence.fromList(allPds).visitAll(it -> {
            text.value = text.value + (String)INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(it, new Object[0]) + "\n";
        });
        this.textArea.setText((String)text.value);
    }

    public boolean isOkay() {
        return this.isOkayButton;
    }

    public boolean isResultSelected(ResultSelection sel) {
        switch (this.selectedOptions.getSelectedIndex()) {
            case 0: {
                return sel.equals((Object)ResultSelection.ORACLE_SCHEMA);
            }
            case 1: {
                return sel.equals((Object)ResultSelection.ORACLE_ALTER);
            }
            case 2: {
                return sel.equals((Object)ResultSelection.MYSQL_SCHEMA);
            }
            case 3: {
                return sel.equals((Object)ResultSelection.MYSQL_ALTER);
            }
        }
        throw new RuntimeException("This can not happen");
    }

    public void showDialog() {
        this.isOkayButton = super.showAndGet();
    }

    public static enum ResultSelection {
        ORACLE_SCHEMA,
        ORACLE_ALTER,
        MYSQL_SCHEMA,
        MYSQL_ALTER;

    }
}

