/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.image.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.image.loader.ImageBarcode;
import org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;
import org.krysalis.barcode4j.tools.PageInfo;
import org.krysalis.barcode4j.tools.VariableUtil;

public class ImageConverterBarcode2G2D
extends AbstractImageConverter {
    public Image convert(Image src, Map hints) throws ImageException {
        this.checkSourceFlavor(src);
        ImageBarcode barcodeImage = (ImageBarcode)src;
        Configuration cfg = barcodeImage.getBarcodeXML();
        int orientation = BarcodeDimension.normalizeOrientation(cfg.getAttributeAsInteger("orientation", 0));
        try {
            String msg = barcodeImage.getMessage();
            PageInfo pageInfo = PageInfo.fromProcessingHints(hints);
            String expandedMsg = VariableUtil.getExpandedMessage(pageInfo, msg);
            BarcodeGenerator bargen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg);
            Graphics2DImagePainterBarcode painter = new Graphics2DImagePainterBarcode(barcodeImage, bargen, expandedMsg, orientation);
            ImageGraphics2D g2dImage = new ImageGraphics2D(src.getInfo(), (Graphics2DImagePainter)painter);
            return g2dImage;
        }
        catch (ConfigurationException ce) {
            throw new ImageException("Error in Barcode XML", (Throwable)ce);
        }
        catch (BarcodeException be) {
            throw new ImageException("Error while converting barcode to Java2D", (Throwable)be);
        }
    }

    public ImageFlavor getSourceFlavor() {
        return ImageBarcode.BARCODE_IMAGE_FLAVOR;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    private static class Graphics2DImagePainterBarcode
    implements Graphics2DImagePainter {
        private ImageBarcode barcodeImage;
        private BarcodeGenerator bargen;
        private int orientation;
        private String msg;

        public Graphics2DImagePainterBarcode(ImageBarcode barcodeImage, BarcodeGenerator bargen, String msg, int orientation) {
            this.barcodeImage = barcodeImage;
            this.bargen = bargen;
            this.msg = msg;
            this.orientation = orientation;
        }

        public Dimension getImageSize() {
            return this.barcodeImage.getSize().getDimensionMpt();
        }

        public void paint(Graphics2D g2d, Rectangle2D area) {
            double w = area.getWidth();
            double h = area.getHeight();
            g2d.translate(area.getX(), area.getY());
            BarcodeDimension bardim = this.barcodeImage.getBarcodeDimension();
            double bsx = w / bardim.getWidthPlusQuiet(this.orientation);
            double bsy = h / bardim.getHeightPlusQuiet(this.orientation);
            g2d.scale(bsx, bsy);
            g2d.setColor(Color.BLACK);
            Java2DCanvasProvider canvas = new Java2DCanvasProvider(g2d, this.orientation);
            this.bargen.generateBarcode(canvas, this.msg);
        }
    }
}

