/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.javaxbus;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import mjson.Json;
import org.modellwerkstatt.javaxbus.IOSocketService;

public class NonBlockingIO
implements IOSocketService {
    public static final int DEFAULT_READ_BUFFER_SIZE = 16000;
    private SocketAddress address;
    private SocketChannel socketChannel;
    private Selector selector;
    private SelectionKey selectionKey;
    private Charset utf8Charset = Charset.forName("UTF-8");
    private ByteBuffer readBuffer;

    @Override
    public void init(String hostname, int port) throws IOException {
        this.readBuffer = ByteBuffer.allocate(16000);
        this.address = new InetSocketAddress(hostname, port);
        this.socketChannel = SocketChannel.open(this.address);
        this.socketChannel.configureBlocking(false);
        this.selector = Selector.open();
        this.selectionKey = this.socketChannel.register(this.selector, 1);
    }

    @Override
    public void writeToStream(Json msg) throws IOException {
        String jsonPayLoad = msg.toString();
        byte[] asBytes = jsonPayLoad.getBytes(this.utf8Charset);
        ByteBuffer buffer = ByteBuffer.allocate(asBytes.length + 4);
        buffer.putInt(asBytes.length);
        buffer.put(asBytes);
        buffer.flip();
        this.socketChannel.write(buffer);
    }

    @Override
    public Json readFormStream() throws IOException {
        int channelsRead = this.selector.select();
        this.readBuffer.clear();
        this.readBuffer.limit(4);
        while (this.readBuffer.hasRemaining()) {
            if (this.socketChannel.read(this.readBuffer) != -1) continue;
            throw new EOFException("Socket closed, read returned -1");
        }
        this.readBuffer.rewind();
        int length = this.readBuffer.getInt();
        this.readBuffer.clear();
        this.readBuffer.limit(length);
        while (this.readBuffer.hasRemaining()) {
            if (this.socketChannel.read(this.readBuffer) != -1) continue;
            throw new EOFException("Socket closed, read returned -1");
        }
        this.readBuffer.flip();
        byte[] bytesForString = new byte[length];
        this.readBuffer.get(bytesForString, 0, length);
        String jsonMsg = new String(bytesForString, "UTF-8");
        return Json.read(jsonMsg);
    }

    @Override
    public void close() throws IOException {
        this.selector.close();
        this.socketChannel.close();
    }
}

