/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.javaxbus;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.Charset;
import mjson.Json;
import org.modellwerkstatt.javaxbus.IOSocketService;

public class TraditionalSocketIO
implements IOSocketService {
    private Socket socket;
    private DataInputStream reader;
    private DataOutputStream writer;
    private Charset utf8Charset = Charset.forName("UTF-8");

    @Override
    public void init(String hostname, int port) throws IOException {
        this.socket = new Socket(hostname, port);
        this.reader = new DataInputStream(this.socket.getInputStream());
        this.writer = new DataOutputStream(this.socket.getOutputStream());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.writer.close();
        this.socket.close();
    }

    @Override
    public synchronized void writeToStream(Json msg) throws IOException {
        String jsonPayLoad = msg.toString();
        byte[] asBytes = jsonPayLoad.getBytes(this.utf8Charset);
        this.writer.writeInt(asBytes.length);
        this.writer.write(asBytes);
    }

    @Override
    public Json readFormStream() throws IOException {
        int len = this.reader.readInt();
        byte[] message = new byte[len];
        this.reader.readFully(message, 0, len);
        String jsonMsg = new String(message, "UTF-8");
        return Json.read(jsonMsg);
    }
}

