/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.runtime;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.manmap.runtime.IM3ClassMapper;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.modellwerkstatt.manmap.runtime.IM3DynamicTableEvaluator;
import org.modellwerkstatt.manmap.runtime.IM3Entity;
import org.modellwerkstatt.manmap.runtime.IM3Session;
import org.modellwerkstatt.manmap.runtime.IM3Status;
import org.modellwerkstatt.manmap.runtime.IM3TypeHandler;
import org.modellwerkstatt.manmap.runtime.MMAdditionalInfoException;
import org.modellwerkstatt.manmap.runtime.MMObjectKeyStore;
import org.modellwerkstatt.manmap.runtime.ManmapIDEDebug;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

public abstract class MMClassMapper<Key, Entity extends IM3Entity<Key>>
implements IM3ClassMapper<Key, Entity> {
    @Autowired
    @Qualifier(value="_dateTimeTypeHandler")
    protected IM3TypeHandler<DateTime> __dateTimeTypeHandler;
    @Autowired
    @Qualifier(value="_localDateTypeHandler")
    protected IM3TypeHandler<LocalDate> __localDateTypeHandler;
    @Autowired
    @Qualifier(value="_bigDecimalTypeHandler")
    protected IM3TypeHandler<BigDecimal> __bigDecimalTypeHandler;
    @Autowired
    @Qualifier(value="_stringTypeHandler")
    protected IM3TypeHandler<String> __stringTypeHandler;
    @Autowired
    @Qualifier(value="_intTypeHandler")
    protected IM3TypeHandler<Integer> __intTypeHandler;
    @Autowired
    @Qualifier(value="_byteArrayTypeHandler")
    protected IM3TypeHandler<byte[]> __byteArrayTypeHandler;
    @Autowired
    protected IM3DatabaseDescription __dbDesc;
    @Autowired
    protected JdbcTemplate __jdbcTemplate;
    protected String __mapperFqName;
    protected String __classFqName;
    protected String __defaultTableName;

    public MMClassMapper(String mapperFqName, String classFqName, String dfltTable) {
        this.__mapperFqName = mapperFqName;
        this.__classFqName = classFqName;
        this.__defaultTableName = dfltTable;
    }

    @Override
    public String getEntityFQName() {
        return this.__classFqName;
    }

    protected abstract String getTableNameFromRef(String var1);

    @Override
    public String getCurrentTableName(IM3DynamicTableEvaluator[] evaluators) {
        if (evaluators == null || evaluators.length == 0) {
            return this.__defaultTableName;
        }
        for (int i = 0; i < evaluators.length; ++i) {
            if (!evaluators[i].useTableRefName()) continue;
            return this.getTableNameFromRef(evaluators[i].getTableRefName());
        }
        return this.__defaultTableName;
    }

    protected abstract void setParametersInsert(Entity var1, PreparedStatement var2, StringBuilder var3) throws SQLException;

    protected abstract void setParametersUpdate(Entity var1, PreparedStatement var2, StringBuilder var3) throws SQLException;

    protected abstract void doUpdateAuditForEntity(Entity var1, IM3Session var2);

    protected abstract void doInsertAuditForEntity(Entity var1, IM3Session var2);

    public void __insert(Entity entity, boolean audit, String sql, SequenceSetter<Entity> seqSetter, IM3Session session, Object debugTextOrNull) {
        StringBuilder paramInfo = new StringBuilder("Parameters:\n");
        if (entity.getReadOnly()) {
            throw new IllegalStateException("Insert called on entity which was marked as readonly. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
        }
        if (!entity.getDirty()) {
            throw new IllegalStateException("Insert called on entity which was not marked as dirty. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
        }
        entity.beforeSave();
        if (audit) {
            this.doInsertAuditForEntity(entity, session);
        }
        int retValue = 0;
        try {
            if (this.__dbDesc.needsSequenceSelectPre()) {
                seqSetter.setValues(entity);
            }
            if (debugTextOrNull != null) {
                ManmapIDEDebug.printDebugMsgToIDE(debugTextOrNull + ": " + sql + "\nfor " + this.getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN());
            }
            retValue = this.__jdbcTemplate.update(sql, new PreparedStatementSetter(){
                final /* synthetic */ IM3Entity val$entity;
                final /* synthetic */ StringBuilder val$paramInfo;
                {
                    this.val$entity = iM3Entity;
                    this.val$paramInfo = stringBuilder;
                }

                public void setValues(PreparedStatement preparedStatement) throws SQLException {
                    MMClassMapper.this.setParametersInsert(this.val$entity, preparedStatement, this.val$paramInfo);
                }
            });
            if (this.__dbDesc.needsIdSelectPost()) {
                seqSetter.setValues(entity);
            }
            if (session != null) {
                MMObjectKeyStore keyStore = session.getOrCreateKeyStore(this.getEntitySessionUID());
                Object existingEntity = keyStore.get(entity.getIM3Key());
                if (existingEntity != null) {
                    throw new IllegalStateException("Entity " + this.getEntityFQName() + " (key " + entity.getIM3Key() + ") was already checked out as r/o or r/w, insert no possible");
                }
                keyStore.set(entity.getIM3Key(), entity);
            }
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("INSERT() led to an exception due to " + this.getEntityFQName() + " (key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + ")\n" + paramInfo.toString()));
            throw dae;
        }
        if (retValue != 1) {
            throw new IncorrectResultSetColumnCountException("INSERT() " + this.getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + " (" + retValue + " rows affected).", 1, retValue);
        }
    }

    public void __update(Entity entity, boolean audit, String sql, IM3Session session, Object debugTextOrNull) {
        StringBuilder paramInfo = new StringBuilder("Parameters:\n");
        if (entity.getReadOnly()) {
            throw new IllegalStateException("Update called on entity which was marked as readonly. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
        }
        entity.beforeSave();
        if (audit) {
            this.doUpdateAuditForEntity(entity, session);
        }
        int retValue = 0;
        try {
            if (debugTextOrNull != null) {
                ManmapIDEDebug.printDebugMsgToIDE(debugTextOrNull + ": " + sql + "\nfor " + this.getEntityFQName() + " - key " + entity.getIM3Key() + ", tcn " + entity.getTCN());
            }
            retValue = this.__jdbcTemplate.update(sql, new PreparedStatementSetter(){
                final /* synthetic */ IM3Entity val$entity;
                final /* synthetic */ StringBuilder val$paramInfo;
                {
                    this.val$entity = iM3Entity;
                    this.val$paramInfo = stringBuilder;
                }

                public void setValues(PreparedStatement preparedStatement) throws SQLException {
                    MMClassMapper.this.setParametersUpdate(this.val$entity, preparedStatement, this.val$paramInfo);
                }
            });
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("UPDATE() led to an exception due to " + this.getEntityFQName() + " (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")\n" + paramInfo.toString()));
            throw dae;
        }
        if (retValue != 1) {
            throw new IncorrectResultSetColumnCountException("UPDATE() " + this.getEntityFQName() + " - key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + " (" + retValue + " rows affected).", 1, retValue);
        }
        entity.setTCN(entity.getTCN() + 1);
    }

    public void __batchInsert(final List<Entity> listOfEntities, final int numOfEntities, String sql, IM3Session session, Object debugTextOrNull) {
        StringBuilder paramInfo = new StringBuilder("Batch Insert - Can not provide parameters.\n");
        try {
            if (debugTextOrNull != null) {
                ManmapIDEDebug.printDebugMsgToIDE(debugTextOrNull + ": " + sql + "\nfor " + this.getEntityFQName() + " - batch insert for " + numOfEntities + " entities.");
            }
            int[] retValue = this.__jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement preparedStatement, int num) throws SQLException {
                    MMClassMapper.this.setParametersInsert((IM3Entity)listOfEntities.get(num), preparedStatement, null);
                }

                public int getBatchSize() {
                    return numOfEntities;
                }
            });
            for (int i = 0; i < retValue.length; ++i) {
                if (retValue[i] == 1) continue;
                throw new IncorrectResultSetColumnCountException("BATCH INSERT() " + this.getEntityFQName() + " - index pos " + i + ", key[" + i + "] " + ((IM3Entity)listOfEntities.get(i)).getIM3Key() + " ,tcn[" + i + "] " + ((IM3Entity)listOfEntities.get(i)).getTCN() + " (" + retValue[i] + " rows affected).", 1, retValue[i]);
            }
            if (session != null) {
                MMObjectKeyStore keyStore = session.getOrCreateKeyStore(this.getEntitySessionUID());
                for (IM3Entity newEntity : listOfEntities) {
                    Object existingEntity = keyStore.get(newEntity.getIM3Key());
                    if (existingEntity != null) {
                        throw new IllegalStateException("Entity " + this.getEntityFQName() + " (key " + newEntity.getIM3Key() + ") was already checked out as r/o or r/w, insert no possible");
                    }
                    keyStore.set(newEntity.getIM3Key(), newEntity);
                }
            }
        }
        catch (UncategorizedSQLException uncat) {
            uncat.addSuppressed((Throwable)new MMAdditionalInfoException("BATCH INSERT() led to an UncategorizedSQLException updating " + this.getEntityFQName() + " (" + listOfEntities.size() + " entities): " + uncat.getMessage() + "\n" + paramInfo.toString()));
            throw uncat;
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("BATCH INSERT() led to an exception while inserting " + this.getEntityFQName() + " (" + listOfEntities.size() + " entities)\n" + paramInfo.toString()));
            throw dae;
        }
    }

    public void __batchUpdate(final List<Entity> listOfEntities, boolean audit, String sql, IM3Session session, Object debugTextOrNull) {
        final int numOfEntities = listOfEntities.size();
        StringBuilder paramInfo = new StringBuilder("Batch Update - Can not provide parameters.\n");
        for (IM3Entity entity : listOfEntities) {
            if (entity.getReadOnly()) {
                throw new IllegalStateException("Batch update called on entity which was marked as readonly. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
            }
            entity.beforeSave();
            if (!audit) continue;
            this.doUpdateAuditForEntity(entity, session);
        }
        try {
            int[] retValue;
            if (debugTextOrNull != null) {
                ManmapIDEDebug.printDebugMsgToIDE(debugTextOrNull + ": " + sql + "\nfor " + this.getEntityFQName() + " - batch insert for " + numOfEntities + " entities.");
            }
            if (numOfEntities != (retValue = this.__jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement preparedStatement, int num) throws SQLException {
                    MMClassMapper.this.setParametersUpdate((IM3Entity)listOfEntities.get(num), preparedStatement, null);
                }

                public int getBatchSize() {
                    return numOfEntities;
                }
            })).length) {
                throw new IncorrectResultSetColumnCountException("BATCH UPDATE() " + this.getEntityFQName() + " - update of " + numOfEntities + " entities resulted in " + retValue.length + " batch update return values.", numOfEntities, retValue.length);
            }
            for (int i = 0; i < retValue.length; ++i) {
                if (retValue[i] == 1) continue;
                throw new IncorrectResultSetColumnCountException("BATCH UPDATE() " + this.getEntityFQName() + " - index pos " + i + ", key[" + i + "] " + ((IM3Entity)listOfEntities.get(i)).getIM3Key() + ", tcn[" + i + "] " + ((IM3Entity)listOfEntities.get(i)).getTCN() + " (" + retValue[i] + " rows affected).", 1, retValue[i]);
            }
            for (IM3Entity entity : listOfEntities) {
                entity.setTCN(entity.getTCN() + 1);
            }
        }
        catch (UncategorizedSQLException uncat) {
            uncat.addSuppressed((Throwable)new MMAdditionalInfoException("BATCH UPDATE() led to an UncategorizedSQLException updating " + this.getEntityFQName() + " (" + listOfEntities.size() + " entities): " + uncat.getMessage() + "\n" + paramInfo.toString()));
            throw uncat;
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("BATCH UPDATE() led to an exception updating " + this.getEntityFQName() + " (" + listOfEntities.size() + " entities)\n" + paramInfo.toString()));
            throw dae;
        }
    }

    public void __delete(Entity entity, String sql, PreparedStatementSetter setter, IM3Session session, Object debugTextOrNull, StringBuilder paramInfo) {
        MMObjectKeyStore keyStore;
        if (entity.getReadOnly()) {
            throw new IllegalStateException("Delete called on entity which was marked as readonly. (key " + entity.getIM3Key() + ")");
        }
        try {
            int retValue;
            if (debugTextOrNull != null) {
                ManmapIDEDebug.printDebugMsgToIDE(debugTextOrNull + ": " + sql + "\nfor " + this.getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN());
            }
            if ((retValue = this.__jdbcTemplate.update(sql, setter)) != 1) {
                throw new IncorrectResultSetColumnCountException("DELETE() " + this.getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + " (" + retValue + " rows affected).", 1, retValue);
            }
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("DELETE() led to an exception due to " + this.getEntityFQName() + " (key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + ")\n" + paramInfo.toString()));
            throw dae;
        }
        if (session != null && (keyStore = session.getOrCreateKeyStore(this.getEntitySessionUID())).has(entity.getIM3Key())) {
            keyStore.removeEntity(entity);
        }
    }

    public void __reload(Entity entity, String sql, PreparedStatementSetter setter, RowMapper mapper, IM3Session session, Object debugTextOrNull, StringBuilder paramInfo) {
        boolean wasReadOnly = entity.getReadOnly();
        try {
            List objects;
            if (wasReadOnly) {
                entity.setReadOnly(false);
            }
            if (debugTextOrNull != null) {
                ManmapIDEDebug.printDebugMsgToIDE(debugTextOrNull + ": " + sql + "\nfor " + this.getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN());
            }
            if ((objects = this.__jdbcTemplate.query(sql, setter, mapper)).size() != 1) {
                throw new IncorrectResultSetColumnCountException("RELOAD() " + this.getEntityFQName() + " - key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + " (" + objects.size() + " object affected).", 1, objects.size());
            }
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("RELOAD() led to an exception due to " + this.getEntityFQName() + " (key " + entity.getIM3Key() + " ,tcn " + entity.getTCN() + ")\n" + paramInfo.toString()));
            throw dae;
        }
        finally {
            if (wasReadOnly) {
                entity.setReadOnly(true);
            }
        }
    }

    public Entity __get(Key key, boolean readOnly, String sql, PreparedStatementSetter setter, RowMapper mapper, IM3Session session, Object debugTextOrNull, StringBuilder paramInfo) {
        Object entity;
        MMObjectKeyStore keyStore = null;
        if (session != null && (entity = (keyStore = session.getOrCreateKeyStore(this.getEntitySessionUID())).get(key)) != null) {
            if (readOnly && entity.getReadOnly()) {
                return entity;
            }
            throw new IllegalStateException("Entity " + this.getEntityFQName() + " (key " + key + ") was already checked out as r/o or r/w");
        }
        try {
            List retObjects;
            if (debugTextOrNull != null) {
                ManmapIDEDebug.printDebugMsgToIDE(debugTextOrNull + ": " + sql + "\nfor " + this.getEntityFQName() + " - key " + key);
            }
            if ((retObjects = this.__jdbcTemplate.query(sql, setter, mapper)).size() != 1) {
                throw new IncorrectResultSetColumnCountException("GET() " + this.getEntityFQName() + " - key " + key + " ,tcn (none) (" + retObjects.size() + " objects retrieved).", 1, retObjects.size());
            }
            IM3Entity entity2 = (IM3Entity)retObjects.get(0);
            if (keyStore != null) {
                keyStore.set(key, entity2);
            }
            entity2.clearDirtySetReadonly(readOnly);
            return (Entity)entity2;
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("GET() led to an exception due to " + this.getEntityFQName() + " (key " + key + " ,tcn none)\n" + paramInfo.toString()));
            throw dae;
        }
    }

    protected void paramsIntoPreparedStatement(PreparedStatement statement, List<Object> params, StringBuilder debugSb) throws DataAccessException, SQLException {
        for (int i = 0; i < ListSequence.fromList(params).count(); ++i) {
            if (ListSequence.fromList(params).getElement(i) instanceof Integer) {
                this.__intTypeHandler.setParameter(statement, i + 1, (Integer)ListSequence.fromList(params).getElement(i), debugSb);
                continue;
            }
            if (ListSequence.fromList(params).getElement(i) instanceof String) {
                this.__stringTypeHandler.setParameter(statement, i + 1, (String)ListSequence.fromList(params).getElement(i), debugSb);
                continue;
            }
            if (ListSequence.fromList(params).getElement(i) instanceof DateTime) {
                this.__dateTimeTypeHandler.setParameter(statement, i + 1, (DateTime)ListSequence.fromList(params).getElement(i), debugSb);
                continue;
            }
            if (ListSequence.fromList(params).getElement(i) instanceof LocalDate) {
                this.__localDateTypeHandler.setParameter(statement, i + 1, (LocalDate)ListSequence.fromList(params).getElement(i), debugSb);
                continue;
            }
            if (ListSequence.fromList(params).getElement(i) instanceof BigDecimal) {
                this.__bigDecimalTypeHandler.setParameter(statement, i + 1, (BigDecimal)ListSequence.fromList(params).getElement(i), debugSb);
                continue;
            }
            if (ListSequence.fromList(params).getElement(i) instanceof byte[]) {
                this.__byteArrayTypeHandler.setParameter(statement, i + 1, (byte[])ListSequence.fromList(params).getElement(i), debugSb);
                continue;
            }
            if (ListSequence.fromList(params).getElement(i) instanceof IM3Status) {
                this.__stringTypeHandler.setParameter(statement, i + 1, ((IM3Status)ListSequence.fromList(params).getElement(i)).getDbValue(), debugSb);
                continue;
            }
            String paramAsString = "" + ListSequence.fromList(params).getElement(i);
            throw new IllegalArgumentException(this.__mapperFqName + " mapper has no typehandler for " + paramAsString + " (arg number " + i + "). Presumably argument in query was null.");
        }
    }

    @Override
    public List<Entity> query(final String fullSqlStatement, ResultSetExtractor rs, final List<Object> params) {
        final StringBuilder debugSb = new StringBuilder("Parameters:\n");
        try {
            PreparedStatementCreator psc = new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection p0) throws SQLException {
                    CallableStatement statement = p0.prepareCall(fullSqlStatement);
                    MMClassMapper.this.paramsIntoPreparedStatement(statement, params, debugSb);
                    return statement;
                }
            };
            return (List)this.__jdbcTemplate.query(psc, rs);
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("QUERY() led to an exception: " + fullSqlStatement + "\n" + debugSb.toString()));
            throw dae;
        }
    }

    @Override
    public int queryCount(final String fullSqlStatement, final List<Object> params) {
        final StringBuilder debugSb = new StringBuilder("Parameters:\n");
        try {
            PreparedStatementCreator psc = new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection p0) throws SQLException {
                    CallableStatement statement = p0.prepareCall(fullSqlStatement);
                    MMClassMapper.this.paramsIntoPreparedStatement(statement, params, debugSb);
                    return statement;
                }
            };
            int result = (Integer)this.__jdbcTemplate.query(psc, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

                public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                    int result = -1;
                    while (rs.next()) {
                        result = MMClassMapper.this.__intTypeHandler.getResult(rs, 1);
                    }
                    return result;
                }
            });
            if (result == -1) {
                throw new IncorrectResultSetColumnCountException("QUERYCOUNT() " + this.getEntityFQName() + " count() returned and empty resultset or -1 as count.", -1, -1);
            }
            return result;
        }
        catch (DataAccessException dae) {
            dae.addSuppressed((Throwable)new MMAdditionalInfoException("QUERYCOUNT() led to an exception: " + fullSqlStatement + "\n" + debugSb.toString()));
            throw dae;
        }
    }

    public static interface SequenceSetter<Ent> {
        public void setValues(Ent var1);
    }
}

